/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.EnviroDamageSource;
import enviromine.EnviroPotion;
import enviromine.client.gui.UI_Settings;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.properties.DimensionProperties;
import enviromine.trackers.properties.EntityProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;

public class EnviroDataTracker {
    public EntityLivingBase trackedEntity;
    public float prevBodyTemp = 37.0f;
    public float prevHydration = 100.0f;
    public float prevAirQuality = 100.0f;
    public float prevSanity = 100.0f;
    public float gasAirDiff = 0.0f;
    public float airQuality;
    public float bodyTemp;
    public float airTemp;
    public float hydration;
    public float sanity;
    public int attackDelay = 1;
    public int curAttackTime = 0;
    public boolean isDisabled = false;
    public int frostbiteLevel = 0;
    public boolean frostIrreversible = false;
    public boolean brokenLeg = false;
    public boolean brokenArm = false;
    public boolean bleedingOut = false;
    public String sleepState = "Awake";
    public int lastSleepTime = 0;
    public int timeBelow10 = 0;
    public int updateTimer = 0;
    private Side side = FMLCommonHandler.instance().getSide();
    public long chillPrevTime = 0L;
    public long sizzlePrevTime = 0L;

    public EnviroDataTracker(EntityLivingBase entity) {
        this.trackedEntity = entity;
        this.airQuality = 100.0f;
        this.bodyTemp = 37.0f;
        this.hydration = 100.0f;
        this.sanity = 100.0f;
    }

    public void updateData() {
        int fill;
        ItemStack plate;
        float spAmp;
        NBTTagCompound tag;
        int gasMaskFill;
        this.prevBodyTemp = this.bodyTemp;
        this.prevAirQuality = this.airQuality;
        this.prevHydration = this.hydration;
        this.prevSanity = this.sanity;
        this.updateTimer = 0;
        if (this.trackedEntity == null || this.isDisabled) {
            EM_StatusManager.removeTracker(this);
            return;
        }
        if (this.trackedEntity.field_70128_L) {
            return;
        }
        if (!(this.trackedEntity instanceof EntityPlayer) && !EM_Settings.trackNonPlayer || !EM_Settings.enableAirQ && !EM_Settings.enableBodyTemp && !EM_Settings.enableHydrate && !EM_Settings.enableSanity) {
            EM_StatusManager.saveAndRemoveTracker(this);
            return;
        }
        int i = MathHelper.func_76128_c((double)this.trackedEntity.field_70165_t);
        int k = MathHelper.func_76128_c((double)this.trackedEntity.field_70161_v);
        if (!this.trackedEntity.field_70170_p.func_72938_d((int)i, (int)k).field_76636_d) {
            return;
        }
        float[] enviroData = EM_StatusManager.getSurroundingData(this.trackedEntity, 5);
        boolean isCreative = false;
        if (this.trackedEntity instanceof EntityPlayer && ((EntityPlayer)this.trackedEntity).field_71075_bZ.field_75098_d) {
            isCreative = true;
        }
        if ((this.trackedEntity.func_110143_aJ() <= 2.0f || this.bodyTemp >= 41.0f) && enviroData[7] > (float)(-1.0 * EM_Settings.sanityMult)) {
            enviroData[7] = (float)(-1.0 * EM_Settings.sanityMult);
        } else if (this.trackedEntity.func_110143_aJ() >= this.trackedEntity.func_110138_aP() && (double)enviroData[7] < (double)0.1f * EM_Settings.sanityMult && this.trackedEntity.field_70170_p.func_72935_r() && !this.trackedEntity.field_70170_p.field_73011_w.field_76576_e && this.trackedEntity.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.trackedEntity.field_70165_t), MathHelper.func_76128_c((double)this.trackedEntity.field_70163_u), MathHelper.func_76128_c((double)this.trackedEntity.field_70161_v))) {
            enviroData[7] = (float)((double)0.1f * EM_Settings.sanityMult);
        }
        enviroData[0] = enviroData[0] + this.gasAirDiff;
        this.gasAirDiff = 0.0f;
        this.airQuality += enviroData[0];
        ItemStack helmet = this.trackedEntity.func_71124_b(4);
        if (helmet != null && !isCreative && helmet.func_77942_o() && helmet.func_77978_p().func_74764_b("gasMaskFill") && (gasMaskFill = (tag = helmet.func_77978_p()).func_74762_e("gasMaskFill")) > 0 && this.airQuality <= 99.0f) {
            int airDrop = 100 - MathHelper.func_76123_f((float)this.airQuality);
            int n = airDrop = gasMaskFill >= airDrop ? airDrop : gasMaskFill;
            if (airDrop > 0) {
                this.airQuality += (float)airDrop;
                tag.func_74768_a("gasMaskFill", gasMaskFill - airDrop);
            }
        }
        if (this.airQuality <= 0.0f) {
            this.airQuality = 0.0f;
        }
        if (this.airQuality >= 100.0f) {
            this.airQuality = 100.0f;
        }
        this.airTemp = enviroData[1];
        float tnm = enviroData[4];
        float tpm = enviroData[5];
        float relTemp = this.airTemp + 12.0f;
        if (this.bodyTemp - relTemp > 0.0f) {
            float f = spAmp = Math.abs(this.bodyTemp - relTemp) > 10.0f ? Math.abs(this.bodyTemp - relTemp) / 10.0f : 1.0f;
            this.bodyTemp = this.bodyTemp - relTemp >= tnm * spAmp ? (this.bodyTemp -= tnm * spAmp) : relTemp;
        } else if (this.bodyTemp - relTemp < 0.0f) {
            float f = spAmp = Math.abs(this.bodyTemp - relTemp) > 10.0f ? Math.abs(this.bodyTemp - relTemp) / 10.0f : 1.0f;
            this.bodyTemp = this.bodyTemp - relTemp <= -tpm * spAmp ? (this.bodyTemp += tpm * spAmp) : relTemp;
        }
        if (this.hydration > 0.0f && (enviroData[6] == 1.0f || !(this.trackedEntity instanceof EntityAnimal))) {
            if (this.bodyTemp >= 38.02f) {
                this.dehydrate(0.1f);
                if (this.hydration >= 75.0f) {
                    this.bodyTemp -= 0.01f;
                }
            }
            if (enviroData[3] > 0.0f) {
                this.dehydrate(0.05f + enviroData[3]);
            } else {
                if (enviroData[3] < 0.0f) {
                    this.hydrate(-enviroData[3]);
                }
                this.dehydrate(0.05f);
            }
        } else if (enviroData[6] == -1.0f && this.trackedEntity instanceof EntityAnimal) {
            this.hydrate(0.05f);
        } else if (this.hydration <= 0.0f) {
            this.hydration = 0.0f;
        }
        if (this.sanity < 0.0f) {
            this.sanity = 0.0f;
        }
        if (enviroData[7] < 0.0f) {
            this.sanity = this.sanity + enviroData[7] >= 0.0f ? (this.sanity += enviroData[7]) : 0.0f;
        } else if (enviroData[7] > 0.0f) {
            this.sanity = this.sanity + enviroData[7] <= 100.0f ? (this.sanity += enviroData[7]) : 100.0f;
        }
        boolean enableAirQ = true;
        boolean enableBodyTemp = true;
        boolean enableHydrate = true;
        boolean enableFrostbite = true;
        boolean enableHeat = true;
        boolean id = false;
        if (EntityProperties.base.hasProperty((Entity)this.trackedEntity)) {
            EntityProperties livingProps = EntityProperties.base.getProperty((Entity)this.trackedEntity);
            enableHydrate = livingProps.dehydration;
            enableBodyTemp = livingProps.bodyTemp;
            enableAirQ = livingProps.airQ;
            enableFrostbite = !livingProps.immuneToFrost;
            enableHeat = !livingProps.immuneToHeat;
        } else if (this.trackedEntity instanceof EntitySheep || this.trackedEntity instanceof EntityWolf) {
            enableFrostbite = false;
        } else if (this.trackedEntity instanceof EntityChicken) {
            enableHeat = false;
        }
        if (!EM_Settings.enableAirQ || !enableAirQ) {
            this.airQuality = 100.0f;
        }
        if (!EM_Settings.enableBodyTemp || !enableBodyTemp) {
            this.bodyTemp = 37.0f;
        }
        if (!EM_Settings.enableHydrate || !enableHydrate) {
            this.hydration = 100.0f;
        }
        if (!EM_Settings.enableSanity || !(this.trackedEntity instanceof EntityPlayer)) {
            this.sanity = 100.0f;
        }
        if ((plate = this.trackedEntity.func_71124_b(3)) != null && !isCreative && plate.func_77942_o() && plate.func_77978_p().func_74764_b("camelPackFill") && (fill = plate.func_77978_p().func_74762_e("camelPackFill")) > 0 && (double)this.hydration <= 100.0 - EM_Settings.hydrationMult) {
            plate.func_77978_p().func_74768_a("camelPackFill", fill - 1);
            this.hydrate((float)EM_Settings.hydrationMult);
            if ((double)this.bodyTemp >= 37.0 + EM_Settings.tempMult / 10.0) {
                this.bodyTemp = (float)((double)this.bodyTemp - EM_Settings.tempMult / 10.0);
            }
        }
        this.fixFloatinfPointErrors();
        if (this.trackedEntity instanceof EntityPlayer && ((EntityPlayer)this.trackedEntity).field_71075_bZ.field_75098_d) {
            this.bodyTemp = this.prevBodyTemp;
            this.airQuality = this.prevAirQuality;
            this.hydration = this.prevHydration;
            this.sanity = this.prevSanity;
        }
        this.timeBelow10 = this.airTemp <= 10.0f && this.bodyTemp <= 35.0f || this.bodyTemp <= 30.0f ? ++this.timeBelow10 : 0;
        if (this.curAttackTime >= this.attackDelay) {
            if (this.airQuality <= 0.0f) {
                this.trackedEntity.func_70097_a((DamageSource)EnviroDamageSource.suffocate, 4.0f);
                this.trackedEntity.field_70170_p.func_72956_a((Entity)this.trackedEntity, "enviromine:gag", 1.0f, 1.0f);
            }
            if (this.airQuality <= 10.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 1));
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 1));
            } else if (this.airQuality <= 25.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 0));
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 0));
            }
            if (!this.trackedEntity.func_70644_a(Potion.field_76426_n)) {
                if (this.bodyTemp >= 39.0f && enableHeat && EM_Settings.enableHeatstrokeGlobal && (enviroData[6] == 1.0f || !(this.trackedEntity instanceof EntityAnimal))) {
                    if (this.bodyTemp >= 43.0f) {
                        this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.heatstroke.field_76415_H, 200, 2));
                    } else if (this.bodyTemp >= 41.0f) {
                        this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.heatstroke.field_76415_H, 200, 1));
                    } else {
                        this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.heatstroke.field_76415_H, 200, 0));
                    }
                }
            } else if (this.trackedEntity.func_70644_a((Potion)EnviroPotion.heatstroke)) {
                this.trackedEntity.func_82170_o(EnviroPotion.heatstroke.field_76415_H);
            }
            if (this.bodyTemp <= 35.0f && enableFrostbite && EM_Settings.enableHypothermiaGlobal && (enviroData[6] == 1.0f || !(this.trackedEntity instanceof EntityAnimal))) {
                if (this.bodyTemp <= 30.0f) {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.hypothermia.field_76415_H, 200, 2));
                } else if (this.bodyTemp <= 32.0f) {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.hypothermia.field_76415_H, 200, 1));
                } else {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.hypothermia.field_76415_H, 200, 0));
                }
                if (this.side.isClient()) {
                    // empty if block
                }
            }
            if (enableFrostbite && EM_Settings.enableFrostbiteGlobal && (this.timeBelow10 >= 120 || this.frostbiteLevel >= 1 && this.frostIrreversible)) {
                if (this.timeBelow10 >= 240 || this.frostbiteLevel >= 2) {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.frostbite.field_76415_H, 200, 1));
                    if (this.frostbiteLevel <= 2) {
                        this.frostbiteLevel = 2;
                    }
                } else {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.frostbite.field_76415_H, 200, 0));
                    if (this.frostbiteLevel <= 1) {
                        this.frostbiteLevel = 1;
                    }
                }
                if (this.timeBelow10 > 360 && !this.frostIrreversible && EM_Settings.enableFrostbiteGlobal) {
                    this.frostIrreversible = true;
                    if (this.trackedEntity instanceof EntityPlayer) {
                        ((EntityPlayer)this.trackedEntity).func_146105_b((IChatComponent)new ChatComponentText("The flesh in your limbs have gone rock hard!"));
                        ((EntityPlayer)this.trackedEntity).func_146105_b((IChatComponent)new ChatComponentText("Your condition is now permanent!"));
                    }
                }
                if (this.side.isClient()) {
                    this.playSoundWithTimeCheck(1700, "enviromine:chill", UI_Settings.breathVolume, 1.0f);
                }
            } else if (!(this.frostIrreversible && enableFrostbite && EM_Settings.enableFrostbiteGlobal)) {
                this.frostbiteLevel = 0;
            }
            if (this.bodyTemp >= 45.0f && enviroData[2] == 1.0f || this.bodyTemp >= 50.0f) {
                this.trackedEntity.func_70015_d(10);
            }
            if (this.hydration <= 0.0f) {
                this.trackedEntity.func_70097_a((DamageSource)EnviroDamageSource.dehydrate, 4.0f);
            }
            if (this.sanity <= 10.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.insanity.field_76415_H, 600, 2));
            } else if (this.sanity <= 25.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.insanity.field_76415_H, 600, 1));
            } else if (this.sanity <= 50.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.insanity.field_76415_H, 600, 0));
            }
            this.curAttackTime = 0;
        } else {
            ++this.curAttackTime;
        }
        EnviroPotion.checkAndApplyEffects(this.trackedEntity);
        if (isCreative) {
            this.bodyTemp = this.prevBodyTemp;
            this.airQuality = this.prevAirQuality;
            this.hydration = this.prevHydration;
            this.sanity = this.prevSanity;
        }
        DimensionProperties dimensionProp = null;
        if (EM_Settings.dimensionProperties.containsKey(this.trackedEntity.field_70170_p.field_73011_w.field_76574_g) && (dimensionProp = EM_Settings.dimensionProperties.get(this.trackedEntity.field_70170_p.field_73011_w.field_76574_g)) != null && dimensionProp.override) {
            if (!dimensionProp.trackTemp && EM_Settings.enableBodyTemp) {
                this.bodyTemp = this.prevBodyTemp;
            }
            if (!dimensionProp.trackAirQuality && EM_Settings.enableAirQ) {
                this.airQuality = this.prevAirQuality;
            }
            if (!dimensionProp.trackHydration && EM_Settings.enableHydrate) {
                this.hydration = this.prevHydration;
            }
            if (!dimensionProp.trackSanity && EM_Settings.enableSanity) {
                this.sanity = this.prevSanity;
            }
        }
        this.fixFloatinfPointErrors();
        EM_StatusManager.saveTracker(this);
    }

    @SideOnly(value=Side.CLIENT)
    private void playSoundWithTimeCheck(int time, String sound, float volume, float pitch) {
        if (Minecraft.func_71386_F() - this.chillPrevTime > 17000L) {
            Minecraft.func_71410_x().field_71439_g.func_85030_a("enviromine:chill", UI_Settings.breathVolume, 1.0f);
            this.chillPrevTime = Minecraft.func_71386_F();
        }
    }

    public void fixFloatinfPointErrors() {
        this.airQuality = new BigDecimal(String.valueOf(this.airQuality)).setScale(2, RoundingMode.HALF_UP).floatValue();
        this.bodyTemp = new BigDecimal(String.valueOf(this.bodyTemp)).setScale(3, RoundingMode.HALF_UP).floatValue();
        this.airTemp = new BigDecimal(String.valueOf(this.airTemp)).setScale(3, RoundingMode.HALF_UP).floatValue();
        this.hydration = new BigDecimal(String.valueOf(this.hydration)).setScale(2, RoundingMode.HALF_UP).floatValue();
        this.sanity = new BigDecimal(String.valueOf(this.sanity)).setScale(3, RoundingMode.HALF_UP).floatValue();
    }

    public static boolean isLegalType(EntityLivingBase entity) {
        String name = EntityList.func_75621_b((Entity)entity);
        if (EntityProperties.base.hasProperty((Entity)entity)) {
            return EntityProperties.base.getProperty((Entity)entity).shouldTrack;
        }
        if (entity.func_70662_br() || entity instanceof EntityMob) {
            return false;
        }
        if (name == "Enderman") {
            return false;
        }
        if (name == "Villager") {
            return false;
        }
        if (name == "Slime") {
            return false;
        }
        if (name == "Ghast") {
            return false;
        }
        if (name == "Squid") {
            return false;
        }
        if (name == "Blaze") {
            return false;
        }
        if (name == "LavaSlime") {
            return false;
        }
        if (name == "SnowMan") {
            return false;
        }
        if (name == "MushroomCow") {
            return false;
        }
        if (name == "WitherBoss") {
            return false;
        }
        if (name == "EnderDragon") {
            return false;
        }
        if (name == "VillagerGolem") {
            return false;
        }
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entity);
        return tracker == null || tracker.isDisabled || tracker.trackedEntity != entity;
    }

    public void hydrate(float amount) {
        float MAmount = (float)((double)amount * EM_Settings.hydrationMult);
        this.hydration = this.hydration >= 100.0f - MAmount ? 100.0f : (this.hydration += MAmount);
        this.fixFloatinfPointErrors();
        if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
            EM_StatusManager.syncMultiplayerTracker(this);
        }
    }

    public void dehydrate(float amount) {
        float MAmount = (float)((double)amount * EM_Settings.hydrationMult);
        this.hydration = this.hydration >= MAmount ? (this.hydration -= MAmount) : 0.0f;
        this.fixFloatinfPointErrors();
        if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
            EM_StatusManager.syncMultiplayerTracker(this);
        }
    }

    public void loadNBTTags() {
        NBTTagCompound tags = this.trackedEntity.getEntityData();
        if (tags.func_74764_b("ENVIRO_AIR")) {
            this.airQuality = tags.func_74760_g("ENVIRO_AIR");
        }
        if (tags.func_74764_b("ENVIRO_HYD")) {
            this.hydration = tags.func_74760_g("ENVIRO_HYD");
        }
        if (tags.func_74764_b("ENVIRO_TMP")) {
            this.bodyTemp = tags.func_74760_g("ENVIRO_TMP");
        }
        if (tags.func_74764_b("ENVIRO_SAN")) {
            this.sanity = tags.func_74760_g("ENVIRO_SAN");
        }
    }

    public void resetData() {
        this.airQuality = 100.0f;
        this.bodyTemp = 37.0f;
        this.hydration = 100.0f;
        this.sanity = 100.0f;
    }

    public void ClampSafeRange() {
        this.airQuality = MathHelper.func_76131_a((float)this.airQuality, (float)25.0f, (float)100.0f);
        this.bodyTemp = MathHelper.func_76131_a((float)this.bodyTemp, (float)35.0f, (float)39.0f);
        this.hydration = MathHelper.func_76131_a((float)this.hydration, (float)25.0f, (float)100.0f);
        this.sanity = MathHelper.func_76131_a((float)this.sanity, (float)50.0f, (float)100.0f);
    }
}

