/*
 * Decompiled with CFR 0.152.
 */
package enviromine.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.trackers.properties.helpers.SerialisableProperty;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;

public class PacketServerOverride
implements IMessage {
    protected NBTTagCompound tags = new NBTTagCompound();

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    public static class Handler
    implements IMessageHandler<PacketServerOverride, IMessage> {
        public IMessage onMessage(PacketServerOverride message, MessageContext ctx) {
            Field[] fields;
            if (!EnviroMine.proxy.isClient()) {
                EnviroMine.logger.log(Level.WARN, "AutoOverride attempted to run serverside! This should not happen!");
                return null;
            }
            NBTTagCompound tags = message.tags;
            for (Field f : fields = EM_Settings.class.getDeclaredFields()) {
                try {
                    Object valObj;
                    EM_Settings.ShouldOverride anno = f.getAnnotation(EM_Settings.ShouldOverride.class);
                    if (anno == null) continue;
                    Class<?>[] clazzes = anno.value();
                    if (!f.isAccessible()) {
                        EnviroMine.logger.log(Level.WARN, "Field " + f.getName() + " is protected and cannot be synced!");
                        continue;
                    }
                    if (!Modifier.isStatic(f.getModifiers())) {
                        EnviroMine.logger.log(Level.WARN, "Cannot sync non-static field " + f.getName() + "!");
                        continue;
                    }
                    if (f.getType() == HashMap.class) {
                        if (clazzes.length < 2) {
                            EnviroMine.logger.log(Level.ERROR, "Annotation for field " + f.getName() + " (" + f.getType().getName() + ") is missing class types!");
                            continue;
                        }
                        NBTTagList nbtList = tags.func_150295_c(f.getName(), 10);
                        HashMap<Object, Object> map = new HashMap<Object, Object>();
                        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                            NBTTagCompound tag = nbtList.func_150305_b(i);
                            Object keyObj = this.getNBTValue(tag, "key", clazzes[0]);
                            valObj = this.getNBTValue(tag, "value", clazzes[1]);
                            if (keyObj == null || valObj == null) {
                                EnviroMine.logger.log(Level.WARN, "Position " + i + " in HashMap " + f.getName() + " returned a null entry! Skipping...");
                                continue;
                            }
                            map.put(keyObj, valObj);
                        }
                        f.set(null, map);
                        continue;
                    }
                    if (f.getType() == ArrayList.class) {
                        if (clazzes.length < 1) {
                            EnviroMine.logger.log(Level.ERROR, "Annotation for field " + f.getName() + " is missing class types!");
                            continue;
                        }
                        Class<?> clazz = clazzes[0];
                        NBTTagList nbtList = tags.func_150295_c(f.getName(), 10);
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                            NBTTagCompound tag = nbtList.func_150305_b(i);
                            valObj = this.getNBTValue(tag, "value", clazz);
                            if (valObj == null) {
                                EnviroMine.logger.log(Level.WARN, "Position " + i + " in ArrayList " + f.getName() + " returned a null entry! Skipping...");
                                continue;
                            }
                            list.add(valObj);
                        }
                        f.set(null, list);
                        continue;
                    }
                    Object value = this.getNBTValue(tags, f.getName(), f.getType());
                    if (value == null) {
                        EnviroMine.logger.log(Level.WARN, "Field " + f.getName() + " returned a null value! Skipping...");
                        continue;
                    }
                    f.set(null, value);
                }
                catch (Exception e) {
                    EnviroMine.logger.log(Level.ERROR, "An error occured while syncing setting " + f.getName(), (Throwable)e);
                }
            }
            EM_Settings.isOverridden = true;
            return null;
        }

        public Object getNBTValue(NBTTagCompound tag, String key, Class<?> clazz) {
            if (key == null || key.length() <= 0 || !tag.func_74764_b(key)) {
                return null;
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return tag.func_74767_n(key);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return tag.func_74762_e(key);
            }
            if (clazz == String.class) {
                return tag.func_74779_i(key);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return tag.func_74771_c(key);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(tag.func_74760_g(key));
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return tag.func_74769_h(key);
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return tag.func_74765_d(key);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return tag.func_74763_f(key);
            }
            if (clazz == Byte[].class || clazz == byte[].class) {
                return tag.func_74770_j(key);
            }
            if (clazz.isAssignableFrom(NBTBase.class)) {
                return tag.func_74781_a(key);
            }
            if (clazz.isAssignableFrom(SerialisableProperty.class)) {
                try {
                    Constructor<?> ctor = clazz.getConstructor(NBTTagCompound.class);
                    return ctor.newInstance(tag.func_74775_l(key));
                }
                catch (Exception e) {
                    EnviroMine.logger.log(Level.ERROR, "An error occured while trying to instantiate " + clazz.getSimpleName(), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }
}

