/*
 * Decompiled with CFR 0.152.
 */
package enviromine.handlers;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import enviromine.EnviroPotion;
import enviromine.client.gui.UI_Settings;
import enviromine.client.gui.hud.items.Debug_Info;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_PhysManager;
import enviromine.handlers.EnviroAchievements;
import enviromine.network.packet.PacketEnviroMine;
import enviromine.trackers.EnviroDataTracker;
import enviromine.trackers.properties.ArmorProperties;
import enviromine.trackers.properties.BiomeProperties;
import enviromine.trackers.properties.BlockProperties;
import enviromine.trackers.properties.DimensionProperties;
import enviromine.trackers.properties.EntityProperties;
import enviromine.trackers.properties.ItemProperties;
import enviromine.utils.EnviroUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.EnumPlantType;
import org.apache.logging.log4j.Level;

public class EM_StatusManager {
    public static HashMap<String, EnviroDataTracker> trackerList = new HashMap();
    private static Stopwatch timer = Stopwatch.createUnstarted();

    public static void addToManager(EnviroDataTracker tracker) {
        if (tracker.trackedEntity instanceof EntityPlayer) {
            trackerList.put("" + tracker.trackedEntity.func_70005_c_(), tracker);
        } else {
            trackerList.put("" + tracker.trackedEntity.func_145782_y(), tracker);
        }
    }

    public static void updateTracker(EnviroDataTracker tracker) {
        if (tracker == null) {
            return;
        }
        if (EnviroMine.proxy.isClient() && Minecraft.func_71410_x().func_71387_A() && Minecraft.func_71410_x().func_147113_T() && !EnviroMine.proxy.isOpenToLAN()) {
            return;
        }
        ++tracker.updateTimer;
        if (tracker.updateTimer >= 30) {
            tracker.updateData();
            if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
                EM_StatusManager.syncMultiplayerTracker(tracker);
            }
        }
    }

    public static void syncMultiplayerTracker(EnviroDataTracker tracker) {
        if (!(tracker.trackedEntity instanceof EntityPlayer)) {
            return;
        }
        tracker.fixFloatinfPointErrors();
        NBTTagCompound pData = new NBTTagCompound();
        pData.func_74768_a("id", 0);
        pData.func_74778_a("player", tracker.trackedEntity.func_70005_c_());
        pData.func_74776_a("airQuality", tracker.airQuality);
        pData.func_74776_a("bodyTemp", tracker.bodyTemp);
        pData.func_74776_a("hydration", tracker.hydration);
        pData.func_74776_a("sanity", tracker.sanity);
        pData.func_74776_a("airTemp", tracker.airTemp);
        EnviroMine.instance.network.sendToAllAround((IMessage)new PacketEnviroMine(pData), new NetworkRegistry.TargetPoint(tracker.trackedEntity.field_70170_p.field_73011_w.field_76574_g, tracker.trackedEntity.field_70165_t, tracker.trackedEntity.field_70163_u, tracker.trackedEntity.field_70161_v, 128.0));
    }

    public static EnviroDataTracker lookupTracker(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            if (trackerList.containsKey("" + entity.func_70005_c_())) {
                return trackerList.get("" + entity.func_70005_c_());
            }
            return null;
        }
        if (trackerList.containsKey("" + entity.func_145782_y())) {
            return trackerList.get("" + entity.func_145782_y());
        }
        return null;
    }

    public static EnviroDataTracker lookupTrackerFromUsername(String username) {
        if (trackerList.containsKey(username)) {
            return trackerList.get(username);
        }
        return null;
    }

    public static float[] getSurroundingData(EntityLivingBase entityLiving, int range) {
        short enLV;
        int index;
        float sanityRate;
        if (EnviroMine.proxy.isClient() && entityLiving.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && !timer.isRunning()) {
            timer.start();
        }
        float[] data = new float[8];
        float sanityStartRate = sanityRate = 0.0f;
        float quality = 0.0f;
        double leaves = 0.0;
        float sBoost = 0.0f;
        float dropSpeed = 0.001f;
        float riseSpeed = 0.001f;
        float temp = -999.0f;
        float cooling = 0.0f;
        float dehydrateBonus = 0.0f;
        int animalHostility = 0;
        boolean nearLava = false;
        float dist = 0.0f;
        float solidBlocks = 0.0f;
        int i = MathHelper.func_76128_c((double)entityLiving.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityLiving.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityLiving.field_70161_v);
        if (entityLiving.field_70170_p == null) {
            return data;
        }
        Chunk chunk = entityLiving.field_70170_p.func_72938_d(i, k);
        if (chunk == null) {
            return data;
        }
        BiomeGenBase biome = chunk.func_76591_a(i & 0xF, k & 0xF, entityLiving.field_70170_p.func_72959_q());
        if (biome == null) {
            return data;
        }
        DimensionProperties dimensionProp = null;
        if (DimensionProperties.base.hasProperty(entityLiving.field_70170_p.field_73011_w.field_76574_g)) {
            dimensionProp = DimensionProperties.base.getProperty(entityLiving.field_70170_p.field_73011_w.field_76574_g);
        }
        float surBiomeTemps = 0.0f;
        int biomeTempChecks = 0;
        boolean isDay = entityLiving.field_70170_p.func_72935_r();
        float scale = 1.25f;
        float dayPercent = MathHelper.func_76131_a((float)((float)(Math.sin(Math.toRadians((double)(entityLiving.field_70170_p.func_72820_D() % 24000L) / 24000.0 * 360.0 - 30.0)) * 0.5 + 0.5) * scale), (float)0.0f, (float)1.0f);
        if (entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            isDay = false;
        }
        int lightLev = 0;
        int blockLightLev = 0;
        if (j > 0) {
            if (j >= 256) {
                lightLev = 15;
                blockLightLev = 15;
            } else {
                lightLev = chunk.func_76614_a(EnumSkyBlock.Sky, i & 0xF, j, k & 0xF);
                blockLightLev = chunk.func_76614_a(EnumSkyBlock.Block, i & 0xF, j, k & 0xF);
            }
        }
        if (!(isDay || blockLightLev > 1 || entityLiving.func_70660_b(Potion.field_76439_r) != null || dimensionProp != null && dimensionProp.override && !dimensionProp.darkAffectSanity)) {
            sanityStartRate = -0.01f;
            sanityRate = -0.01f;
        }
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Chunk testChunk;
                    BiomeGenBase checkBiome;
                    if (y == 0 && (checkBiome = (testChunk = entityLiving.field_70170_p.func_72938_d(i + x, k + z)).func_76591_a(i + x & 0xF, k + z & 0xF, entityLiving.field_70170_p.func_72959_q())) != null) {
                        BiomeProperties biomeOverride = null;
                        if (BiomeProperties.base.hasProperty(checkBiome)) {
                            biomeOverride = BiomeProperties.base.getProperty(checkBiome);
                        }
                        surBiomeTemps = biomeOverride != null && biomeOverride.biomeOveride ? (surBiomeTemps += biomeOverride.ambientTemp) : (float)((double)surBiomeTemps + EnviroUtils.getBiomeTemp(i + x, j + y, k + z, checkBiome));
                        ++biomeTempChecks;
                    }
                    if (!EM_PhysManager.blockNotSolid(entityLiving.field_70170_p, x + i, y + j, z + k, false)) {
                        solidBlocks += 1.0f;
                    }
                    dist = (float)entityLiving.func_70011_f((double)(i + x), (double)(j + y), (double)(k + z));
                    Block block = Blocks.field_150350_a;
                    int meta = 0;
                    block = entityLiving.field_70170_p.func_147439_a(i + x, j + y, k + z);
                    if (block != Blocks.field_150350_a) {
                        meta = entityLiving.field_70170_p.func_72805_g(i + x, j + y, k + z);
                    }
                    if (BlockProperties.base.hasProperty(block, meta)) {
                        BlockProperties blockProps = BlockProperties.base.getProperty(block, meta);
                        if (blockProps.air > 0.0f) {
                            leaves += (double)(blockProps.air / 0.1f);
                        } else if (quality >= blockProps.air && blockProps.air < 0.0f && quality <= 0.0f) {
                            quality = blockProps.air;
                        }
                        if (blockProps.enableTemp) {
                            if (temp <= EM_StatusManager.getTempFalloff(blockProps.temp, dist, range) && blockProps.temp > 0.0f) {
                                temp = EM_StatusManager.getTempFalloff(blockProps.temp, dist, range);
                            } else if (blockProps.temp < 0.0f) {
                                cooling += EM_StatusManager.getTempFalloff(-blockProps.temp, dist, range);
                            }
                        }
                        if (sanityRate >= blockProps.sanity && blockProps.sanity < 0.0f && sanityRate <= 0.0f) {
                            sanityRate = blockProps.sanity;
                        } else if (sanityRate <= blockProps.sanity && blockProps.sanity > 0.0f) {
                            if (block instanceof BlockFlower) {
                                if ((isDay || entityLiving.field_70170_p.field_73011_w.field_76576_e) && sBoost < blockProps.sanity) {
                                    sBoost = blockProps.sanity;
                                }
                            } else if (sBoost < blockProps.sanity) {
                                sBoost = blockProps.sanity;
                            }
                        }
                    }
                    if (block.func_149688_o() != Material.field_151587_i) continue;
                    nearLava = true;
                }
            }
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack stack = player.field_71071_by.field_70462_a[slot];
                if (stack == null) continue;
                float stackMult = 1.0f;
                if (stack.field_77994_a > 1) {
                    stackMult = ((float)stack.field_77994_a - 1.0f) / 63.0f + 1.0f;
                }
                if (ItemProperties.base.hasProperty(stack)) {
                    ItemProperties itemProps = ItemProperties.base.getProperty(stack);
                    if (itemProps.ambAir > 0.0f) {
                        leaves += (double)(itemProps.ambAir / 0.1f * stackMult);
                    } else if (quality >= itemProps.ambAir * stackMult && itemProps.ambAir < 0.0f && quality <= 0.0f) {
                        quality = itemProps.ambAir * stackMult;
                    }
                    if (temp <= itemProps.ambTemp * stackMult && itemProps.enableTemp && itemProps.ambTemp > 0.0f) {
                        temp = itemProps.ambTemp * stackMult;
                    } else if (itemProps.enableTemp && itemProps.ambTemp < 0.0f) {
                        cooling += -itemProps.ambTemp * stackMult;
                    }
                    if (sanityRate >= itemProps.ambSanity * stackMult && itemProps.ambSanity < 0.0f && sanityRate <= 0.0f) {
                        sanityRate = itemProps.ambSanity * stackMult;
                        continue;
                    }
                    if (!(sBoost <= itemProps.ambSanity * stackMult) || !(itemProps.ambSanity > 0.0f)) continue;
                    if (stack.func_77973_b() instanceof ItemBlock) {
                        if (((ItemBlock)stack.func_77973_b()).field_150939_a instanceof BlockFlower) {
                            if (!isDay && !entityLiving.field_70170_p.field_73011_w.field_76576_e) continue;
                            sBoost = itemProps.ambSanity * stackMult;
                            continue;
                        }
                        sBoost = itemProps.ambSanity * stackMult;
                        continue;
                    }
                    sBoost = itemProps.ambSanity * stackMult;
                    continue;
                }
                if (!(stack.func_77973_b() instanceof ItemBlock)) continue;
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                if (!(itemBlock.field_150939_a instanceof BlockFlower) || !isDay && !entityLiving.field_70170_p.field_73011_w.field_76576_e || !(sBoost <= 0.1f) || ((BlockFlower)itemBlock.field_150939_a).getPlantType((IBlockAccess)entityLiving.field_70170_p, i, j, k) != EnumPlantType.Plains) continue;
                sBoost = 0.1f;
            }
        }
        if (lightLev > 1 && !entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            quality = 2.0f;
            sanityRate = 0.5f;
        } else if (sanityRate <= sanityStartRate && sanityRate > -0.1f && blockLightLev <= 1 && entityLiving.func_70660_b(Potion.field_76439_r) == null) {
            sanityRate = -0.1f;
        }
        if (dimensionProp != null && entityLiving.field_70163_u > (double)dimensionProp.sealevel * 0.75 && !entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            quality = 2.0f;
        }
        float bTemp = surBiomeTemps / (float)biomeTempChecks;
        float highTemp = -30.0f;
        float lowTemp = 30.0f;
        if (!entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            if (entityLiving.field_70163_u < 48.0) {
                if (lowTemp - bTemp > 0.0f) {
                    bTemp = (float)((double)bTemp + (double)(lowTemp - bTemp) * (1.0 - entityLiving.field_70163_u / 48.0));
                }
            } else if (entityLiving.field_70163_u > 90.0 && entityLiving.field_70163_u < 256.0) {
                if (highTemp - bTemp < 0.0f) {
                    bTemp = (float)((double)bTemp - (double)MathHelper.func_76135_e((float)(highTemp - bTemp)) * ((entityLiving.field_70163_u - 90.0) / 166.0));
                }
            } else if (entityLiving.field_70163_u >= 256.0) {
                bTemp = bTemp < highTemp ? bTemp : highTemp;
            }
        }
        bTemp -= cooling;
        if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_70608_bn()) {
            bTemp += 10.0f;
        }
        if ((dimensionProp == null || !dimensionProp.override || dimensionProp.weatherAffectsTemp) && entityLiving.field_70170_p.func_72896_J() && biome.field_76751_G != 0.0f) {
            bTemp -= 10.0f;
            animalHostility = -1;
            if (entityLiving.field_70170_p.func_72937_j(i, j, k)) {
                dropSpeed = 0.01f;
            }
        }
        if (!entityLiving.field_70170_p.func_72937_j(i, j, k) && isDay && !entityLiving.field_70170_p.func_72896_J()) {
            bTemp -= 2.5f;
        }
        if (!entityLiving.field_70170_p.field_73011_w.field_76576_e && dimensionProp == null || dimensionProp != null && dimensionProp.override && dimensionProp.dayNightTemp) {
            bTemp -= (1.0f - dayPercent) * 10.0f;
            if (biome.field_76751_G <= 0.0f) {
                bTemp -= (1.0f - dayPercent) * 30.0f;
            }
        }
        List mobList = entityLiving.field_70170_p.func_72839_b((Entity)entityLiving, AxisAlignedBB.func_72330_a((double)(entityLiving.field_70165_t - 2.0), (double)(entityLiving.field_70163_u - 2.0), (double)(entityLiving.field_70161_v - 2.0), (double)(entityLiving.field_70165_t + 3.0), (double)(entityLiving.field_70163_u + 3.0), (double)(entityLiving.field_70161_v + 3.0)));
        Iterator iterator = mobList.iterator();
        float avgEntityTemp = 0.0f;
        int validEntities = 0;
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entityLiving);
        if (tracker == null) {
            EnviroMine.logger.log(Level.ERROR, "Tracker updating as null! Crash imminent!");
        }
        while (iterator.hasNext()) {
            Entity mob = (Entity)iterator.next();
            if (!(mob instanceof EntityLivingBase)) continue;
            EnviroDataTracker mobTrack = EM_StatusManager.lookupTracker((EntityLivingBase)mob);
            EntityProperties livingProps = null;
            if (EntityProperties.base.hasProperty(mob)) {
                livingProps = EntityProperties.base.getProperty(mob);
            }
            if (mob instanceof EntityVillager && entityLiving instanceof EntityPlayer && entityLiving.func_70685_l(mob) && EM_Settings.villageAssist) {
                EntityVillager villager = (EntityVillager)mob;
                Village village = entityLiving.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)villager.field_70165_t), MathHelper.func_76128_c((double)villager.field_70163_u), MathHelper.func_76128_c((double)villager.field_70161_v), 32);
                long assistTime = villager.getEntityData().func_74763_f("Enviro_Assist_Time");
                long worldTime = entityLiving.field_70170_p.field_73011_w.getWorldTime();
                if (village != null && village.func_82684_a(entityLiving.func_70005_c_()) >= 5 && !villager.func_70631_g_() && Math.abs(worldTime - assistTime) > 24000L) {
                    FoodStats food;
                    if (villager.func_70946_n() == 2) {
                        if (sBoost < 5.0f) {
                            sBoost = 5.0f;
                        }
                        ((EntityPlayer)entityLiving).func_71064_a((StatBase)EnviroAchievements.tradingFavours, 1);
                    } else if (villager.func_70946_n() == 0 && isDay) {
                        if (tracker.hydration < 50.0f) {
                            tracker.hydration = 100.0f;
                            if (tracker.bodyTemp >= 38.0f) {
                                tracker.bodyTemp -= 1.0f;
                            }
                            entityLiving.field_70170_p.func_72956_a((Entity)entityLiving, "random.drink", 1.0f, 1.0f);
                            villager.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                            villager.getEntityData().func_74772_a("Enviro_Assist_Time", worldTime);
                            ((EntityPlayer)entityLiving).func_71064_a((StatBase)EnviroAchievements.tradingFavours, 1);
                        }
                    } else if (villager.func_70946_n() == 4 && isDay && (food = ((EntityPlayer)entityLiving).func_71024_bL()).func_75116_a() <= 10) {
                        food.func_75114_a(20);
                        entityLiving.field_70170_p.func_72956_a((Entity)entityLiving, "random.burp", 0.5f, entityLiving.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        villager.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                        villager.getEntityData().func_74772_a("Enviro_Assist_Time", worldTime);
                        ((EntityPlayer)entityLiving).func_71064_a((StatBase)EnviroAchievements.tradingFavours, 1);
                    }
                }
            }
            if (livingProps != null && entityLiving.func_70685_l(mob)) {
                if (sanityRate >= livingProps.ambSanity && livingProps.ambSanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = livingProps.ambSanity;
                } else if (sanityRate <= livingProps.ambSanity && livingProps.ambSanity > 0.0f && sBoost < livingProps.ambSanity) {
                    sBoost = livingProps.ambSanity;
                }
                if (livingProps.ambAir > 0.0f) {
                    leaves += (double)(livingProps.ambAir / 0.1f);
                } else if (quality >= livingProps.ambAir && livingProps.ambAir < 0.0f && quality <= 0.0f) {
                    quality = livingProps.ambAir;
                }
                dehydrateBonus -= livingProps.ambHydration;
            }
            if (mobTrack != null) {
                avgEntityTemp = livingProps != null ? (!livingProps.bodyTemp || !livingProps.shouldTrack ? (avgEntityTemp += livingProps.ambTemp) : (avgEntityTemp += mobTrack.bodyTemp)) : (avgEntityTemp += mobTrack.bodyTemp);
                ++validEntities;
                continue;
            }
            if (livingProps != null) {
                avgEntityTemp = !livingProps.bodyTemp || !livingProps.shouldTrack ? (avgEntityTemp += livingProps.ambTemp) : (avgEntityTemp += 37.0f);
                ++validEntities;
                continue;
            }
            if (mob instanceof EntityMob) continue;
            avgEntityTemp += 37.0f;
            ++validEntities;
        }
        if (validEntities > 0 && bTemp < (avgEntityTemp /= (float)validEntities) - 12.0f) {
            bTemp = (bTemp + (avgEntityTemp - 12.0f)) / 2.0f;
        }
        float fireProt = 0.0f;
        ItemStack helmet = entityLiving.func_71124_b(4);
        ItemStack plate = entityLiving.func_71124_b(3);
        ItemStack legs = entityLiving.func_71124_b(2);
        ItemStack boots = entityLiving.func_71124_b(1);
        float tempMultTotal = 0.0f;
        float addTemp = 0.0f;
        if (helmet != null) {
            NBTTagList enchTags = helmet.func_77986_q();
            if (enchTags != null) {
                for (index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = enchTags.func_150305_b(index).func_74765_d("id");
                    enLV = enchTags.func_150305_b(index).func_74765_d("lvl");
                    if (enID == Enchantment.field_77340_h.field_77352_x) {
                        leaves += (double)(3.0f * (float)enLV);
                        continue;
                    }
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(helmet)) {
                ArmorProperties props = ArmorProperties.base.getProperty(helmet);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (props.air > 0.0f) {
                    leaves += (double)(props.air / 0.1f);
                } else if (quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        if (plate != null) {
            NBTTagList enchTags = plate.func_77986_q();
            if (enchTags != null) {
                for (index = 0; index < enchTags.func_74745_c(); ++index) {
                    short enID = enchTags.func_150305_b(index).func_74765_d("id");
                    enLV = enchTags.func_150305_b(index).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(plate)) {
                ArmorProperties props = ArmorProperties.base.getProperty(plate);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        if (legs != null) {
            NBTTagList enchTags = legs.func_77986_q();
            if (enchTags != null) {
                for (int index2 = 0; index2 < enchTags.func_74745_c(); ++index2) {
                    short enID = enchTags.func_150305_b(index2).func_74765_d("id");
                    enLV = enchTags.func_150305_b(index2).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(legs)) {
                ArmorProperties props = ArmorProperties.base.getProperty(legs);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        if (boots != null) {
            NBTTagList enchTags = boots.func_77986_q();
            if (enchTags != null) {
                for (int index3 = 0; index3 < enchTags.func_74745_c(); ++index3) {
                    short enID = enchTags.func_150305_b(index3).func_74765_d("id");
                    enLV = enchTags.func_150305_b(index3).func_74765_d("lvl");
                    if (enID != Enchantment.field_77329_d.field_77352_x) continue;
                    fireProt += (float)enLV;
                }
            }
            if (ArmorProperties.base.hasProperty(boots)) {
                ArmorProperties props = ArmorProperties.base.getProperty(boots);
                if (isDay) {
                    if (entityLiving.field_70170_p.func_72937_j(i, j, k) && bTemp > 0.0f) {
                        tempMultTotal += props.sunMult - 1.0f;
                        addTemp += props.sunTemp;
                    } else {
                        tempMultTotal += props.shadeMult - 1.0f;
                        addTemp += props.shadeTemp;
                    }
                } else {
                    tempMultTotal += props.nightMult - 1.0f;
                    addTemp += props.nightTemp;
                }
                if (quality <= props.air && props.air > 0.0f || quality >= props.air && props.air < 0.0f && quality <= 0.0f) {
                    quality = props.air;
                }
                if (sanityRate >= props.sanity && props.sanity < 0.0f && sanityRate <= 0.0f) {
                    sanityRate = props.sanity;
                } else if (sBoost <= props.sanity && props.sanity > 0.0f) {
                    sBoost = props.sanity;
                }
            }
        }
        bTemp *= 1.0f + tempMultTotal;
        bTemp += addTemp;
        fireProt = 1.0f - fireProt / 18.0f;
        if (entityLiving.func_70090_H()) {
            if (bTemp > 25.0f) {
                bTemp = bTemp > 50.0f ? (bTemp -= 50.0f) : 25.0f;
            }
            dropSpeed = 0.01f;
        }
        float tempFin = 0.0f;
        if (temp > bTemp) {
            tempFin = (bTemp + temp) / 2.0f;
            if (temp > bTemp + 5.0f) {
                riseSpeed = 0.005f;
            }
        } else {
            tempFin = bTemp;
        }
        if (entityLiving.func_70660_b(Potion.field_76438_s) != null) {
            dehydrateBonus += 0.1f;
        }
        if (nearLava) {
            if (riseSpeed <= 0.005f) {
                riseSpeed = 0.005f;
            }
            dehydrateBonus += 0.05f;
            if (animalHostility == 0) {
                animalHostility = 1;
            }
        }
        BiomeProperties biomeProp = null;
        if (BiomeProperties.base.hasProperty(biome) && (biomeProp = BiomeProperties.base.getProperty(biome)) != null && biomeProp.biomeOveride) {
            dehydrateBonus += biomeProp.dehydrateRate;
            if (biomeProp.tempRate > 0.0f) {
                riseSpeed += biomeProp.tempRate;
            } else {
                dropSpeed += biomeProp.tempRate;
            }
            sanityRate += biomeProp.sanityRate;
        }
        if (biome.func_76744_g() == 0 && isDay) {
            dehydrateBonus += 0.05f;
            if (animalHostility == 0) {
                animalHostility = 1;
            }
        }
        if (!entityLiving.func_70644_a(Potion.field_76426_n)) {
            if (entityLiving.field_70170_p.func_147439_a(i, j, k) == Blocks.field_150353_l || entityLiving.field_70170_p.func_147439_a(i, j, k) == Blocks.field_150356_k) {
                tempFin = 200.0f;
                riseSpeed = 1.0f;
            } else if (entityLiving.func_70027_ad()) {
                if (tempFin <= 75.0f) {
                    tempFin = 75.0f;
                }
                if (riseSpeed < 0.1f) {
                    riseSpeed = 0.1f;
                }
            }
        }
        quality = (float)((double)quality + leaves * (double)0.1f);
        sanityRate += sBoost;
        if (quality < 0.0f) {
            quality = (float)((double)quality * ((double)solidBlocks / Math.pow(range * 2, 3.0)));
        }
        if (entityLiving.func_70051_ag()) {
            dehydrateBonus += 0.05f;
            if (riseSpeed < 0.01f) {
                riseSpeed = 0.01f;
            }
            tempFin += 2.0f;
        }
        if (dimensionProp != null && dimensionProp.override) {
            quality = quality * dimensionProp.airMulti + dimensionProp.airRate;
            riseSpeed = riseSpeed * dimensionProp.tempMulti + dimensionProp.tempRate;
            dropSpeed = dropSpeed * dimensionProp.tempMulti + dimensionProp.tempRate;
            sanityRate = sanityRate * dimensionProp.sanityMulti + dimensionProp.sanityRate;
            dehydrateBonus = dehydrateBonus * dimensionProp.hydrationMulti + dimensionProp.hydrationRate;
        }
        data[0] = quality * (float)EM_Settings.airMult;
        data[1] = entityLiving.func_70644_a(Potion.field_76426_n) && tempFin > 37.0f ? 37.0f : (tempFin > 37.0f ? 37.0f + (tempFin - 37.0f) * fireProt : tempFin);
        data[2] = nearLava ? 1.0f : 0.0f;
        data[3] = dehydrateBonus * (float)EM_Settings.hydrationMult;
        data[4] = dropSpeed * (float)EM_Settings.tempMult;
        data[5] = riseSpeed * (float)EM_Settings.tempMult * (tracker.bodyTemp < 37.0f ? 1.0f : fireProt);
        data[6] = animalHostility;
        data[7] = sanityRate * (float)EM_Settings.sanityMult;
        if (EnviroMine.proxy.isClient() && entityLiving.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && timer.isRunning()) {
            timer.stop();
            Debug_Info.DB_timer = timer.toString();
            timer.reset();
        }
        return data;
    }

    public static float getBiomeTemprature(int x, int y, BiomeGenBase biome) {
        float temp = 0.0f;
        return temp;
    }

    public static void removeTracker(EnviroDataTracker tracker) {
        if (trackerList.containsValue(tracker)) {
            tracker.isDisabled = true;
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(tracker.trackedEntity.func_70005_c_());
            } else {
                trackerList.remove("" + tracker.trackedEntity.func_145782_y());
            }
        }
    }

    public static void saveAndRemoveTracker(EnviroDataTracker tracker) {
        if (trackerList.containsValue(tracker)) {
            tracker.isDisabled = true;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(tracker.trackedEntity.func_70005_c_());
            } else {
                trackerList.remove("" + tracker.trackedEntity.func_145782_y());
            }
        }
    }

    public static void saveTracker(EnviroDataTracker tracker) {
        NBTTagCompound tags = tracker.trackedEntity.getEntityData();
        tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
        tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
        tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
        tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
    }

    public static void removeAllTrackers() {
        for (EnviroDataTracker tracker : trackerList.values()) {
            tracker.isDisabled = true;
        }
        trackerList.clear();
    }

    public static void saveAndDeleteAllTrackers() {
        for (EnviroDataTracker tracker : trackerList.values()) {
            tracker.isDisabled = true;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
        }
        trackerList.clear();
    }

    public static void saveAndDeleteWorldTrackers(World world) {
        HashMap<String, EnviroDataTracker> tempList = new HashMap<String, EnviroDataTracker>(trackerList);
        for (EnviroDataTracker tracker : tempList.values()) {
            if (tracker.trackedEntity.field_70170_p != world) continue;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
            tracker.isDisabled = true;
            if (tracker.trackedEntity instanceof EntityPlayer) {
                trackerList.remove(tracker.trackedEntity.func_70005_c_());
                continue;
            }
            trackerList.remove("" + tracker.trackedEntity.func_145782_y());
        }
    }

    public static void saveAllWorldTrackers(World world) {
        HashMap<String, EnviroDataTracker> tempList = new HashMap<String, EnviroDataTracker>(trackerList);
        for (EnviroDataTracker tracker : tempList.values()) {
            if (tracker.trackedEntity.field_70170_p != world) continue;
            NBTTagCompound tags = tracker.trackedEntity.getEntityData();
            tags.func_74776_a("ENVIRO_AIR", tracker.airQuality);
            tags.func_74776_a("ENVIRO_HYD", tracker.hydration);
            tags.func_74776_a("ENVIRO_TMP", tracker.bodyTemp);
            tags.func_74776_a("ENVIRO_SAN", tracker.sanity);
        }
    }

    public static EntityPlayer findPlayer(String username) {
        World[] worlds = new World[1];
        if (EnviroMine.proxy.isClient()) {
            if (Minecraft.func_71410_x().func_71387_A()) {
                worlds = MinecraftServer.func_71276_C().field_71305_c;
            } else {
                worlds[0] = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            }
        } else {
            worlds = MinecraftServer.func_71276_C().field_71305_c;
        }
        for (int i = worlds.length - 1; i >= 0; --i) {
            EntityPlayer player;
            if (worlds[i] == null || (player = worlds[i].func_72924_a(username)) == null || !player.func_70089_S()) continue;
            return player;
        }
        return null;
    }

    public static void createFX(EntityLivingBase entityLiving) {
        float rndX = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70130_N * 2.0f - entityLiving.field_70130_N;
        float rndY = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70131_O;
        float rndZ = entityLiving.func_70681_au().nextFloat() * entityLiving.field_70130_N * 2.0f - entityLiving.field_70130_N;
        EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entityLiving);
        if (entityLiving instanceof EntityPlayer && !(entityLiving instanceof EntityPlayerMP)) {
            rndY = -rndY;
        }
        if (tracker != null) {
            if (tracker.bodyTemp >= 38.0f && UI_Settings.sweatParticals) {
                entityLiving.field_70170_p.func_72869_a("dripWater", entityLiving.field_70165_t + (double)rndX, entityLiving.field_70163_u + (double)rndY, entityLiving.field_70161_v + (double)rndZ, 0.0, 0.0, 0.0);
            }
            if (tracker.trackedEntity.func_70644_a((Potion)EnviroPotion.insanity) && UI_Settings.insaneParticals) {
                entityLiving.field_70170_p.func_72869_a("portal", entityLiving.field_70165_t + (double)rndX, entityLiving.field_70163_u + (double)rndY, entityLiving.field_70161_v + (double)rndZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public static float getTempFalloff(float temp, float dist, int range) {
        float maximum = (float)Math.sqrt(3.0 * Math.pow(range, 2.0));
        if (dist > maximum) {
            return 0.0f;
        }
        return (float)((double)temp / Math.pow(maximum, 2.0) * -Math.pow(dist, 2.0) + (double)temp);
    }
}

