/*
 * Decompiled with CFR 0.152.
 */
package enviromine.gases;

import com.google.common.base.Stopwatch;
import enviromine.blocks.BlockGas;
import enviromine.client.gui.hud.items.Debug_Info;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_PhysManager;
import enviromine.handlers.ObjectHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;

public class GasBuffer {
    static ArrayList<int[]> gasBuffer = new ArrayList();
    static ArrayList<int[]> fireBuffer = new ArrayList();
    static HashMap<String, Integer> chunkUpdates = new HashMap();
    public static int curTick = 0;
    public static int debugInterval = 1;
    public static int debugTime = 0;
    public static int debugUpdatesCaptured = 0;
    private static Stopwatch timer = Stopwatch.createUnstarted();

    public static void reset() {
        gasBuffer.clear();
        fireBuffer.clear();
        curTick = 1;
    }

    public static int getChunkUpdates(int cx, int cz) {
        String key = cx + "," + cz;
        if (!chunkUpdates.containsKey(key)) {
            return 0;
        }
        return chunkUpdates.get(key);
    }

    public static void incrementUpdates(int cx, int cz) {
        String key = cx + "," + cz;
        if (!chunkUpdates.containsKey(key)) {
            chunkUpdates.put(key, 1);
        } else {
            chunkUpdates.put(key, chunkUpdates.get(key) + 1);
        }
    }

    public static void scheduleUpdate(World world, int x, int y, int z, BlockGas block) {
        if (world.field_72995_K) {
            EnviroMine.logger.log(Level.WARN, "Tried to register gas update in local world!");
            return;
        }
        int[] entry = new int[]{world.field_73011_w.field_76574_g, x, y, z};
        if (block == ObjectHandler.fireGasBlock) {
            if (!fireBuffer.contains(entry)) {
                fireBuffer.add(entry);
            }
        } else if (!EM_Settings.slowGases && !gasBuffer.contains(entry)) {
            gasBuffer.add(entry);
        }
    }

    public static void update() {
        Block block;
        WorldServer world;
        int[] entry;
        int i;
        if (++curTick > EM_Settings.gasTickRate) {
            curTick = 1;
        }
        if (fireBuffer.size() >= 25000) {
            fireBuffer.clear();
        }
        if (gasBuffer.size() >= 25000) {
            gasBuffer.clear();
        }
        if (EnviroMine.proxy.isClient()) {
            if (debugTime == 0 && curTick == 1) {
                if (!timer.isRunning()) {
                    timer.reset();
                    timer.start();
                }
                debugUpdatesCaptured = 0;
            }
            if (Minecraft.func_71410_x().func_71387_A()) {
                if (Minecraft.func_71410_x().func_147113_T() && !EnviroMine.proxy.isOpenToLAN()) {
                    if (timer.isRunning()) {
                        timer.stop();
                        debugTime = 0;
                    }
                } else if (!timer.isRunning()) {
                    timer.start();
                }
            }
        }
        if (gasBuffer.size() == 0 && fireBuffer.size() == 0) {
            return;
        }
        if (curTick % Math.max(1, EM_Settings.gasTickRate / 4) == 0) {
            for (i = 0; i < fireBuffer.size() && !((float)timer.elapsed(TimeUnit.SECONDS) / (float)EM_Settings.gasTickRate >= 0.5f); ++i) {
                entry = fireBuffer.get(i);
                world = MinecraftServer.func_71276_C().func_71218_a(entry[0]);
                if (world == null || world.func_82737_E() < EM_PhysManager.worldStartTime + (long)EM_Settings.worldDelay || EM_PhysManager.chunkDelay.containsKey(world.field_73011_w.field_76574_g + "" + (entry[1] >> 4) + "," + (entry[3] >> 4)) && EM_PhysManager.chunkDelay.get(world.field_73011_w.field_76574_g + "" + (entry[1] >> 4) + "," + (entry[3] >> 4)) > world.func_82737_E() || EM_Settings.gasPassLimit >= 0 && GasBuffer.getChunkUpdates(entry[1] >> 4, entry[3] >> 4) >= EM_Settings.gasPassLimit / 4) continue;
                if (world != null && world.func_147439_a(entry[1], entry[2], entry[3]) instanceof BlockGas) {
                    block = world.func_147439_a(entry[1], entry[2], entry[3]);
                    world.func_147454_a(entry[1], entry[2], entry[3], block, 1, 0);
                    GasBuffer.incrementUpdates(entry[1] >> 4, entry[3] >> 4);
                }
                fireBuffer.remove(i);
                --i;
                ++debugUpdatesCaptured;
            }
        }
        if (curTick % Math.max(1, EM_Settings.gasTickRate) == 0) {
            for (i = 0; i < gasBuffer.size() && !((float)timer.elapsed(TimeUnit.SECONDS) / (float)EM_Settings.gasTickRate >= 0.5f); ++i) {
                entry = gasBuffer.get(i);
                world = MinecraftServer.func_71276_C().func_71218_a(entry[0]);
                if (world == null || world.func_82737_E() < EM_PhysManager.worldStartTime + (long)EM_Settings.worldDelay || EM_PhysManager.chunkDelay.containsKey(world.field_73011_w.field_76574_g + "" + (entry[1] >> 4) + "," + (entry[3] >> 4)) && EM_PhysManager.chunkDelay.get(world.field_73011_w.field_76574_g + "" + (entry[1] >> 4) + "," + (entry[3] >> 4)) > world.func_82737_E() || EM_Settings.gasPassLimit >= 0 && GasBuffer.getChunkUpdates(entry[1] >> 4, entry[3] >> 4) >= EM_Settings.gasPassLimit) continue;
                if (world != null && world.func_72863_F().func_73149_a(entry[1] >> 4, entry[3] >> 4) && world.func_72938_d((int)entry[1], (int)entry[3]).field_76636_d && world.func_147439_a(entry[1], entry[2], entry[3]) instanceof BlockGas) {
                    block = world.func_147439_a(entry[1], entry[2], entry[3]);
                    world.func_147454_a(entry[1], entry[2], entry[3], block, 1, 0);
                    GasBuffer.incrementUpdates(entry[1] >> 4, entry[3] >> 4);
                }
                gasBuffer.remove(i);
                --i;
                ++debugUpdatesCaptured;
            }
        }
        chunkUpdates.clear();
        if (EnviroMine.proxy.isClient() && debugTime >= debugInterval && timer.isRunning()) {
            timer.stop();
            Debug_Info.DB_gasTimer = timer.toString();
            Debug_Info.DB_gasUpdates = debugUpdatesCaptured;
            Debug_Info.DB_gasBuffer = gasBuffer.size();
            Debug_Info.DB_gasBuffer = fireBuffer.size();
            timer.reset();
            debugTime = 0;
        } else if (EnviroMine.proxy.isClient() && curTick == 1) {
            ++debugTime;
        }
    }
}

