/*
 * Decompiled with CFR 0.152.
 */
package enviromine.core.commands;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import enviromine.core.EnviroMine;
import enviromine.network.packet.PacketEnviroMine;
import enviromine.world.Earthquake;
import java.util.Iterator;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class QuakeCommand
extends CommandBase {
    private String lengthName = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.length");
    private String widthName = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.width");
    private String rotationName = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.rotation");
    private String modeName = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.mode");
    private String stopName = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.stop");
    private String stoppedAll = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.stoppedAll");
    private String errorMany = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.error.tooMany");
    private String errorBig = StatCollector.func_74838_a((String)"commands.enviromine.enviroquake.error.tooBig");

    public String func_71517_b() {
        return "enviroquake";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/enviroquake [" + this.stopName + " | <x> <z> [<" + this.lengthName + "> <" + this.widthName + "> <" + this.rotationName + "> <" + this.modeName + "(0 ~ 4)>]]";
    }

    public void ShowUsage(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(this.func_71518_a(sender)));
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_71515_b(ICommandSender sender, String[] astring) {
        if (astring.length != 0 && astring.length != 1 && astring.length != 2 && astring.length != 6) {
            this.ShowUsage(sender);
            return;
        }
        if (astring.length == 1) {
            if (astring[0].equalsIgnoreCase(this.stopName)) {
                Iterator<Earthquake> iterator = Earthquake.pendingQuakes.iterator();
                while (iterator.hasNext()) {
                    Earthquake quake = iterator.next();
                    int size = quake.length > quake.width ? quake.length / 2 : quake.width / 2;
                    NBTTagCompound pData = new NBTTagCompound();
                    pData.func_74768_a("id", 3);
                    pData.func_74768_a("dimension", quake.world.field_73011_w.field_76574_g);
                    pData.func_74768_a("posX", quake.posX);
                    pData.func_74768_a("posZ", quake.posZ);
                    pData.func_74768_a("length", quake.length);
                    pData.func_74768_a("width", quake.width);
                    pData.func_74776_a("angle", quake.angle);
                    pData.func_74776_a("action", 2.0f);
                    pData.func_74776_a("height", (float)quake.passY);
                    EnviroMine.instance.network.sendToAllAround((IMessage)new PacketEnviroMine(pData), new NetworkRegistry.TargetPoint(quake.world.field_73011_w.field_76574_g, (double)quake.posX, (double)quake.passY, (double)quake.posZ, (double)(128 + size)));
                    iterator.remove();
                }
                Earthquake.pendingQuakes.clear();
                sender.func_145747_a((IChatComponent)new ChatComponentText(this.stoppedAll));
                return;
            }
            this.ShowUsage(sender);
            return;
        }
        if (Earthquake.pendingQuakes.size() > 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + this.errorMany));
            return;
        }
        World world = sender.func_130014_f_();
        int x = sender.func_82114_b().field_71574_a;
        int z = sender.func_82114_b().field_71573_c;
        int l = 32 + world.field_73012_v.nextInt(96);
        int w = 4 + world.field_73012_v.nextInt(28);
        float a = MathHelper.func_76131_a((float)(world.field_73012_v.nextFloat() * 4.0f - 2.0f), (float)-2.0f, (float)2.0f);
        try {
            if (astring.length >= 3) {
                x = Integer.parseInt(astring[0]);
                z = Integer.parseInt(astring[1]);
            }
            if (astring.length >= 6) {
                l = Integer.parseInt(astring[2]);
                w = Integer.parseInt(astring[3]);
                a = (Float.parseFloat(astring[4]) % 360.0f - 180.0f) / 90.0f;
            }
        }
        catch (Exception e) {
            this.ShowUsage(sender);
            return;
        }
        if (l * w > 4096) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + this.errorBig));
            return;
        }
        new Earthquake(world, x, z, l, w, a, true);
        EnviroMine.logger.log(Level.INFO, sender.func_70005_c_() + " spawned earthquake at (" + x + "," + z + ")");
    }
}

