/*
 * Decompiled with CFR 0.152.
 */
package enviromine.core;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import enviromine.EnviroPotion;
import enviromine.core.EM_ConfigHandler;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroTab;
import enviromine.core.commands.CommandPhysics;
import enviromine.core.commands.EnviroCommand;
import enviromine.core.commands.QuakeCommand;
import enviromine.core.proxies.EM_CommonProxy;
import enviromine.handlers.EnviroAchievements;
import enviromine.handlers.EnviroShaftCreationHandler;
import enviromine.handlers.Legacy.LegacyHandler;
import enviromine.handlers.ObjectHandler;
import enviromine.network.packet.PacketAutoOverride;
import enviromine.network.packet.PacketEnviroMine;
import enviromine.network.packet.PacketServerOverride;
import enviromine.utils.EnviroUtils;
import enviromine.world.WorldProviderCaves;
import enviromine.world.biomes.BiomeGenCaves;
import enviromine.world.features.WorldFeatureGenerator;
import enviromine.world.features.mineshaft.EM_VillageMineshaft;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enviromine", name="EnviroMine", version="1.3.124", guiFactory="enviromine.client.gui.menu.config.EnviroMineGuiFactory")
public class EnviroMine {
    public static Logger logger;
    public static BiomeGenCaves caves;
    public static EnviroTab enviroTab;
    @Mod.Instance(value="enviromine")
    public static EnviroMine instance;
    @SidedProxy(clientSide="enviromine.core.proxies.EM_ClientProxy", serverSide="enviromine.core.proxies.EM_CommonProxy")
    public static EM_CommonProxy proxy;
    public SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        enviroTab = new EnviroTab("enviromine.enviroTab");
        LegacyHandler.preInit();
        LegacyHandler.init();
        proxy.preInit(event);
        ObjectHandler.initItems();
        ObjectHandler.registerItems();
        ObjectHandler.initBlocks();
        ObjectHandler.registerBlocks();
        EM_ConfigHandler.initConfig();
        ObjectHandler.registerGases();
        ObjectHandler.registerEntities();
        if (EM_Settings.shaftGen) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new EnviroShaftCreationHandler());
            MapGenStructureIO.func_143031_a(EM_VillageMineshaft.class, (String)"ViMS");
        }
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("EM_CH");
        this.network.registerMessage(PacketEnviroMine.HandlerServer.class, PacketEnviroMine.class, 0, Side.SERVER);
        this.network.registerMessage(PacketEnviroMine.HandlerClient.class, PacketEnviroMine.class, 1, Side.CLIENT);
        this.network.registerMessage(PacketAutoOverride.Handler.class, PacketAutoOverride.class, 2, Side.CLIENT);
        this.network.registerMessage(PacketServerOverride.Handler.class, PacketServerOverride.class, 3, Side.CLIENT);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldFeatureGenerator(), (int)20);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        ObjectHandler.registerRecipes();
        EnviroUtils.extendPotionList();
        EnviroPotion.RegisterPotions();
        EnviroAchievements.InitAchievements();
        caves = (BiomeGenCaves)new BiomeGenCaves(EM_Settings.caveBiomeID).func_76739_b(0).func_76735_a("Caves").func_76745_m().func_76732_a(1.0f, 0.0f);
        BiomeDictionary.registerBiomeType((BiomeGenBase)caves, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND});
        DimensionManager.registerProviderType((int)EM_Settings.caveDimID, WorldProviderCaves.class, (boolean)false);
        DimensionManager.registerDimension((int)EM_Settings.caveDimID, (int)EM_Settings.caveDimID);
        proxy.registerTickHandlers();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        EM_ConfigHandler.initConfig();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new CommandPhysics());
        manager.func_71560_a((ICommand)new EnviroCommand());
        manager.func_71560_a((ICommand)new QuakeCommand());
    }
}

