/*
 * Decompiled with CFR 0.152.
 */
package enviromine.core;

import cpw.mods.fml.common.registry.EntityRegistry;
import enviromine.client.gui.hud.HUDRegistry;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.Legacy.LegacyHandler;
import enviromine.handlers.ObjectHandler;
import enviromine.trackers.properties.ArmorProperties;
import enviromine.trackers.properties.BiomeProperties;
import enviromine.trackers.properties.BlockProperties;
import enviromine.trackers.properties.CaveBaseProperties;
import enviromine.trackers.properties.CaveGenProperties;
import enviromine.trackers.properties.CaveSpawnProperties;
import enviromine.trackers.properties.DimensionProperties;
import enviromine.trackers.properties.EntityProperties;
import enviromine.trackers.properties.ItemProperties;
import enviromine.trackers.properties.RotProperties;
import enviromine.trackers.properties.StabilityType;
import enviromine.trackers.properties.helpers.PropertyBase;
import enviromine.utils.ModIdentification;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class EM_ConfigHandler {
    public static String configPath = "config/enviromine/";
    public static String customPath = "CustomProperties/";
    public static String profilePath = configPath + "profiles/";
    public static String defaultProfile;
    public static final String CONFIG_VERSION = "1.0.0";
    public static String loadedProfile;
    static HashMap<String, PropertyBase> propTypes;
    public static HashMap<String, PropertyBase> globalTypes;
    public static List loadedConfigs;

    public static void initProfile() {
        String profile = EM_Settings.profileSelected;
        System.out.println("LOADING PROFILE: " + profile);
        File profileDir = new File(profilePath + profile + "/" + customPath);
        if (!profileDir.exists()) {
            try {
                profileDir.mkdirs();
            }
            catch (Exception e) {
                EnviroMine.logger.log(Level.ERROR, "Unable to create directories for profile", (Throwable)e);
            }
        }
        if (!profileDir.exists()) {
            EnviroMine.logger.log(Level.ERROR, "Failed to load Profile:" + profile + ". Loading Default");
            profileDir = new File(defaultProfile + customPath);
            loadedProfile = defaultProfile;
        } else {
            loadedProfile = profilePath + profile + "/";
            EnviroMine.logger.log(Level.INFO, "Loading Profile: " + profile);
        }
        File ProfileSettings = new File(loadedProfile + profile + "_Settings.cfg");
        EM_ConfigHandler.loadProfileConfig(ProfileSettings);
        EM_ConfigHandler.loadHudItems();
        StabilityType.base.GenDefaults();
        StabilityType.base.customLoad();
        if (EM_Settings.genDefaults) {
            EM_ConfigHandler.loadDefaultProperties();
        }
        File[] customFiles = EM_ConfigHandler.GetFileList(loadedProfile + customPath);
        for (int i = 0; i < customFiles.length; ++i) {
            EM_ConfigHandler.LoadCustomObjects(customFiles[i]);
        }
        for (PropertyBase props : propTypes.values()) {
            if (props.useCustomConfigs()) continue;
            props.customLoad();
        }
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.stabilityTypes.size() + " stability types");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.armorProperties.size() + " armor properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.blockProperties.size() + " block properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.livingProperties.size() + " entity properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.itemProperties.size() + " item properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.rotProperties.size() + " rot properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.biomeProperties.size() + " biome properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.dimensionProperties.size() + " dimension properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.caveGenProperties.size() + " cave ore properties");
        EnviroMine.logger.log(Level.INFO, "Loaded " + EM_Settings.caveSpawnProperties.size() + " cave entity properties");
    }

    public static void loadHudItems() {
        if (!EM_Settings.enableAirQ && HUDRegistry.isActiveHudItem(HUDRegistry.getHudItemByID(3))) {
            HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(3));
        }
        if (!EM_Settings.enableBodyTemp && HUDRegistry.isActiveHudItem(HUDRegistry.getHudItemByID(0))) {
            HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(0));
        }
        if (!EM_Settings.enableHydrate && HUDRegistry.isActiveHudItem(HUDRegistry.getHudItemByID(1))) {
            HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(1));
        }
        if (!EM_Settings.enableSanity && HUDRegistry.isActiveHudItem(HUDRegistry.getHudItemByID(2))) {
            HUDRegistry.disableHudItem(HUDRegistry.getHudItemByID(2));
        }
    }

    public static int initConfig() {
        EnviroMine.logger.log(Level.INFO, "Loading configs...");
        File configFile = new File(configPath + "Global_Settings.cfg");
        EM_ConfigHandler.loadGlobalConfig(configFile);
        for (PropertyBase props : globalTypes.values()) {
            if (props.useCustomConfigs()) continue;
            props.customLoad();
        }
        int Total = EM_Settings.armorProperties.size() + EM_Settings.blockProperties.size() + EM_Settings.livingProperties.size() + EM_Settings.itemProperties.size() + EM_Settings.biomeProperties.size() + EM_Settings.dimensionProperties.size() + EM_Settings.caveGenProperties.size() + EM_Settings.caveSpawnProperties.size();
        return Total;
    }

    private static void loadGlobalConfig(File file) {
        Configuration config;
        try {
            config = new Configuration(file, true);
        }
        catch (Exception e) {
            EnviroMine.logger.log(Level.WARN, "Failed to load main configuration file!", (Throwable)e);
            return;
        }
        config.load();
        EM_Settings.shaftGen = config.get("World Generation", "Enable Village MineShafts", EM_Settings.shaftGen, "Generates mineshafts in villages").getBoolean(EM_Settings.shaftGen);
        EM_Settings.oldMineGen = config.get("World Generation", "Enable New Abandoned Mineshafts", EM_Settings.oldMineGen, "Generates massive abandoned mineshafts (size doesn't cause lag) (This Overrides all Dimensions. Check Custom Dimension properties if you want to set it only for certain Dimensions.)").getBoolean(EM_Settings.oldMineGen);
        EM_Settings.gasGen = config.get("World Generation", "Generate Gases", EM_Settings.gasGen).getBoolean(EM_Settings.gasGen);
        config.get("Do not Edit", "Current Config Version", CONFIG_VERSION).getString();
        EM_Settings.updateCheck = config.get("general", "Check For Updates", EM_Settings.updateCheck).getBoolean(EM_Settings.updateCheck);
        EM_Settings.noNausea = config.get("general", "Blindness instead of Nausea", EM_Settings.noNausea).getBoolean(EM_Settings.noNausea);
        EM_Settings.keepStatus = config.get("general", "Keep statuses on death", EM_Settings.keepStatus).getBoolean(EM_Settings.keepStatus);
        EM_Settings.renderGear = config.get("general", "Render Gear", EM_Settings.renderGear, "Render 3d gear worn on player. Must reload game to take effect").getBoolean(EM_Settings.renderGear);
        EM_Settings.finiteWater = config.get("general", "Finite Water", EM_Settings.finiteWater).getBoolean(EM_Settings.finiteWater);
        String PhySetCat = "Physics";
        int minPhysInterval = 6;
        EM_Settings.spreadIce = config.get(PhySetCat, "Large Ice Cracking", EM_Settings.spreadIce, "Setting Large Ice Cracking to true can cause Massive Lag").getBoolean(EM_Settings.spreadIce);
        EM_Settings.updateCap = config.get(PhySetCat, "Consecutive Physics Update Cap", EM_Settings.updateCap, "This will change maximum number of blocks that can be updated with physics at a time. - 1 = Unlimited").getInt(EM_Settings.updateCap);
        EM_Settings.physInterval = EM_ConfigHandler.getConfigIntWithMinInt(config.get(PhySetCat, "Physics Interval", minPhysInterval, "The number of ticks between physics update passes (must be " + minPhysInterval + " or more)"), minPhysInterval);
        EM_Settings.worldDelay = config.get(PhySetCat, "World Start Delay", EM_Settings.worldDelay, "How long after world start until the physics system kicks in (DO NOT SET TOO LOW)").getInt(EM_Settings.worldDelay);
        EM_Settings.chunkDelay = config.get(PhySetCat, "Chunk Physics Delay", EM_Settings.chunkDelay, "How long until individual chunk's physics starts after loading (DO NOT SET TOO LOW)").getInt(EM_Settings.chunkDelay);
        EM_Settings.physInterval = EM_Settings.physInterval >= 2 ? EM_Settings.physInterval : 2;
        EM_Settings.entityFailsafe = config.get(PhySetCat, "Physics entity fail safe level", EM_Settings.entityFailsafe, "0 = No action, 1 = Limit to < 100 per 8x8 block area, 2 = Delete excessive entities & Dump physics (EMERGENCY ONLY)").getInt(EM_Settings.entityFailsafe);
        if (!LegacyHandler.getByKey("ConfigHandlerLegacy").didRun()) {
            EM_Settings.hypothermiaPotionID = EM_ConfigHandler.nextAvailPotion(EM_Settings.hypothermiaPotionID);
            EM_Settings.heatstrokePotionID = EM_ConfigHandler.nextAvailPotion(EM_Settings.heatstrokePotionID);
            EM_Settings.frostBitePotionID = EM_ConfigHandler.nextAvailPotion(EM_Settings.frostBitePotionID);
            EM_Settings.dehydratePotionID = EM_ConfigHandler.nextAvailPotion(EM_Settings.dehydratePotionID);
            EM_Settings.insanityPotionID = EM_ConfigHandler.nextAvailPotion(EM_Settings.insanityPotionID);
        }
        EM_Settings.hypothermiaPotionID = config.get("Potions", "Hypothermia", EM_Settings.hypothermiaPotionID).getInt(EM_Settings.hypothermiaPotionID);
        EM_Settings.heatstrokePotionID = config.get("Potions", "Heat Stroke", EM_Settings.heatstrokePotionID).getInt(EM_Settings.heatstrokePotionID);
        EM_Settings.frostBitePotionID = config.get("Potions", "Frostbite", EM_Settings.frostBitePotionID).getInt(EM_Settings.frostBitePotionID);
        EM_Settings.dehydratePotionID = config.get("Potions", "Dehydration", EM_Settings.dehydratePotionID).getInt(EM_Settings.dehydratePotionID);
        EM_Settings.insanityPotionID = config.get("Potions", "Insanity", EM_Settings.insanityPotionID).getInt(EM_Settings.insanityPotionID);
        EM_Settings.enableFrostbiteGlobal = config.get("Potions", "Enable Frostbite", EM_Settings.enableFrostbiteGlobal).getBoolean();
        EM_Settings.enableHeatstrokeGlobal = config.get("Potions", "Enable Heat Stroke", EM_Settings.enableHeatstrokeGlobal).getBoolean();
        EM_Settings.enableHypothermiaGlobal = config.get("Potions", "Enable Hypothermia", EM_Settings.enableHypothermiaGlobal).getBoolean();
        String ConSetCat = "Config";
        EM_Settings.profileSelected = config.get(ConSetCat, "Profile", EM_Settings.profileSelected).getString();
        EM_Settings.profileOverride = config.get(ConSetCat, "Override Profile", EM_Settings.profileOverride, "Override Profile. It Can be used for servers to force profiles on servers or modpack. This Overrides any world loaded up. Name is Case Sensitive!").getBoolean(false);
        EM_Settings.enableConfigOverride = config.get(ConSetCat, "Client Config Override (SMP)", EM_Settings.enableConfigOverride, "[DISABLED][WIP] Temporarily overrides client configurations with the server's (NETWORK INTESIVE!)").getBoolean(EM_Settings.enableConfigOverride);
        EM_Settings.noGases = config.get("Gases", "Disable Gases", EM_Settings.noGases, "Disables all gases and slowly deletes existing pockets").getBoolean(EM_Settings.noGases);
        EM_Settings.slowGases = config.get("Gases", "Slow Gases", EM_Settings.slowGases, "Normal gases will move extremely slowly and reduce TPS lag").getBoolean(EM_Settings.slowGases);
        EM_Settings.renderGases = config.get("Gases", "Render normal gas", EM_Settings.renderGases, "Whether to render gases not normally visible").getBoolean(EM_Settings.renderGases);
        EM_Settings.gasTickRate = config.get("Gases", "Gas Tick Rate", EM_Settings.gasTickRate, "How many ticks between gas updates. Gas fires are 1/4 of this.").getInt(EM_Settings.gasTickRate);
        EM_Settings.gasPassLimit = config.get("Gases", "Gas Pass Limit", EM_Settings.gasPassLimit, "How many gases can be processed in a single pass per chunk (-1 = infinite)").getInt(EM_Settings.gasPassLimit);
        EM_Settings.gasWaterLike = config.get("Gases", "Water like spreading", EM_Settings.gasWaterLike, "Whether gases should spread like water (faster) or even out as much as possible (realistic)").getBoolean(EM_Settings.gasWaterLike);
        String[] igniteList = config.getStringList("Ignite List", "Gases", ObjectHandler.DefaultIgnitionSources(), "List of Blocks that will ignite flamable gasses.");
        ObjectHandler.LoadIgnitionSources(igniteList);
        config.save();
    }

    private static void loadProfileConfig(File file) {
        Configuration config;
        try {
            config = new Configuration(file, true);
        }
        catch (Exception e) {
            EnviroMine.logger.log(Level.WARN, "Failed to load main configuration file!", (Throwable)e);
            return;
        }
        config.load();
        EM_Settings.enablePhysics = config.get("general", "Enable Physics", EM_Settings.enablePhysics, "Turn physics On/Off").getBoolean(EM_Settings.enablePhysics);
        EM_Settings.enableLandslide = config.get("general", "Enable Physics Landslide", EM_Settings.enableLandslide).getBoolean(EM_Settings.enableLandslide);
        EM_Settings.enableSanity = config.get("general", "Allow Sanity", EM_Settings.enableSanity).getBoolean(EM_Settings.enableSanity);
        EM_Settings.enableHydrate = config.get("general", "Allow Hydration", EM_Settings.enableHydrate).getBoolean(EM_Settings.enableHydrate);
        EM_Settings.enableBodyTemp = config.get("general", "Allow Body Temperature", EM_Settings.enableBodyTemp).getBoolean(EM_Settings.enableBodyTemp);
        EM_Settings.enableAirQ = config.get("general", "Allow Air Quality", EM_Settings.enableAirQ, "True/False to turn Enviromine Trackers for Sanity, Air Quality, Hydration, and Body Temperature.").getBoolean(EM_Settings.enableAirQ);
        EM_Settings.trackNonPlayer = config.get("general", "Track NonPlayer entities", EM_Settings.trackNonPlayer, "Track enviromine properties on Non-player entities(mobs & animals)").getBoolean(EM_Settings.trackNonPlayer);
        EM_Settings.villageAssist = config.get("general", "Enable villager assistance", EM_Settings.villageAssist).getBoolean(EM_Settings.villageAssist);
        EM_Settings.foodSpoiling = config.get("general", "Enable food spoiling", EM_Settings.foodSpoiling).getBoolean(EM_Settings.foodSpoiling);
        EM_Settings.foodRotTime = config.get("general", "Default spoil time (days)", EM_Settings.foodRotTime).getInt(EM_Settings.foodRotTime);
        EM_Settings.torchesBurn = config.get("general", "Torches burn", EM_Settings.torchesBurn).getBoolean(EM_Settings.torchesBurn);
        EM_Settings.torchesGoOut = config.get("general", "Torches go out", EM_Settings.torchesGoOut).getBoolean(EM_Settings.torchesGoOut);
        String PhySetCat = "Physics";
        EM_Settings.stoneCracks = config.get(PhySetCat, "Stone Cracks Before Falling", EM_Settings.stoneCracks).getBoolean(EM_Settings.stoneCracks);
        EM_Settings.defaultStability = config.get(PhySetCat, "Default Stability Type (BlockIDs > 175)", EM_Settings.defaultStability).getString();
        EM_Settings.tempMult = config.get("Speed Multipliers", "BodyTemp", EM_Settings.tempMult).getDouble(EM_Settings.tempMult);
        EM_Settings.hydrationMult = config.get("Speed Multipliers", "Hydration", EM_Settings.hydrationMult).getDouble(EM_Settings.hydrationMult);
        EM_Settings.airMult = config.get("Speed Multipliers", "AirQuality", EM_Settings.airMult).getDouble(EM_Settings.airMult);
        EM_Settings.sanityMult = config.get("Speed Multipliers", "Sanity", EM_Settings.sanityMult).getDouble(EM_Settings.sanityMult);
        EM_Settings.tempMult = EM_Settings.tempMult < 0.0 ? 0.0 : EM_Settings.tempMult;
        EM_Settings.hydrationMult = EM_Settings.hydrationMult < 0.0 ? 0.0 : EM_Settings.hydrationMult;
        EM_Settings.airMult = EM_Settings.airMult < 0.0 ? 0.0 : EM_Settings.airMult;
        EM_Settings.sanityMult = EM_Settings.sanityMult < 0.0 ? 0.0 : EM_Settings.sanityMult;
        String ConSetCat = "Config";
        Property genConfig = config.get(ConSetCat, "Generate Blank Configs", false, "Will attempt to find and generate blank configs for any custom items/blocks/etc loaded before EnviroMine. Pack developers are highly encouraged to enable this! (Resets back to false after use)");
        if (!EM_Settings.genConfigs) {
            EM_Settings.genConfigs = genConfig.getBoolean(false);
        }
        genConfig.set(false);
        Property genDefault = config.get(ConSetCat, "Generate Defaults", true, "Generates EnviroMines initial default files");
        if (!EM_Settings.genDefaults) {
            EM_Settings.genDefaults = genDefault.getBoolean(true);
        }
        genDefault.set(false);
        EM_Settings.enableConfigOverride = config.get(ConSetCat, "Client Config Override (SMP)", EM_Settings.enableConfigOverride, "[DISABLED][WIP] Temporarily overrides client configurations with the server's (NETWORK INTESIVE!)").getBoolean(EM_Settings.enableConfigOverride);
        String EarSetCat = "Earthquakes";
        EM_Settings.enableQuakes = config.get(EarSetCat, "Enable Earthquakes", EM_Settings.enableQuakes).getBoolean(EM_Settings.enableQuakes);
        EM_Settings.quakePhysics = config.get(EarSetCat, "Triggers Physics", EM_Settings.quakePhysics, "Can cause major lag at times (Requires main physics to be enabled)").getBoolean(EM_Settings.quakePhysics);
        EM_Settings.quakeRarity = config.get(EarSetCat, "Rarity", EM_Settings.quakeRarity).getInt(EM_Settings.quakeRarity);
        if (EM_Settings.quakeRarity < 0) {
            EM_Settings.quakeRarity = 0;
        }
        String eggCat = "Easter Eggs";
        EM_Settings.thingChance = config.getFloat("Cave Dimension Grue", eggCat, 1.0E-6f, 0.0f, 1.0f, "Chance the (extremely rare) grue in the cave dimension will attack in the dark (ignored on Halloween or Friday 13th)");
        config.save();
    }

    @Deprecated
    private static int getConfigIntWithMinInt(Property prop, int min) {
        if (prop.getInt(min) >= min) {
            return prop.getInt(min);
        }
        prop.set(min);
        return min;
    }

    static int nextAvailPotion(int startID) {
        for (int i = startID; i > 0; ++i) {
            if (i == EM_Settings.hypothermiaPotionID || i == EM_Settings.heatstrokePotionID || i == EM_Settings.frostBitePotionID || i == EM_Settings.dehydratePotionID || i == EM_Settings.insanityPotionID) continue;
            if (i >= Potion.field_76425_a.length) {
                return i;
            }
            if (Potion.field_76425_a[i] != null) continue;
            return i;
        }
        return startID;
    }

    private static File[] GetFileList(String path) {
        File f = new File(path);
        File[] list = f.listFiles();
        list = list != null ? list : new File[]{};
        return list;
    }

    private static boolean isCFGFile(File file) {
        String fileName = file.getName();
        if (file.isHidden()) {
            return false;
        }
        String patternString = "(.*\\.cfg$)";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(fileName);
        String MacCheck = ".DS_Store.cfg";
        if (matcher.matches() && matcher.group(0).toString().toLowerCase() == MacCheck.toLowerCase()) {
            return false;
        }
        return matcher.matches();
    }

    public static void CheckDir(File Dir) {
        boolean dirFlag = false;
        if (Dir.exists()) {
            EnviroMine.logger.log(Level.INFO, "Dir already exist:" + Dir.getName());
            return;
        }
        try {
            Dir.setWritable(true);
            dirFlag = Dir.mkdirs();
            EnviroMine.logger.log(Level.INFO, "Created new Folder " + Dir.getName());
        }
        catch (Exception e) {
            EnviroMine.logger.log(Level.ERROR, "Error occured while creating config directory: " + Dir.getAbsolutePath(), (Throwable)e);
        }
        if (!dirFlag) {
            EnviroMine.logger.log(Level.ERROR, "Failed to create config directory: " + Dir.getAbsolutePath());
        }
    }

    private static void LoadCustomObjects(File customFiles) {
        boolean datFile = EM_ConfigHandler.isCFGFile(customFiles);
        if (datFile) {
            try {
                Configuration config = new Configuration(customFiles, true);
                config.load();
                ArrayList catagory = new ArrayList();
                Set nameList = config.getCategoryNames();
                Iterator nameListData = nameList.iterator();
                while (nameListData.hasNext()) {
                    catagory.add(nameListData.next());
                }
                for (int x = 0; x < catagory.size(); ++x) {
                    String CurCat = (String)catagory.get(x);
                    if (CurCat.isEmpty() || !CurCat.contains(".")) continue;
                    String parent = CurCat.split("\\.")[0];
                    if (propTypes.containsKey(parent) && propTypes.get(parent).useCustomConfigs()) {
                        PropertyBase property = propTypes.get(parent);
                        property.LoadProperty(config, (String)catagory.get(x));
                        continue;
                    }
                    EnviroMine.logger.log(Level.WARN, "Failed to load object " + CurCat);
                }
                config.save();
                loadedConfigs.add(config.getConfigFile().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                EnviroMine.logger.log(Level.ERROR, "FAILED TO LOAD CUSTOM CONFIG: " + customFiles.getName() + "\nNEW SETTINGS WILL BE IGNORED!", (Throwable)e);
                return;
            }
        }
    }

    public static ArrayList<String> getSubCategories(Configuration config, String mainCat) {
        ArrayList<String> category = new ArrayList<String>();
        Set nameList = config.getCategoryNames();
        for (String catName : nameList) {
            if (!catName.startsWith(mainCat + ".")) continue;
            category.add(catName);
        }
        return category;
    }

    public static String getProfileName() {
        return EM_ConfigHandler.getProfileName(loadedProfile);
    }

    public static String getProfileName(String profile) {
        return profile.substring(profilePath.length(), profile.length() - 1).toUpperCase();
    }

    public static boolean ReloadConfig() {
        try {
            EM_Settings.armorProperties.clear();
            EM_Settings.blockProperties.clear();
            EM_Settings.itemProperties.clear();
            EM_Settings.livingProperties.clear();
            EM_Settings.stabilityTypes.clear();
            EM_Settings.biomeProperties.clear();
            EM_Settings.dimensionProperties.clear();
            EM_Settings.rotProperties.clear();
            EM_Settings.caveGenProperties.clear();
            EM_Settings.caveSpawnProperties.clear();
            int Total = EM_ConfigHandler.initConfig();
            EM_ConfigHandler.initProfile();
            EnviroMine.caves.RefreshSpawnList();
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static void loadDefaultProperties() {
        Iterator<PropertyBase> iterator = propTypes.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().GenDefaults();
        }
    }

    public static Configuration getConfigFromObj(Object obj) {
        Configuration config;
        String ModID = ModIdentification.idFromObject(obj);
        File configFile = new File(loadedProfile + customPath + ModID + ".cfg");
        try {
            config = new Configuration(configFile, true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARN, "FAILED TO LOAD Config from OBJECT TO " + ModID + ".CFG");
            return null;
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARN, "FAILED TO LOAD Config from OBJECT TO " + ModID + ".CFG");
            return null;
        }
        return config;
    }

    public static String SaveMyCustom(Object obj) {
        return EM_ConfigHandler.SaveMyCustom(obj, null);
    }

    public static String SaveMyCustom(Object obj, Object type) {
        Configuration config;
        String ModID = ModIdentification.idFromObject(obj);
        File configFile = new File(loadedProfile + customPath + ModID + ".cfg");
        try {
            config = new Configuration(configFile, true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARN, "FAILED TO SAVE NEW OBJECT TO " + ModID + ".CFG");
            return "Failed to Open " + ModID + ".cfg";
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            EnviroMine.logger.log(Level.WARN, "FAILED TO SAVE NEW OBJECT TO " + ModID + ".CFG");
            return "Failed to Open " + ModID + ".cfg";
        }
        config.load();
        String returnValue = "";
        if (obj instanceof Block) {
            BlockProperties.base.generateEmpty(config, obj);
            returnValue = "(Block) Saved to " + ModID + ".cfg on Profile " + EM_ConfigHandler.getProfileName();
        } else if (obj instanceof Entity) {
            Entity en = (Entity)obj;
            int id = 0;
            if (EntityList.func_75619_a((Entity)en) > 0) {
                id = EntityList.func_75619_a((Entity)en);
            } else if (EntityRegistry.instance().lookupModSpawn(en.getClass(), false) != null) {
                id = EntityRegistry.instance().lookupModSpawn(en.getClass(), false).getModEntityId() + 128;
            } else {
                returnValue = "Failed to add config entry. " + en.func_70005_c_() + " has no ID!";
                EnviroMine.logger.log(Level.WARN, "Failed to add config entry. " + en.func_70005_c_() + " has no ID!");
            }
            EntityProperties.base.generateEmpty(config, id);
            returnValue = "(Entity) Saved to " + ModID + ".cfg on Profile " + EM_ConfigHandler.getProfileName();
        } else if (obj instanceof Item && type == null) {
            ItemProperties.base.generateEmpty(config, obj);
            returnValue = "(Item) Saved to " + ModID + ".cfg on Profile " + EM_ConfigHandler.getProfileName();
        } else if (obj instanceof ItemArmor && type instanceof ArmorProperties) {
            ArmorProperties.base.generateEmpty(config, obj);
            returnValue = "(ItemArmor) Saved to " + ModID + ".cfg on Profile " + EM_ConfigHandler.getProfileName();
        }
        config.save();
        return returnValue;
    }

    private void removeProperty(Configuration config, String oldCat, String propName) {
        String remove = "Remove";
        config.moveProperty(oldCat, propName, remove);
        config.removeCategory(config.getCategory(remove));
    }

    static {
        loadedProfile = defaultProfile = profilePath + "default/";
        loadedConfigs = new ArrayList();
        propTypes = new HashMap();
        propTypes.put(BiomeProperties.base.categoryName(), BiomeProperties.base);
        propTypes.put(ArmorProperties.base.categoryName(), ArmorProperties.base);
        propTypes.put(BlockProperties.base.categoryName(), BlockProperties.base);
        propTypes.put(DimensionProperties.base.categoryName(), DimensionProperties.base);
        propTypes.put(EntityProperties.base.categoryName(), EntityProperties.base);
        propTypes.put(ItemProperties.base.categoryName(), ItemProperties.base);
        propTypes.put(RotProperties.base.categoryName(), RotProperties.base);
        globalTypes = new HashMap();
        globalTypes.put(CaveGenProperties.base.categoryName(), CaveGenProperties.base);
        globalTypes.put(CaveSpawnProperties.base.categoryName(), CaveSpawnProperties.base);
        globalTypes.put(CaveBaseProperties.base.categoryName(), CaveBaseProperties.base);
    }
}

