/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui.menu.update;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.client.gui.UpdateNotification;
import enviromine.client.gui.menu.update.NewsPage;
import enviromine.client.gui.menu.update.WordPressPost;
import enviromine.utils.EnviroUtils;
import enviromine.utils.RenderAssist;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class PostGuiList
extends GuiListExtended {
    private final List<Row> LineList = Lists.newArrayList();
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    Minecraft field_148161_k;
    private final float scrollSpeed = 0.025f;

    public PostGuiList(Minecraft mc, int x, int y, int p_i45010_4_, int p_i45010_5_, int p_i45010_6_, int tab) {
        super(mc, x, y, p_i45010_4_, p_i45010_5_, p_i45010_6_);
        this.field_148161_k = mc;
        if (NewsPage.tabSelection == 150 && WordPressPost.Posts != null) {
            this.DisplayWordPressNews(mc);
        } else if (NewsPage.tabSelection == 151) {
            this.EnviromineVersions(mc);
        } else if (NewsPage.tabSelection == 152 && WordPressPost.changeLog != null) {
            this.DisplayChangeLog(mc);
        }
    }

    public void func_148134_d(int p_148134_1_, int p_148134_2_) {
        this.scrollUpButtonID = p_148134_1_;
        this.scrollDownButtonID = p_148134_2_;
        super.func_148134_d(p_148134_1_, p_148134_2_);
    }

    public void EnviromineVersions(Minecraft mc) {
        int verStat = EnviroUtils.compareVersions("1.3.124", UpdateNotification.version);
        if (verStat == -1) {
            this.addLine(StatCollector.func_74837_a((String)"news.enviromine.version.current", (Object[])new Object[]{"1.3.124"}));
            this.addBlankLines(1);
            this.addLine(StatCollector.func_74837_a((String)"updatemsg.enviromine.available", (Object[])new Object[]{UpdateNotification.version}));
            this.addBlankLines(1);
            this.addLine(StatCollector.func_74837_a((String)"news.enviromine.news.changelog", (Object[])new Object[0]));
            this.addBlankLines(1);
            this.addLine(StatCollector.func_74837_a((String)"news.enviromine.news.wiki", (Object[])new Object[0]));
            this.addBlankLines(1);
            this.addLine("https://github.com/Funwayguy/EnviroMine/wiki/Downloads");
            this.addBlankLines(1);
            this.addLine("https://enviromine.wordpress.com/");
        } else if (verStat == 0) {
            this.addLine(StatCollector.func_74837_a((String)"updatemsg.enviromine.uptodate", (Object[])new Object[]{"1.3.124"}));
        } else if (verStat == 1) {
            this.addLine(StatCollector.func_74837_a((String)"updatemsg.enviromine.debug", (Object[])new Object[]{"1.3.124"}));
        } else if (verStat == -2) {
            this.addLine(StatCollector.func_74837_a((String)"updatemsg.enviromine.error", (Object[])new Object[0]));
        }
    }

    public void DisplayChangeLog(Minecraft mc) {
        String[] changlog = WordPressPost.changeLog.split("\n");
        ArrayList lineBreaks = Lists.newArrayList();
        ArrayList wordWrap = Lists.newArrayList();
        for (String line : changlog) {
            List lines = mc.field_71466_p.func_78271_c(line, this.field_148155_a - 64);
            wordWrap.addAll(lines);
            for (int i = 1; i <= lines.size(); ++i) {
                lineBreaks.add(i + "," + lines.size());
            }
        }
        this.addWordWrap(wordWrap, lineBreaks);
    }

    public void DisplayWordPressNews(Minecraft mc) {
        for (WordPressPost post : WordPressPost.Posts) {
            this.addLine(EnumChatFormatting.BOLD + "" + EnumChatFormatting.UNDERLINE + post.getTitle(), textType.TITLE);
            this.addBlankLines(1);
            this.addLine("Posted: " + EnumChatFormatting.ITALIC + post.getPubDate(), textType.DATE);
            this.addBlankLines(1);
            List wordWrap = mc.field_71466_p.func_78271_c(post.getDescription(), this.field_148155_a - 64);
            this.addWordWrap(wordWrap);
            this.addBlankLines(1);
            this.addLine(EnumChatFormatting.ITALIC + "Posted by: " + post.getCreator(), textType.CREATOR);
            this.addBlankLines(2);
            this.addLine("", textType.HR);
            this.addBlankLines(2);
        }
    }

    private void addWordWrap(List<String> wordWrap) {
        for (String line : wordWrap) {
            textType type = textType.DEFAULT;
            this.LineList.add(new Row(line.toString(), type));
        }
    }

    private void addWordWrap(List<String> wordWrap, List<String> LineBreaks) {
        textType lasttype = textType.DEFAULT;
        Iterator<String> wrapped = wordWrap.iterator();
        Iterator<String> breaks = LineBreaks.iterator();
        while (wrapped.hasNext()) {
            String line = wrapped.next();
            String linenum = breaks.next();
            textType type = textType.DEFAULT;
            if (NewsPage.tabSelection == 152) {
                String[] count = linenum.toString().split(",");
                if (Integer.parseInt(count[0]) == 1) {
                    lasttype = type = this.parseChangelog(line.toString());
                } else if (Integer.parseInt(count[0]) <= Integer.parseInt(count[1])) {
                    type = lasttype;
                    if (Integer.parseInt(count[0]) == Integer.parseInt(count[1])) {
                        lasttype = textType.DEFAULT;
                    }
                }
            }
            this.LineList.add(new Row(line.toString(), type));
        }
    }

    private void addBlankLines(int num) {
        for (int i = 0; i < num; ++i) {
            this.addLine("");
        }
    }

    private void addLine(String text) {
        this.addLine(text, textType.DEFAULT);
    }

    private void addLine(String text, textType hr) {
        this.LineList.add(new Row(text, hr));
    }

    private textType parseChangelog(String line) {
        line = line.toLowerCase();
        Pattern versionNum = Pattern.compile("\\[.+\\]");
        Pattern change = Pattern.compile(".*(fixed|\\*|fix|fixes|bug|changed).*");
        Pattern add = Pattern.compile(".*(added|\\+|new|adding).*");
        Pattern removed = Pattern.compile(".*(removed|deleted|revert).*");
        Pattern header = Pattern.compile(".*full enviromine changelog.*");
        if (versionNum.matcher(line).matches()) {
            return textType.VERSION;
        }
        if (change.matcher(line).matches()) {
            return textType.CHANGED;
        }
        if (header.matcher(line).matches()) {
            return textType.HEADER;
        }
        if (removed.matcher(line).matches()) {
            return textType.REMOVED;
        }
        if (add.matcher(line).matches()) {
            return textType.ADD;
        }
        return textType.DEFAULT;
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int p_148180_1_) {
        return this.LineList.get(p_148180_1_);
    }

    protected int func_148127_b() {
        return this.LineList.size();
    }

    protected int func_148138_e() {
        return this.func_148127_b() * Minecraft.func_71410_x().field_71466_p.field_78288_b + this.field_148160_j;
    }

    public int func_148139_c() {
        return this.field_148155_a - 64;
    }

    protected int func_148137_d() {
        return this.field_148155_a - 8;
    }

    public void scrollByMultiplied(float p_148145_1_) {
        super.func_148145_f(MathHelper.func_76123_f((float)(p_148145_1_ * 0.025f)));
    }

    public void func_148147_a(GuiButton p_148147_1_) {
        if (p_148147_1_.field_146124_l) {
            if (p_148147_1_.field_146127_k == this.scrollUpButtonID) {
                this.scrollByMultiplied((float)(-this.field_148149_f) * 2.0f / 3.0f);
            } else if (p_148147_1_.field_146127_k == this.scrollDownButtonID) {
                this.scrollByMultiplied((float)this.field_148149_f * 2.0f / 3.0f);
            }
        }
    }

    public void func_148128_a(int p_148128_1_, int p_148128_2_, float p_148128_3_) {
        if (!(p_148128_1_ <= this.field_148152_e || p_148128_1_ >= this.field_148151_d || p_148128_2_ <= this.field_148153_b || p_148128_2_ >= this.field_148154_c || Mouse.isButtonDown((int)0) && this.func_148125_i())) {
            while (!this.field_148161_k.field_71474_y.field_85185_A && Mouse.next()) {
                float j1 = Mouse.getEventDWheel();
                if (j1 != 0.0f) {
                    this.scrollByMultiplied((j1 *= -1.0f) * (float)this.field_148149_f / 2.0f);
                }
                this.field_148161_k.field_71462_r.func_146274_d();
            }
        }
        super.func_148128_a(p_148128_1_, p_148128_2_, p_148128_3_);
    }

    public static int textTypeColor(textType type) {
        switch (type) {
            case TITLE: {
                return RenderAssist.getColorFromRGBA(21, 153, 21, 255);
            }
            case DATE: {
                return RenderAssist.getColorFromRGBA(71, 134, 186, 255);
            }
            case CREATOR: {
                return RenderAssist.getColorFromRGBA(53, 219, 161, 255);
            }
            case HR: {
                return RenderAssist.getColorFromRGBA(71, 134, 186, 255);
            }
            case VERSION: {
                return RenderAssist.getColorFromRGBA(255, 251, 0, 255);
            }
            case HEADER: {
                return RenderAssist.getColorFromRGBA(110, 129, 255, 255);
            }
            case ADD: {
                return RenderAssist.getColorFromRGBA(0, 255, 0, 255);
            }
            case REMOVED: {
                return RenderAssist.getColorFromRGBA(255, 0, 0, 255);
            }
            case CHANGED: {
                return RenderAssist.getColorFromRGBA(255, 98, 0, 255);
            }
        }
        return 0xFFFFFF;
    }

    public static String textTypeText(textType type, String line) {
        switch (type) {
            case TITLE: {
                line = line.toUpperCase();
                break;
            }
            case HR: {
                String hr = "---------------------------------------------------------------------------------------";
                line = Minecraft.func_71410_x().field_71466_p.func_78269_a(hr, 300);
                break;
            }
        }
        return line;
    }

    static enum textType {
        TITLE,
        DATE,
        CREATOR,
        HR,
        DEFAULT,
        VERSION,
        HEADER,
        ADD,
        REMOVED,
        CHANGED;

    }

    @SideOnly(value=Side.CLIENT)
    public static class Row
    implements GuiListExtended.IGuiListEntry {
        Minecraft mc = Minecraft.func_71410_x();
        public static int LastYpos = 0;
        private String line;
        private textType type;
        int color;

        public Row(String line, textType type) {
            this.line = line;
            this.type = type;
        }

        public void func_148279_a(int p_148279_1_, int p_148279_2_, int p_148279_3_, int p_148279_4_, int p_148279_5_, Tessellator p_148279_6_, int p_148279_7_, int p_148279_8_, boolean p_148279_9_) {
            this.mc.field_71466_p.func_78276_b(PostGuiList.textTypeText(this.type, this.line), 32, p_148279_3_, PostGuiList.textTypeColor(this.type));
        }

        public boolean func_148278_a(int p_148278_1_, int p_148278_2_, int p_148278_3_, int p_148278_4_, int p_148278_5_, int p_148278_6_) {
            return false;
        }

        public void func_148277_b(int p_148277_1_, int p_148277_2_, int p_148277_3_, int p_148277_4_, int p_148277_5_, int p_148277_6_) {
        }
    }
}

