/*
 * Decompiled with CFR 0.152.
 */
package enviromine.client.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import enviromine.client.gui.menu.update.WordPressParser;
import enviromine.client.gui.menu.update.WordPressPost;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.utils.EnviroUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.Level;

public class UpdateNotification {
    boolean hasChecked = false;
    public static String version;
    public static String lastSeen;

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!EnviroMine.proxy.isClient() || this.hasChecked) {
            return;
        }
        this.hasChecked = true;
        this.loadConfigLog();
        this.loadWordPress();
        this.displayUpdateCheck(event);
    }

    private void loadConfigLog() {
        try {
            WordPressPost.changeLog = UpdateNotification.getUrl("https://drone.io/github.com/Funwayguy/EnviroMine-1.7/files/build/libs/full_changelog.txt", true);
        }
        catch (IOException e) {
            EnviroMine.logger.log(Level.WARN, "Failed to get ChangeLog file!");
        }
    }

    private void loadWordPress() {
        block4: {
            try {
                String page = UpdateNotification.getUrl("https://enviromine.wordpress.com/news/feed/", true);
                try {
                    WordPressParser.main(page);
                }
                catch (Exception e) {
                    EnviroMine.logger.log(Level.WARN, "Failed to parse WordPress News Page");
                }
            }
            catch (IOException e) {
                if (!EM_Settings.updateCheck) break block4;
                EnviroMine.logger.log(Level.WARN, "Failed to get WordPress News Page!");
            }
        }
    }

    private void displayUpdateCheck(PlayerEvent.PlayerLoggedInEvent event) {
        block11: {
            try {
                String page = UpdateNotification.getUrl("http://bit.ly/1pwDr2o", true);
                String[] data = page.split("\\n");
                String[] rawVer = data[0].trim().split("\\.");
                version = rawVer[0] + "." + rawVer[1] + "." + rawVer[2];
                if (!EM_Settings.updateCheck) {
                    return;
                }
                String http = data[0].trim();
                int verStat = EnviroUtils.compareVersions("1.3.124", version);
                if (verStat == -1) {
                    event.player.func_145747_a(new ChatComponentTranslation("updatemsg.enviromine.available", new Object[]{version}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                    event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("updatemsg.enviromine.download", new Object[0]));
                    event.player.func_145747_a(new ChatComponentText("https://github.com/Funwayguy/EnviroMine/wiki/Downloads").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.BLUE).func_150228_d(Boolean.valueOf(true))));
                    for (int i = 3; i < data.length; ++i) {
                        if (i > 6) {
                            event.player.func_145747_a((IChatComponent)new ChatComponentText("" + (data.length - 7) + " more..."));
                            break block11;
                        }
                        event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RESET + "" + data[i].trim()));
                    }
                    break block11;
                }
                if (verStat == 0) {
                    event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"updatemsg.enviromine.uptodate", (Object[])new Object[]{"1.3.124"})));
                } else if (verStat == 1) {
                    event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"updatemsg.enviromine.debug", (Object[])new Object[]{"1.3.124"})));
                } else if (verStat == -2) {
                    event.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"updatemsg.enviromine.error", (Object[])new Object[0])));
                }
            }
            catch (IOException e) {
                if (!EM_Settings.updateCheck) break block11;
                EnviroMine.logger.log(Level.WARN, "Failed to get/read versions file!");
            }
        }
    }

    public static String getUrl(String link, boolean doRedirect) throws IOException {
        int chars_read;
        URL url = new URL(link);
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(false);
        con.setReadTimeout(20000);
        con.setRequestProperty("Connection", "keep-alive");
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:16.0) Gecko/20100101 Firefox/16.0");
        con.setRequestMethod("GET");
        con.setConnectTimeout(5000);
        BufferedInputStream in = new BufferedInputStream(con.getInputStream());
        int responseCode = con.getResponseCode();
        if (responseCode != 200 && responseCode != 301) {
            EnviroMine.logger.log(Level.WARN, "Update request returned response code: " + responseCode + " " + con.getResponseMessage());
        } else if (responseCode == 301) {
            if (doRedirect) {
                return UpdateNotification.getUrl(con.getHeaderField("location"), false);
            }
            throw new IOException();
        }
        StringBuffer buffer = new StringBuffer();
        while ((chars_read = in.read()) != -1) {
            char g = (char)chars_read;
            buffer.append(g);
        }
        String page = buffer.toString();
        return page;
    }

    public static void updateLastSeen() {
        if (WordPressPost.Posts.size() > 0) {
            lastSeen = WordPressPost.Posts.get(0).getPubDate();
        }
    }

    public static boolean isNewPost() {
        WordPressPost lastPost;
        if (lastSeen == null) {
            return true;
        }
        return WordPressPost.Posts.isEmpty() || !(lastPost = WordPressPost.Posts.get(0)).getPubDate().toLowerCase().trim().equals(lastSeen.toLowerCase().trim());
    }

    public static void writeToNBT(NBTTagCompound nbt) {
        if (lastSeen != null) {
            nbt.func_74778_a("LastSeen", lastSeen);
        }
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("LastSeen")) {
            lastSeen = nbt.func_74779_i("LastSeen");
        }
    }
}

