/*
 * Decompiled with CFR 0.152.
 */
package enviromine.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.blocks.BlockGas;
import enviromine.blocks.tiles.TileEntityBurningCoal;
import enviromine.blocks.tiles.TileEntityGas;
import enviromine.core.EM_Settings;
import enviromine.gases.EnviroGasDictionary;
import enviromine.handlers.ObjectHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBurningCoal
extends Block
implements ITileEntityProvider {
    public BlockBurningCoal(Material mat) {
        super(mat);
        this.func_149711_c(3.0f).func_149752_b(5.0f).func_149672_a(Block.field_149780_i).func_149658_d("enviromine:burning_coal").func_149715_a(0.625f).func_149675_a(true);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147454_a(x, y, z, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(10), 0);
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        entity.func_70015_d(10);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (world.func_147437_c(x, y + 1, z)) {
            world.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
        }
        if (world.field_72999_e) {
            return;
        }
        world.func_147454_a(x, y, z, (Block)this, this.func_149738_a(world) + rand.nextInt(10), 0);
        TileEntityBurningCoal coalTile = (TileEntityBurningCoal)world.func_147438_o(x, y, z);
        int l = world.func_72805_g(x, y, z);
        boolean flag1 = world.func_72958_C(x, y, z);
        int b0 = 0;
        if (flag1) {
            b0 = -50;
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            ForgeDirection fDir = ForgeDirection.VALID_DIRECTIONS[i];
            int xOff = fDir.offsetX + x;
            int yOff = fDir.offsetY + y;
            int zOff = fDir.offsetZ + z;
            int enco = 300 + b0 - (fDir == ForgeDirection.UP || fDir == ForgeDirection.DOWN ? 50 : 0);
            this.tryCatchFire(world, xOff, yOff, zOff, enco, rand, l, fDir.getOpposite());
            if (EM_Settings.noGases) {
                --coalTile.fuel;
            } else if (world.field_73012_v.nextInt(20) == 0 && (world.func_147439_a(xOff, yOff, zOff) == Blocks.field_150350_a || world.func_147439_a(xOff, yOff, zOff) instanceof BlockGas)) {
                TileEntity tile;
                if (world.func_147439_a(xOff, yOff, zOff) == Blocks.field_150350_a) {
                    world.func_147449_b(xOff, yOff, zOff, ObjectHandler.gasBlock);
                }
                if ((tile = world.func_147438_o(xOff, yOff, zOff)) != null && tile instanceof TileEntityGas) {
                    TileEntityGas gasTile = (TileEntityGas)tile;
                    if (gasTile.amount < 10) {
                        int amount = 10 - gasTile.amount;
                        amount = amount > coalTile.fuel ? coalTile.fuel : amount;
                        gasTile.addGas(EnviroGasDictionary.carbonMonoxide.gasID, amount);
                        coalTile.fuel -= amount;
                    }
                }
            }
            if (coalTile.fuel > 0) continue;
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return;
        }
        for (int i1 = x - 1; i1 <= x + 1; ++i1) {
            for (int j1 = z - 1; j1 <= z + 1; ++j1) {
                for (int k1 = y - 1; k1 <= y + 4; ++k1) {
                    int i2;
                    if (i1 == x && k1 == y && j1 == z) continue;
                    int l1 = 100;
                    if (k1 > y + 1) {
                        l1 += (k1 - (y + 1)) * 100;
                    }
                    if ((i2 = this.getChanceOfNeighborsEncouragingFire(world, i1, k1, j1)) <= 0) continue;
                    int j2 = (i2 + 40 + world.field_73013_u.func_151525_a() * 7) / (l + 30);
                    if (flag1) {
                        j2 /= 2;
                    }
                    if (j2 <= 0 || rand.nextInt(l1) > j2 || world.func_72896_J() && world.func_72951_B(i1, k1, j1) || world.func_72951_B(i1 - 1, k1, z) || world.func_72951_B(i1 + 1, k1, j1) || world.func_72951_B(i1, k1, j1 - 1) || world.func_72951_B(i1, k1, j1 + 1)) continue;
                    int k2 = l + rand.nextInt(5) / 4;
                    if (k2 > 15) {
                        k2 = 15;
                    }
                    world.func_147465_d(i1, k1, j1, (Block)Blocks.field_150480_ab, k2, 3);
                }
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
    }

    private void tryCatchFire(World world, int x, int y, int z, int p_149841_5_, Random random, int chance, ForgeDirection face) {
        int j1 = world.func_147439_a(x, y, z).getFlammability((IBlockAccess)world, x, y, z, face);
        if (random.nextInt(p_149841_5_) < j1) {
            boolean flag;
            boolean bl = flag = world.func_147439_a(x, y, z) == Blocks.field_150335_W;
            if (random.nextInt(chance + 10) < 5 && !world.func_72951_B(x, y, z)) {
                int k1 = chance + random.nextInt(5) / 4;
                if (k1 > 15) {
                    k1 = 15;
                }
                world.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, k1, 3);
            } else {
                world.func_147468_f(x, y, z);
            }
            if (flag) {
                Blocks.field_150335_W.func_149664_b(world, x, y, z, 1);
            }
        }
    }

    private int getChanceOfNeighborsEncouragingFire(World world, int x, int y, int z) {
        int b0 = 0;
        if (!world.func_147437_c(x, y, z)) {
            return 0;
        }
        int l = b0;
        l = this.getChanceToEncourageFire((IBlockAccess)world, x + 1, y, z, l, ForgeDirection.WEST);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x - 1, y, z, l, ForgeDirection.EAST);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y - 1, z, l, ForgeDirection.UP);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y + 1, z, l, ForgeDirection.DOWN);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z - 1, l, ForgeDirection.SOUTH);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z + 1, l, ForgeDirection.NORTH);
        return l;
    }

    public int getChanceToEncourageFire(IBlockAccess world, int x, int y, int z, int oldChance, ForgeDirection face) {
        int newChance = world.func_147439_a(x, y, z).getFireSpreadSpeed(world, x, y, z, face);
        return newChance > oldChance ? newChance : oldChance;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(24) == 0) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "fire.fire", 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        float f = (float)x + 0.5f;
        float f1 = y;
        float f2 = (float)z + 0.5f;
        float f3 = 0.52f;
        float rf1 = rand.nextFloat();
        float rf2 = rand.nextFloat() * 0.6f - 0.3f;
        float rf3 = rand.nextFloat();
        world.func_72869_a("smoke", (double)(f - f3), (double)f1 + (double)rf1, (double)(f2 + rf2), 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)(f - f3), (double)f1 + (double)rf1, (double)(f2 + rf2), 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", (double)(f + f3), (double)f1 + (double)rf1, (double)(f2 + rf2), 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)(f + f3), (double)f1 + (double)rf1, (double)(f2 + rf2), 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", (double)(f + rf2), (double)f1 + (double)rf1, (double)(f2 - f3), 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)(f + rf2), (double)f1 + (double)rf1, (double)(f2 - f3), 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", (double)(f + rf2), (double)f1 + (double)rf1, (double)(f2 + f3), 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)(f + rf2), (double)f1 + (double)rf1, (double)(f2 + f3), 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", (double)(f + rf1 - 0.5f), (double)f1 + (double)1.2f, (double)(f2 + rf3 - 0.5f), 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)(f + rf1 - 0.5f), (double)f1 + (double)1.2f, (double)(f2 + rf3 - 0.5f), 0.0, 0.0, 0.0);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityBurningCoal();
    }
}

