/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.food.BeverageManager;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.LiquidRegistryHelper;
import forestry.core.recipes.RecipeUtil;
import forestry.food.BeverageEffect;
import forestry.food.InfuserIngredientManager;
import forestry.food.InfuserMixtureManager;
import forestry.food.items.EnumBeverage;
import forestry.food.items.ItemRegistryFood;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Food", name="Food", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.food.description")
public class PluginFood
extends ForestryPlugin {
    public static ItemRegistryFood items;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        BeverageManager.infuserManager = new InfuserMixtureManager();
        BeverageManager.ingredientManager = new InfuserIngredientManager();
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryFood();
    }

    @Override
    protected void preInit() {
        super.preInit();
        LiquidRegistryHelper.registerLiquidContainer(Fluids.SHORT_MEAD, 1000, PluginFood.items.beverage.get(EnumBeverage.MEAD_SHORT, 1), new ItemStack(Items.field_151069_bo));
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems != null) {
            ItemStack normalPollenCluster = beeItems.pollenCluster.get(EnumPollenCluster.NORMAL, 1);
            ItemStack crystallinePollenCluster = beeItems.pollenCluster.get(EnumPollenCluster.CRYSTALLINE, 1);
            BeverageManager.ingredientManager.addIngredient(normalPollenCluster, "Strong Curative");
            BeverageManager.ingredientManager.addIngredient(crystallinePollenCluster, "Weak Curative");
            BeverageManager.infuserManager.addMixture(1, normalPollenCluster, BeverageEffect.strongAntidote);
            BeverageManager.infuserManager.addMixture(1, crystallinePollenCluster, BeverageEffect.weakAntidote);
        }
    }

    @Override
    protected void registerRecipes() {
        RecipeUtil.addRecipe(PluginFood.items.infuser.getItemStack(), "X", "#", "X", Character.valueOf('#'), "ingotIron", Character.valueOf('X'), "ingotBronze");
    }
}

