/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.items.ItemForestryFood;
import forestry.core.items.ItemOverlay;
import forestry.food.BeverageEffect;
import forestry.food.items.EnumBeverage;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBeverage
extends ItemForestryFood {
    public final IBeverageInfo[] beverages;

    public ItemBeverage() {
        super(1, 0.2f);
        this.func_77625_d(1);
        this.beverages = EnumBeverage.VALUES;
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        List<IBeverageEffect> effects = BeverageEffect.loadEffects(itemstack);
        --itemstack.field_77994_a;
        entityplayer.func_71024_bL().func_151686_a((ItemFood)this, itemstack);
        world.func_72956_a((Entity)entityplayer, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (world.field_72995_K) {
            return itemstack;
        }
        for (IBeverageEffect effect : effects) {
            effect.doEffect(world, entityplayer);
        }
        return itemstack;
    }

    public int func_150905_g(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        IBeverageInfo beverage = this.beverages[meta];
        return beverage.getHeal();
    }

    public float func_150906_h(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        IBeverageInfo beverage = this.beverages[meta];
        return beverage.getSaturation();
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    @Override
    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        int meta = itemstack.func_77960_j();
        IBeverageInfo beverage = this.beverages[meta];
        if (entityplayer.func_71043_e(beverage.isAlwaysEdible())) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.beverages.length; ++i) {
            if (!Config.isDebug && this.beverages[i].isSecret()) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        List<IBeverageEffect> effects = BeverageEffect.loadEffects(itemstack);
        for (IBeverageEffect effect : effects) {
            if (effect.getDescription() == null) continue;
            list.add(effect.getDescription());
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.beverages[stack.func_77960_j()].getName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (IBeverageInfo info : this.beverages) {
            info.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        if (j > 0 && this.beverages[i].getSecondaryColor() != 0) {
            return this.beverages[i].getIconBottle();
        }
        return this.beverages[i].getIconContents();
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j == 0 || this.beverages[itemstack.func_77960_j()].getSecondaryColor() == 0) {
            return this.beverages[itemstack.func_77960_j()].getPrimaryColor();
        }
        return this.beverages[itemstack.func_77960_j()].getSecondaryColor();
    }

    public ItemStack get(EnumBeverage beverage, int amount) {
        return new ItemStack((Item)this, amount, beverage.ordinal());
    }

    public static interface IBeverageInfo
    extends ItemOverlay.IOverlayInfo {
        public int getHeal();

        public float getSaturation();

        public boolean isAlwaysEdible();

        public void registerIcons(IIconRegister var1);

        public IIcon getIconBottle();

        public IIcon getIconContents();
    }
}

