/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.api.farming.IFarmInventory;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryUtil;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarmHatch;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerLowSoil
extends Trigger {
    private final int threshold;

    public TriggerLowSoil(int threshold) {
        super("lowSoil." + threshold, "lowSoil");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public int minParameters() {
        return 0;
    }

    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer source, IStatementParameter[] parameters) {
        IStatementParameter parameter = null;
        if (parameters.length > 0) {
            parameter = parameters[0];
        }
        if (!(tile instanceof TileFarmHatch)) {
            return false;
        }
        TileFarmHatch tileHatch = (TileFarmHatch)tile;
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)tileHatch.getMultiblockLogic()).getController();
        IFarmInventory farmInventory = farmController.getFarmInventory();
        if (parameter == null || parameter.getItemStack() == null) {
            IInventory resourcesInventory = farmInventory.getResourcesInventory();
            return InventoryUtil.containsPercent(resourcesInventory, this.threshold);
        }
        ItemStack filter = parameter.getItemStack().func_77946_l();
        filter.field_77994_a = this.threshold;
        return farmInventory.hasResources(new ItemStack[]{filter});
    }
}

