/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockLog;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.items.ItemBlockForestry;
import forestry.core.utils.StringUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBlockWood
extends ItemBlockForestry {
    private static final String LEGACY_WOOD_TYPE_KEY = "WoodType";

    public ItemBlockWood(Block block) {
        super(block);
    }

    public static boolean placeWood(ItemStack stack, @Nullable EntityPlayer player, World world, int x, int y, int z, int metadata) {
        EnumWoodType woodType = ItemBlockWood.getWoodType(stack);
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        boolean placed = world.func_147465_d(x, y, z, block, metadata, 3);
        if (!placed) {
            return false;
        }
        Block worldBlock = world.func_147439_a(x, y, z);
        if (!Block.func_149680_a((Block)block, (Block)worldBlock)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileWood)) {
            world.func_147468_f(x, y, z);
            return false;
        }
        if (player != null) {
            worldBlock.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            worldBlock.func_149714_e(world, x, y, z, metadata);
        }
        ((TileWood)tile).setWoodType(woodType);
        return true;
    }

    public static void saveToItemStack(EnumWoodType woodType, ItemStack itemStack) {
        int ordinal = woodType.ordinal();
        itemStack.func_77964_b(ordinal);
    }

    public static EnumWoodType getWoodType(ItemStack stack) {
        EnumWoodType woodType = ItemBlockWood.convertLegacyWood(stack);
        if (woodType == null) {
            int typeOrdinal = stack.func_77960_j();
            woodType = ItemBlockWood.getFromOrdinal(typeOrdinal);
        }
        return woodType;
    }

    private static EnumWoodType convertLegacyWood(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return null;
        }
        NBTTagCompound compound = itemStack.func_77978_p();
        if (!compound.func_74764_b(LEGACY_WOOD_TYPE_KEY)) {
            return null;
        }
        int typeOrdinal = compound.func_74762_e(LEGACY_WOOD_TYPE_KEY);
        EnumWoodType woodType = ItemBlockWood.getFromOrdinal(typeOrdinal);
        if (woodType != null) {
            compound.func_82580_o(LEGACY_WOOD_TYPE_KEY);
            if (compound.func_82582_d()) {
                itemStack.func_77982_d(null);
            }
            ItemBlockWood.saveToItemStack(woodType, itemStack);
        }
        return woodType;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(stack, world, player, p_77663_4_, p_77663_5_);
        ItemBlockWood.convertLegacyWood(stack);
    }

    private static EnumWoodType getFromOrdinal(int ordinal) {
        if (ordinal >= 0 && ordinal < EnumWoodType.VALUES.length) {
            return EnumWoodType.VALUES[ordinal];
        }
        return null;
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return ItemBlockWood.placeWood(stack, player, world, x, y, z, metadata);
    }

    public String func_77653_i(ItemStack itemstack) {
        String displayName;
        Block block = this.getBlock();
        if (!(block instanceof IWoodTyped)) {
            return super.func_77653_i(itemstack);
        }
        EnumWoodType woodType = ItemBlockWood.getWoodType(itemstack);
        if (woodType == null) {
            return super.func_77653_i(itemstack);
        }
        IWoodTyped wood = (IWoodTyped)block;
        String blockKind = wood.getBlockKind();
        String customUnlocalizedName = blockKind + "." + woodType.ordinal() + ".name";
        if (StringUtil.canTranslateTile(customUnlocalizedName)) {
            displayName = StringUtil.localizeTile(customUnlocalizedName);
        } else {
            String woodGrammar = StringUtil.localize(blockKind + ".grammar");
            String woodTypeName = StringUtil.localize("trees.woodType." + (Object)((Object)woodType));
            displayName = woodGrammar.replaceAll("%TYPE", woodTypeName);
        }
        if (wood.isFireproof()) {
            displayName = StringUtil.localizeAndFormatRaw("tile.for.fireproof", displayName);
        }
        return displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        EnumWoodType woodType = ItemBlockWood.getWoodType(stack);
        if (woodType == null) {
            return super.getIcon(stack, pass);
        }
        if (this.getBlock() instanceof BlockLog) {
            return IconProviderWood.getBarkIcon(woodType);
        }
        return IconProviderWood.getPlankIcon(woodType);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }
}

