/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.apiculture.BeehouseBeeModifier;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.blocks.BlockApicultureType;
import forestry.apiculture.entities.EntityMinecartBeeHousingBase;
import forestry.apiculture.gui.ContainerMinecartBeehouse;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.core.config.Config;
import forestry.core.inventory.IInventoryAdapter;
import forestry.plugins.PluginApiculture;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityMinecartBeehouse
extends EntityMinecartBeeHousingBase {
    private static final IBeeModifier beeModifier = new BeehouseBeeModifier();
    private static final IBeeListener beeListener = new DefaultBeeListener();
    private final InventoryBeeHousing beeInventory = new InventoryBeeHousing(9, this.getAccessHandler());

    public EntityMinecartBeehouse(World world) {
        super(world);
        this.beeInventory.disableAutomation();
    }

    public EntityMinecartBeehouse(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.beeInventory.disableAutomation();
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"bee.house");
    }

    @Override
    public Block func_145820_n() {
        return PluginApiculture.blocks.apiculture;
    }

    @Override
    public int func_94098_o() {
        return BlockApicultureType.BEEHOUSE.ordinal();
    }

    @Override
    public ItemStack getCartItem() {
        return PluginApiculture.items.minecartBeehouse.getBeeHouseMinecart();
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singleton(beeModifier);
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(beeListener);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.beeInventory;
    }

    @Override
    protected IInventoryAdapter getInternalInventory() {
        return this.beeInventory;
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        ContainerMinecartBeehouse container = new ContainerMinecartBeehouse(player.field_71071_by, this, false);
        return new GuiBeeHousing<ContainerMinecartBeehouse>(this, container, GuiBeeHousing.Icon.BEE_HOUSE);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerMinecartBeehouse(player.field_71071_by, this, false);
    }
}

