/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs.components;

import gravestone.config.GraveStoneConfig;
import gravestone.core.GSBlock;
import gravestone.structures.BoundingBoxHelper;
import gravestone.structures.MobSpawnHelper;
import gravestone.structures.catacombs.components.CatacombsBaseComponent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class Corridor
extends CatacombsBaseComponent {
    public static final int X_LENGTH = 5;
    public static final int HEIGHT = 5;
    public static final int Z_LENGTH = 5;

    public Corridor(int direction, int level, Random random, int x, int y, int z) {
        super(direction, level);
        this.field_74887_e = BoundingBoxHelper.getCorrectBox(direction, x, y, z, 5, 5, 5, this.xShift);
        this.topXEnd = 0;
        this.topZEnd = 4;
        switch (direction) {
            case 0: {
                this.leftXEnd = 4;
                this.leftZEnd = 0;
                this.rightXEnd = 0;
                this.rightZEnd = 0;
                break;
            }
            case 1: {
                this.leftXEnd = 4;
                this.leftZEnd = 4;
                this.rightXEnd = 0;
                this.rightZEnd = 4;
                break;
            }
            case 2: {
                this.leftXEnd = 0;
                this.leftZEnd = 4;
                this.rightXEnd = 4;
                this.rightZEnd = 4;
                break;
            }
            case 3: {
                this.leftXEnd = 0;
                this.leftZEnd = 0;
                this.rightXEnd = 4;
                this.rightZEnd = 0;
            }
        }
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        this.func_74878_a(world, this.field_74887_e, 1, 1, 0, 3, 3, 3);
        this.func_74882_a(world, this.field_74887_e, 0, 0, 1, 4, 0, 3, false, random, this.getCemeteryCatacombsStones());
        if (GraveStoneConfig.generatePilesOfBones) {
            this.func_151551_a(world, this.field_74887_e, random, 0.35f, 1, 1, 1, 4, 1, 4, (Block)GSBlock.pileOfBones, (Block)GSBlock.pileOfBones, false);
        }
        this.func_151549_a(world, this.field_74887_e, 0, 0, 0, 4, 0, 0, GSBlock.trap, GSBlock.trap, false);
        this.func_151549_a(world, this.field_74887_e, 0, 4, 0, 4, 4, 3, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_74882_a(world, this.field_74887_e, 0, 1, 1, 0, 3, 3, false, random, this.getCemeteryCatacombsStones());
        this.func_74882_a(world, this.field_74887_e, 4, 1, 1, 4, 3, 3, false, random, this.getCemeteryCatacombsStones());
        this.func_74882_a(world, this.field_74887_e, 0, 0, 4, 4, 4, 4, false, random, this.getCemeteryCatacombsStones());
        this.func_151549_a(world, this.field_74887_e, 0, 1, 0, 0, 3, 0, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        this.func_151549_a(world, this.field_74887_e, 4, 1, 0, 4, 3, 0, Blocks.field_150385_bj, Blocks.field_150385_bj, false);
        MobSpawnHelper.spawnBats(world, random, this.field_74887_e);
        this.func_151551_a(world, this.field_74887_e, random, 0.2f, 1, 3, 2, 1, 3, 2, Blocks.field_150321_G, Blocks.field_150321_G, false);
        this.func_151551_a(world, this.field_74887_e, random, 0.2f, 1, 2, 1, 1, 2, 1, Blocks.field_150321_G, Blocks.field_150321_G, false);
        this.func_151551_a(world, this.field_74887_e, random, 0.2f, 3, 2, 3, 3, 2, 3, Blocks.field_150321_G, Blocks.field_150321_G, false);
        this.func_151551_a(world, this.field_74887_e, random, 0.2f, 3, 1, 0, 3, 1, 0, Blocks.field_150321_G, Blocks.field_150321_G, false);
        return true;
    }

    @Override
    public boolean canGoOnlyTop() {
        return false;
    }
}

