/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs;

import gravestone.config.GraveStoneConfig;
import gravestone.core.logger.GSLogger;
import gravestone.structures.GSStructureGenerator;
import gravestone.structures.catacombs.CatacombsSurface;
import gravestone.structures.catacombs.CatacombsUnderground;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class CatacombsGenerator
implements GSStructureGenerator {
    private static CatacombsGenerator instance;
    private static final int VILLAGE_RANGE = 200;
    public static final byte CATACOMBS_RANGE = 100;
    public static final int CATACOMBS_DISTANCE = 1500;
    public static final int DISTANCE_FROM_SPAWN = 1000;
    public static final double DEFAULT_GENERATION_CHANCE = 2.5E-4;
    protected static LinkedList<ChunkCoordIntPair> structuresList;

    private CatacombsGenerator() {
        instance = this;
    }

    public static CatacombsGenerator getInstance() {
        if (instance == null) {
            return new CatacombsGenerator();
        }
        return instance;
    }

    @Override
    public boolean generate(World world, Random rand, int x, int z, double chance, boolean isCommand) {
        if (isCommand || GraveStoneConfig.generateCatacombs && CatacombsGenerator.canSpawnStructureAtCoords(world, x, z, chance) && CatacombsGenerator.isHeightAcceptable(world, x, z)) {
            int direction = rand.nextInt(4);
            CatacombsSurface surface = new CatacombsSurface(world, rand, x, z, direction);
            GSLogger.logInfo("Generate catacombs at " + x + "x" + z);
            if (surface.getMausoleumY() > 55) {
                new CatacombsUnderground(world, rand, direction, surface.getMausoleumX(), surface.getMausoleumY(), surface.getMausoleumZ());
            }
            structuresList.add(new ChunkCoordIntPair(x, z));
            return true;
        }
        return false;
    }

    protected static boolean canSpawnStructureAtCoords(World world, int x, int z, double chance) {
        return chance < GraveStoneConfig.catacombsGenerationChance && CatacombsGenerator.isBiomeAllowed(world, x, z) && CatacombsGenerator.noAnyInRange(x, z, world);
    }

    protected static boolean isBiomeAllowed(World world, int x, int z) {
        LinkedList<BiomeDictionary.Type> biomeTypesList = new LinkedList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_72807_a(x, z))));
        return !biomeTypesList.contains(BiomeDictionary.Type.WATER) && !biomeTypesList.contains(BiomeDictionary.Type.SWAMP) && !biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) && !biomeTypesList.contains(BiomeDictionary.Type.MAGICAL) && !biomeTypesList.contains(BiomeDictionary.Type.HILLS) && !biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN) && (biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.FOREST) || biomeTypesList.contains(BiomeDictionary.Type.FROZEN) || biomeTypesList.contains(BiomeDictionary.Type.WASTELAND));
    }

    protected static boolean noAnyInRange(int x, int z, World world) {
        GSLogger.logInfo("Catacombs generation - Begin Checking area for another catacombs or villages");
        for (ChunkCoordIntPair position : structuresList) {
            if (!CatacombsGenerator.checkStructuresInRange(position.field_77276_a, position.field_77275_b, x, z, 1500)) continue;
            return false;
        }
        if (world.field_72982_D != null && world.field_72982_D.func_75540_b() != null) {
            for (Object villageObj : world.field_72982_D.func_75540_b()) {
                ChunkCoordinates villageCenter = ((Village)villageObj).func_75577_a();
                if (!CatacombsGenerator.checkStructuresInRange(villageCenter.field_71574_a, villageCenter.field_71573_c, x, z, 200)) continue;
                return false;
            }
        }
        if (CatacombsGenerator.checkStructuresInRange(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76074_e(), x, z, 1000)) {
            return false;
        }
        GSLogger.logInfo("Catacombs generation - End Checking area for another catacombs or villages");
        return true;
    }

    private static boolean checkStructuresInRange(int xPos, int zPos, int x, int z, int range) {
        return xPos > x - range && xPos < x + range && zPos > z - range && zPos < z + range;
    }

    public static LinkedList<ChunkCoordIntPair> getStructuresList() {
        return structuresList;
    }

    private static boolean isHeightAcceptable(World world, int x, int z) {
        GSLogger.logInfo("Catacombs generation - Begin Checking area height");
        int height = 0;
        int count = 0;
        for (int xPos = x; xPos < x + 16; ++xPos) {
            for (int zPos = z; zPos < z + 16; ++zPos) {
                height += world.func_72825_h(xPos, zPos);
                ++count;
            }
        }
        GSLogger.logInfo("Catacombs generation - End Checking area height");
        return height / count < GraveStoneConfig.maxCatacombsHeight;
    }

    static {
        structuresList = new LinkedList();
    }
}

