/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures;

import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class BoundingBoxHelper {
    private BoundingBoxHelper() {
    }

    public static StructureBoundingBox getCorrectBox(int direction, int x, int y, int z, int xLength, int height, int zLength, int xShift) {
        int minX = 0;
        int maxX = 0;
        int minY = y;
        int maxY = y + height;
        int minZ = 0;
        int maxZ = 0;
        switch (direction) {
            case 0: {
                minX = x - xShift;
                maxX = x - xShift + xLength;
                minZ = z;
                maxZ = z + zLength;
                break;
            }
            case 1: {
                minX = x - zLength;
                maxX = x;
                minZ = z - xShift;
                maxZ = z - xShift + xLength;
                break;
            }
            case 2: {
                minX = x - xShift;
                maxX = x - xShift + xLength;
                minZ = z - zLength;
                maxZ = z;
                break;
            }
            case 3: {
                minX = x;
                maxX = x + zLength;
                minZ = z - xShift;
                maxZ = z - xShift + xLength;
            }
        }
        return new StructureBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static int getAverageGroundLevel(World world, StructureBoundingBox boundingBox) {
        int height = 0;
        int count = 0;
        for (int z = boundingBox.field_78896_c; z <= boundingBox.field_78892_f; ++z) {
            for (int x = boundingBox.field_78897_a; x <= boundingBox.field_78893_d; ++x) {
                if (!boundingBox.func_78890_b(x, 64, z)) continue;
                height += Math.max(world.func_72825_h(x, z), world.field_73011_w.func_76557_i());
                ++count;
            }
        }
        if (count == 0) {
            return -1;
        }
        return height / count;
    }
}

