/*
 * Decompiled with CFR 0.152.
 */
package gravestone.item.corpse;

import gravestone.ModGraveStone;
import gravestone.item.corpse.CorpseHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class HorseCorpseHelper
extends CorpseHelper {
    private HorseCorpseHelper() {
    }

    public static List<ItemStack> getDefaultCorpses(Item item, int corpseType) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(HorseCorpseHelper.getDefaultHorseCorpse(item, corpseType, 0));
        list.add(HorseCorpseHelper.getDefaultHorseCorpse(item, corpseType, 1));
        list.add(HorseCorpseHelper.getDefaultHorseCorpse(item, corpseType, 2));
        list.add(HorseCorpseHelper.getDefaultHorseCorpse(item, corpseType, 3));
        list.add(HorseCorpseHelper.getDefaultHorseCorpse(item, corpseType, 4));
        return list;
    }

    private static ItemStack getDefaultHorseCorpse(Item item, int corpseType, int type) {
        ItemStack corpse = new ItemStack(item, 1, corpseType);
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("HorseType", type);
        nbtTag.func_74768_a("Variant", 0);
        nbtTag.func_74780_a("Max Health", 25.0);
        nbtTag.func_74780_a("Movement Speed", 0.3);
        nbtTag.func_74780_a("Jump Strength", 0.7);
        corpse.func_77982_d(nbtTag);
        return corpse;
    }

    public static void setNbt(EntityHorse horse, NBTTagCompound nbt) {
        HorseCorpseHelper.setName((EntityLiving)horse, nbt);
        nbt.func_74768_a("HorseType", horse.func_110265_bP());
        nbt.func_74768_a("Variant", horse.func_110202_bQ());
        BaseAttributeMap attrMap = horse.func_110140_aT();
        nbt.func_74780_a("Max Health", attrMap.func_111152_a("Max Health").func_111126_e());
        nbt.func_74780_a("Movement Speed", attrMap.func_111152_a("Movement Speed").func_111126_e());
        nbt.func_74780_a("Jump Strength", attrMap.func_111152_a("Jump Strength").func_111126_e());
    }

    public static void spawnHorse(World world, int x, int y, int z, NBTTagCompound nbtTag, EntityPlayer player) {
        EntityHorse horse = new EntityHorse(world);
        HorseCorpseHelper.setMobName((EntityLiving)horse, nbtTag);
        horse.func_110214_p(HorseCorpseHelper.getHorseType(nbtTag));
        horse.func_110235_q(HorseCorpseHelper.getHorseVariant(nbtTag));
        BaseAttributeMap attrMap = horse.func_110140_aT();
        attrMap.func_111152_a("Max Health").func_111128_a(nbtTag.func_74769_h("Max Health"));
        attrMap.func_111152_a("Movement Speed").func_111128_a(nbtTag.func_74769_h("Movement Speed"));
        attrMap.func_111152_a("Jump Strength").func_111128_a(nbtTag.func_74769_h("Jump Strength"));
        horse.func_110263_g(player);
        HorseCorpseHelper.spawnMob((EntityLiving)horse, world, x, y, z);
    }

    public static void addInfo(List list, NBTTagCompound nbtTag) {
        HorseCorpseHelper.addNameInfo(list, nbtTag);
        if (HorseCorpseHelper.hasType(nbtTag)) {
            list.add(HorseCorpseHelper.getType(nbtTag));
        }
        if (HorseCorpseHelper.hasVariant(nbtTag)) {
            list.add(HorseCorpseHelper.getVariant(nbtTag));
        }
        if (HorseCorpseHelper.hasHP(nbtTag)) {
            list.add(HorseCorpseHelper.getHP(nbtTag));
        }
        if (HorseCorpseHelper.hasSpeed(nbtTag)) {
            list.add(HorseCorpseHelper.getSpeed(nbtTag));
        }
        if (HorseCorpseHelper.hasJumpStrength(nbtTag)) {
            list.add(HorseCorpseHelper.getJumpStrength(nbtTag));
        }
    }

    public static int getHorseType(NBTTagCompound nbtTag) {
        return nbtTag.func_74762_e("HorseType");
    }

    public static int getHorseVariant(NBTTagCompound nbtTag) {
        return nbtTag.func_74762_e("Variant");
    }

    private static boolean hasType(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("HorseType");
    }

    private static String getType(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.horse_type") + " " + ModGraveStone.proxy.getLocalizedString(HorseCorpseHelper.getHorseType(nbtTag.func_74762_e("HorseType")));
    }

    private static String getHorseType(int type) {
        switch (type) {
            case 0: {
                return "item.corpse.horse_type.horse";
            }
            case 1: {
                return "item.corpse.horse_type.donkey";
            }
            case 2: {
                return "item.corpse.horse_type.mule";
            }
            case 3: {
                return "item.corpse.horse_type.zombie";
            }
            case 4: {
                return "item.corpse.horse_type.skeleton";
            }
        }
        return "item.corpse.horse_type.unknown";
    }

    private static boolean hasVariant(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("Variant");
    }

    private static String getVariant(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.horse_variant") + " " + nbtTag.func_74762_e("Variant");
    }

    private static boolean hasHP(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("Max Health");
    }

    private static String getHP(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.health") + " " + nbtTag.func_74769_h("Max Health");
    }

    private static boolean hasSpeed(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("Movement Speed");
    }

    private static String getSpeed(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.speed") + " " + nbtTag.func_74769_h("Movement Speed");
    }

    private static boolean hasJumpStrength(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("Jump Strength");
    }

    private static String getJumpStrength(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.jump_strength") + " " + nbtTag.func_74769_h("Jump Strength");
    }
}

