/*
 * Decompiled with CFR 0.152.
 */
package gravestone.item.corpse;

import gravestone.ModGraveStone;
import gravestone.core.compatibility.GSCompatibilitySophisticatedWolves;
import gravestone.item.corpse.CorpseHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sophisticated_wolves.api.ISophisticatedWolf;
import sophisticated_wolves.api.SophisticatedWolvesAPI;

public class DogCorpseHelper
extends CorpseHelper {
    private DogCorpseHelper() {
    }

    public static List<ItemStack> getDefaultCorpses(Item item, int type) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack corpse = new ItemStack(item, 1, type);
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74774_a("Collar", (byte)14);
        corpse.func_77982_d(nbtTag);
        list.add(corpse);
        return list;
    }

    public static void setNbt(EntityWolf dog, NBTTagCompound nbt) {
        DogCorpseHelper.setName((EntityLiving)dog, nbt);
        nbt.func_74774_a("Collar", (byte)dog.func_82186_bH());
        if (GSCompatibilitySophisticatedWolves.isInstalled() && dog instanceof ISophisticatedWolf) {
            nbt.func_74768_a("Species", ((ISophisticatedWolf)dog).getSpecies());
        }
    }

    public static void spawnDog(World world, int x, int y, int z, NBTTagCompound nbtTag, EntityPlayer player) {
        EntityWolf wolf;
        if (GSCompatibilitySophisticatedWolves.isInstalled() && nbtTag.func_74764_b("Species")) {
            wolf = SophisticatedWolvesAPI.getSophisticatedWolf(world);
            ((ISophisticatedWolf)wolf).updateSpecies(nbtTag.func_74762_e("Species"));
        } else {
            wolf = new EntityWolf(world);
        }
        DogCorpseHelper.setMobName((EntityLiving)wolf, nbtTag);
        wolf.func_70903_f(true);
        wolf.func_70606_j(20.0f);
        wolf.func_152115_b(player.func_110124_au().toString());
        wolf.func_82185_r((int)nbtTag.func_74771_c("Collar"));
        world.func_72960_a((Entity)wolf, (byte)7);
        DogCorpseHelper.spawnMob((EntityLiving)wolf, world, x, y, z);
    }

    public static void addInfo(List list, NBTTagCompound nbtTag) {
        DogCorpseHelper.addNameInfo(list, nbtTag);
        if (DogCorpseHelper.hasCollar(nbtTag)) {
            list.add(DogCorpseHelper.getCollarStr(nbtTag));
        }
        if (GSCompatibilitySophisticatedWolves.isInstalled() && nbtTag.func_74764_b("Species")) {
            list.add(DogCorpseHelper.getSpeciesStr(nbtTag));
        }
    }

    private static boolean hasCollar(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("Collar");
    }

    private static String getCollarStr(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.collar") + " " + ModGraveStone.proxy.getLocalizedString(DogCorpseHelper.getCollar(nbtTag.func_74771_c("Collar")));
    }

    private static String getSpeciesStr(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.dog_type") + " " + nbtTag.func_74762_e("Species");
    }

    private static String getCollar(int type) {
        switch (type) {
            case 0: {
                return "item.corpse.collar.white";
            }
            case 1: {
                return "item.corpse.collar.orange";
            }
            case 2: {
                return "item.corpse.collar.purple";
            }
            case 3: {
                return "item.corpse.collar.azure";
            }
            case 4: {
                return "item.corpse.collar.yellow";
            }
            case 5: {
                return "item.corpse.collar.lime";
            }
            case 6: {
                return "item.corpse.collar.pink";
            }
            case 7: {
                return "item.corpse.collar.grey";
            }
            case 8: {
                return "item.corpse.collar.light_grey";
            }
            case 9: {
                return "item.corpse.collar.turquoise";
            }
            case 10: {
                return "item.corpse.collar.violet";
            }
            case 11: {
                return "item.corpse.collar.blue";
            }
            case 12: {
                return "item.corpse.collar.brown";
            }
            case 13: {
                return "item.corpse.collar.green";
            }
            case 14: {
                return "item.corpse.collar.red";
            }
            case 15: {
                return "item.corpse.collar.black";
            }
        }
        return "item.corpse.collar.unknown";
    }
}

