/*
 * Decompiled with CFR 0.152.
 */
package gravestone.item.corpse;

import gravestone.ModGraveStone;
import gravestone.item.corpse.CorpseHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class CatCorpseHelper
extends CorpseHelper {
    private CatCorpseHelper() {
    }

    public static List<ItemStack> getDefaultCorpses(Item item, int corpseType) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(CatCorpseHelper.getDefaultCatCorpse(item, corpseType, 0));
        list.add(CatCorpseHelper.getDefaultCatCorpse(item, corpseType, 1));
        list.add(CatCorpseHelper.getDefaultCatCorpse(item, corpseType, 2));
        list.add(CatCorpseHelper.getDefaultCatCorpse(item, corpseType, 3));
        return list;
    }

    private static ItemStack getDefaultCatCorpse(Item item, int corpseType, int type) {
        ItemStack corpse = new ItemStack(item, 1, corpseType);
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74774_a("CatType", (byte)type);
        corpse.func_77982_d(nbtTag);
        return corpse;
    }

    public static void setNbt(EntityOcelot cat, NBTTagCompound nbt) {
        CatCorpseHelper.setName((EntityLiving)cat, nbt);
        nbt.func_74774_a("CatType", (byte)cat.func_70913_u());
    }

    public static byte getCatType(NBTTagCompound nbtTag) {
        return nbtTag.func_74771_c("CatType");
    }

    public static void spawnCat(World world, int x, int y, int z, NBTTagCompound nbtTag, EntityPlayer player) {
        EntityOcelot cat = new EntityOcelot(world);
        CatCorpseHelper.setMobName((EntityLiving)cat, nbtTag);
        cat.func_70903_f(true);
        cat.func_70912_b((int)CatCorpseHelper.getCatType(nbtTag));
        cat.func_152115_b(player.func_110124_au().toString());
        world.func_72960_a((Entity)cat, (byte)7);
        CatCorpseHelper.spawnMob((EntityLiving)cat, world, x, y, z);
    }

    public static void addInfo(List list, NBTTagCompound nbtTag) {
        CatCorpseHelper.addNameInfo(list, nbtTag);
        if (CatCorpseHelper.hasType(nbtTag)) {
            list.add(CatCorpseHelper.getType(nbtTag));
        }
    }

    private static boolean hasType(NBTTagCompound nbtTag) {
        return nbtTag.func_74764_b("CatType");
    }

    private static String getType(NBTTagCompound nbtTag) {
        return ModGraveStone.proxy.getLocalizedString("item.corpse.cat_type") + " " + ModGraveStone.proxy.getLocalizedString(CatCorpseHelper.getCatType(nbtTag.func_74771_c("CatType")));
    }

    private static String getCatType(int type) {
        switch (type) {
            case 0: {
                return "item.corpse.cat_type.ocelot";
            }
            case 1: {
                return "item.corpse.cat_type.black";
            }
            case 2: {
                return "item.corpse.cat_type.red";
            }
            case 3: {
                return "item.corpse.cat_type.siamese";
            }
        }
        return "item.corpse.cat_type.unknown";
    }
}

