/*
 * Decompiled with CFR 0.152.
 */
package gravestone.inventory;

import gravestone.block.GraveStoneHelper;
import gravestone.block.enums.EnumGraves;
import gravestone.config.GraveStoneConfig;
import gravestone.tileentity.TileEntityGSGraveStone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class GraveInventory
implements IInventory {
    public static final int DEFAULT_INVENTORY_SIZE = 54;
    private TileEntityGSGraveStone tileEntity;
    protected List<ItemStack> items = new ArrayList<ItemStack>(54);
    private static final int[] POTION_LIST = new int[]{16273, 16307, 16341, 16310, 16281, 16318, 32657, 32658, 32659, 32725, 32694, 32665, 32702};
    private static final int EGG_PIG = 90;
    private static final int EGG_SHEEP = 91;
    private static final int EGG_COW = 92;
    private static final int EGG_CHICKEN = 93;
    private static final int EGG_SQUID = 94;
    private static final int EGG_WOLF = 95;
    private static final int EGG_MUSHROOM_COW = 96;
    private static final int EGG_CAT = 98;
    private static final int EGG_HORSE = 100;
    private static final int EGG_VILLAGER = 120;

    public GraveInventory(TileEntityGSGraveStone tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void readItems(NBTTagCompound nbtTag) {
        NBTTagList ntbItemsList = nbtTag.func_150295_c("Items", 10);
        this.items = new ArrayList<ItemStack>(54);
        for (int i = 0; i < ntbItemsList.func_74745_c(); ++i) {
            NBTTagCompound nbt = ntbItemsList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
            if (stack == null) continue;
            this.items.add(stack);
        }
    }

    public void saveItems(NBTTagCompound nbtTag) {
        NBTTagList ntbList = new NBTTagList();
        for (ItemStack stack : this.items) {
            if (stack == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77955_b(nbt);
            ntbList.func_74742_a((NBTBase)nbt);
        }
        nbtTag.func_74782_a("Items", (NBTBase)ntbList);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void addInventoryContent(ItemStack itemStack) {
        if (itemStack != null) {
            this.items.add(itemStack);
        }
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public int getSizeInventoryForGui() {
        return this.items.size() > 54 ? this.items.size() : 54;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < this.items.size()) {
            return this.items.get(slot);
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.items.size()) {
            this.items.set(slot, stack);
        }
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.field_70170_p.func_147438_o(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e) == this.tileEntity && player.func_70092_e((double)this.tileEntity.field_145851_c + 0.5, (double)this.tileEntity.field_145848_d + 0.5, (double)this.tileEntity.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public void setItems(List<ItemStack> items) {
        if (items != null) {
            switch (GraveStoneConfig.graveItemsCount) {
                case 0: {
                    for (ItemStack item : items) {
                        GraveInventory.dropItem(item, this.tileEntity.func_145831_w(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
                    }
                    break;
                }
                case 40: {
                    for (ItemStack item : items) {
                        this.addInventoryContent(item);
                    }
                    break;
                }
                default: {
                    int savedItems = GraveStoneConfig.graveItemsCount;
                    Collections.shuffle(Arrays.asList(items.size()), new Random());
                    for (ItemStack item : items) {
                        if (item != null && savedItems > 0) {
                            this.addInventoryContent(item);
                            --savedItems;
                            continue;
                        }
                        GraveInventory.dropItem(item, this.tileEntity.func_145831_w(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
                    }
                }
            }
        }
    }

    public void setAdditionalItems(ItemStack[] items) {
        if (items != null) {
            for (ItemStack item : items) {
                this.addInventoryContent(item);
            }
        }
    }

    public void setAdditionalItems(List<ItemStack> items) {
        if (items != null) {
            for (ItemStack item : items) {
                this.addInventoryContent(item);
            }
        }
    }

    public static void dropItem(ItemStack items, World world, int x, int y, int z) {
        if (items != null) {
            Random random = new Random();
            float var10 = random.nextFloat() * 0.8f + 0.1f;
            float var11 = random.nextFloat() * 0.8f + 0.1f;
            float var12 = random.nextFloat() * 0.8f + 0.1f;
            while (items.field_77994_a > 0) {
                int var13 = random.nextInt(21) + 10;
                if (var13 > items.field_77994_a) {
                    var13 = items.field_77994_a;
                }
                items.field_77994_a -= var13;
                EntityItem entityItem = new EntityItem(world, (double)((float)x + var10), (double)((float)y + var11), (double)((float)z + var12), new ItemStack(items.func_77973_b(), var13, items.func_77960_j()));
                entityItem.field_70159_w = random.nextGaussian() * (double)0.05f;
                entityItem.field_70181_x = random.nextGaussian() * (double)0.15f;
                entityItem.field_70179_y = random.nextGaussian() * (double)0.05f;
                if (items.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d((NBTTagCompound)items.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityItem);
            }
        }
    }

    public void dropItem(int slot) {
        GraveInventory.dropItem(this.items.get(slot), this.tileEntity.func_145831_w(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
    }

    public void dropItem(ItemStack stack) {
        GraveInventory.dropItem(stack, this.tileEntity.func_145831_w(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
    }

    public void dropAllItems() {
        for (ItemStack stack : this.items) {
            this.dropItem(stack);
        }
        this.items.clear();
    }

    public List<ItemStack> getGraveContent() {
        return this.items;
    }

    public void setRandomGraveContent(IInventory inventory, Random random, boolean isPetGrave, boolean allLoot) {
        this.addInventoryContent(new ItemStack(Items.field_151103_aS, 1 + random.nextInt(5), 0));
        this.addInventoryContent(new ItemStack(Items.field_151078_bh, 1 + random.nextInt(5), 0));
        if (isPetGrave) {
            this.fillPetGrave(random);
        } else if (this.tileEntity.getGraveType().ordinal() != 3 && this.tileEntity.getGraveType().ordinal() != 4) {
            if (random.nextInt(50) == 0) {
                if (random.nextInt(2) == 0) {
                    this.addInventoryContent(new ItemStack(Items.field_151144_bL, 1, 0));
                } else {
                    this.addInventoryContent(new ItemStack(Items.field_151144_bL, 1, 2));
                }
            }
            int graveType = random.nextInt(80);
            if (allLoot) {
                if (this.tileEntity.isSwordGrave() && graveType > 5) {
                    this.fillWarriorGrave(random, true);
                } else if (graveType < 4) {
                    this.fillAdventureGrave(random);
                } else if (graveType < 7) {
                    this.fillWorkerGrave(random);
                } else if (graveType < 10) {
                    this.fillWizardGrave(random);
                } else if (graveType < 12) {
                    this.fillMinerGrave(random);
                } else if (graveType == 13) {
                    this.fillWarriorGrave(random, false);
                }
            } else if (graveType < 3) {
                this.fillWorkerGrave(random);
            }
        }
    }

    private void fillWarriorGrave(Random random, boolean isSwordGrave) {
        if (isSwordGrave) {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151027_R, 1, GraveInventory.getRandomDamage(random, 30)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151026_S, 1, GraveInventory.getRandomDamage(random, 30)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151024_Q, 1, GraveInventory.getRandomDamage(random, 30)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151021_T, 1, GraveInventory.getRandomDamage(random, 30)));
            }
            return;
        }
        int armorType = random.nextInt(10);
        if (armorType > 5) {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151030_Z, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151165_aa, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151028_Y, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151167_ab, 1, GraveInventory.getRandomDamage(random)));
            }
            this.changeGraveTypeToSword(Items.field_151040_l, GraveInventory.getRandomDamage(random));
        } else if (armorType > 2) {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151023_V, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151022_W, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151020_U, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151029_X, 1, GraveInventory.getRandomDamage(random)));
            }
            this.changeGraveTypeToSword(Items.field_151040_l, GraveInventory.getRandomDamage(random));
        } else if (armorType > 0) {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151171_ah, 1, GraveInventory.getRandomDamage(random, 50)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151149_ai, 1, GraveInventory.getRandomDamage(random, 50)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151169_ag, 1, GraveInventory.getRandomDamage(random, 30)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151151_aj, 1, GraveInventory.getRandomDamage(random, 40)));
            }
            this.changeGraveTypeToSword(Items.field_151010_B, GraveInventory.getRandomDamage(random, 15));
        } else {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151163_ad, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151173_ae, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151161_ac, 1, GraveInventory.getRandomDamage(random)));
            }
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack((Item)Items.field_151175_af, 1, GraveInventory.getRandomDamage(random)));
            }
            this.changeGraveTypeToSword(Items.field_151048_u, GraveInventory.getRandomDamage(random));
        }
        if (random.nextInt(3) == 0) {
            this.addInventoryContent(new ItemStack((Item)Items.field_151031_f, 1, GraveInventory.getRandomDamage(random)));
            this.addInventoryContent(new ItemStack(Items.field_151032_g, 10 + random.nextInt(54), 0));
        }
    }

    private void changeGraveTypeToSword(Item sword, int swordDamage) {
        this.tileEntity.setGraveType((byte)EnumGraves.SWORD.ordinal());
        this.tileEntity.setSword(new ItemStack(sword, 1, swordDamage));
    }

    private void fillMinerGrave(Random random) {
        if (random.nextInt(2) == 0) {
            int pickAxeType = random.nextInt(10);
            if (pickAxeType > 3) {
                this.addInventoryContent(new ItemStack(Items.field_151035_b, 1, GraveInventory.getRandomDamage(random)));
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_IRON_GRAVES), random));
            } else if (pickAxeType > 0) {
                this.addInventoryContent(new ItemStack(Items.field_151005_D, 1, GraveInventory.getRandomDamage(random, 15)));
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_GOLDEN_GRAVES), random));
            } else {
                this.addInventoryContent(new ItemStack(Items.field_151046_w, 1, GraveInventory.getRandomDamage(random)));
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_DIAMOND_GRAVES), random));
            }
        }
        switch (random.nextInt(10)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151045_i, 1 + random.nextInt(3), 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151166_bC, 1 + random.nextInt(3), 0));
            }
        }
        switch (random.nextInt(5)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151043_k, 3 + random.nextInt(5), 0));
                break;
            }
            case 1: 
            case 2: {
                this.addInventoryContent(new ItemStack(Items.field_151043_k, 3 + random.nextInt(5), 0));
            }
        }
        switch (random.nextInt(5)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151137_ax, 3 + random.nextInt(8), 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151100_aR, 3 + random.nextInt(8), 4));
            }
        }
    }

    private void fillWizardGrave(Random random) {
        switch (random.nextInt(10)) {
            case 0: {
                EnchantmentData data = new EnchantmentData(Enchantment.field_92090_c[random.nextInt(Enchantment.field_92090_c.length)], 1 + random.nextInt(5));
                ItemStack items = Items.field_151134_bR.func_92111_a(data);
                this.addInventoryContent(items);
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_REDSTONE_GRAVES), random));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack((Item)Items.field_151068_bn, 1 + random.nextInt(5), POTION_LIST[random.nextInt(POTION_LIST.length)]));
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_QUARTZ_GRAVES), random));
                break;
            }
            case 2: 
            case 3: {
                this.addInventoryContent(new ItemStack(Items.field_151122_aG, 3 + random.nextInt(8), 0));
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_LAPIS_GRAVES), random));
            }
        }
        switch (random.nextInt(15)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151079_bi, 1, 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151065_br, 1, 0));
                break;
            }
            case 2: {
                this.addInventoryContent(new ItemStack(Items.field_151114_aO, 3 + random.nextInt(8), 0));
            }
        }
        switch (random.nextInt(6)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151064_bs, 1, 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151016_H, 1, 0));
            }
        }
        switch (random.nextInt(10)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151073_bk, 1, 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151075_bm, 1, 0));
            }
        }
        switch (random.nextInt(5)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151070_bp, 1, 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151071_bq, 1, 0));
            }
        }
        switch (random.nextInt(8)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151150_bK, 1, 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151060_bw, 1, 0));
            }
        }
    }

    private void fillWorkerGrave(Random random) {
        int toolType = random.nextInt(10);
        if (toolType > 3) {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack(Items.field_151036_c, 1, GraveInventory.getRandomDamage(random)));
            } else {
                this.addInventoryContent(new ItemStack(Items.field_151037_a, 1, GraveInventory.getRandomDamage(random)));
            }
            this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_IRON_GRAVES), random));
        } else if (toolType > 0) {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack(Items.field_151006_E, 1, GraveInventory.getRandomDamage(random, 15)));
            } else {
                this.addInventoryContent(new ItemStack(Items.field_151011_C, 1, GraveInventory.getRandomDamage(random, 15)));
            }
            this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_GOLDEN_GRAVES), random));
        } else {
            if (random.nextInt(2) == 0) {
                this.addInventoryContent(new ItemStack(Items.field_151056_x, 1, GraveInventory.getRandomDamage(random)));
            } else {
                this.addInventoryContent(new ItemStack(Items.field_151047_v, 1, GraveInventory.getRandomDamage(random)));
            }
            this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_DIAMOND_GRAVES), random));
        }
        switch (random.nextInt(6)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151119_aD, 1 + random.nextInt(8), 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151118_aC, 3 + random.nextInt(5), 0));
            }
        }
        switch (random.nextInt(6)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151116_aA, 1 + random.nextInt(5), 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151133_ar, 1, 0));
            }
        }
        if (random.nextInt(8) == 0) {
            this.addInventoryContent(new ItemStack(Items.field_151141_av, 1, 0));
        }
    }

    private void fillAdventureGrave(Random random) {
        switch (random.nextInt(8)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151111_aL, 1, 0));
                break;
            }
            case 1: {
                this.addInventoryContent(new ItemStack(Items.field_151113_aN, 1, 0));
                break;
            }
            case 2: {
                this.addInventoryContent(new ItemStack((Item)Items.field_151148_bJ, 1, 0));
            }
        }
        switch (random.nextInt(10)) {
            case 0: {
                this.addInventoryContent(new ItemStack(Items.field_151159_an, 1 + random.nextInt(5), 0));
                break;
            }
            case 1: {
                this.addInventoryContent(this.getRandomRecord(random));
                break;
            }
            case 2: {
                this.addInventoryContent(new ItemStack(Items.field_151099_bA, 1, 0));
            }
        }
        if (random.nextInt(4) == 0) {
            this.addInventoryContent(new ItemStack(Items.field_151055_y, 3 + random.nextInt(9), 0));
        }
        if (random.nextInt(5) == 0) {
            this.addInventoryContent(new ItemStack(Items.field_151106_aX, 3 + random.nextInt(5), 0));
        }
        if (random.nextInt(15) == 0) {
            this.addInventoryContent(this.getRandomEgg(random));
            this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.GENERATED_EMERALD_GRAVES), random));
        }
    }

    private void fillPetGrave(Random random) {
        if (random.nextInt(10) == 0) {
            this.addInventoryContent(new ItemStack(Items.field_151058_ca, 1, 0));
            if (Arrays.asList(new byte[][]{GraveStoneHelper.DOGS_GRAVES}).contains(this.tileEntity.getGraveType())) {
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.DOG_GOLDEN_GRAVES), random));
            } else if (Arrays.asList(GraveStoneHelper.CATS_GRAVES).contains(this.tileEntity.getGraveType())) {
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.CAT_GOLDEN_GRAVES), random));
            }
        }
        if (random.nextInt(10) == 0) {
            this.addInventoryContent(new ItemStack(Items.field_151057_cb, 1, 0));
            if (Arrays.asList(new byte[][]{GraveStoneHelper.DOGS_GRAVES}).contains(this.tileEntity.getGraveType())) {
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.DOG_DIAMOND_GRAVES), random));
            } else if (Arrays.asList(GraveStoneHelper.CATS_GRAVES).contains(this.tileEntity.getGraveType())) {
                this.tileEntity.setGraveType(GraveStoneHelper.getRandomGrave(Arrays.asList(GraveStoneHelper.CAT_DIAMOND_GRAVES), random));
            }
        }
    }

    public static int getRandomDamage(Random random) {
        return 20 + random.nextInt(100);
    }

    public static int getRandomDamage(Random random, int maxDamage) {
        return random.nextInt(maxDamage);
    }

    private ItemStack getRandomRecord(Random random) {
        switch (random.nextInt(13)) {
            case 1: {
                return new ItemStack(Items.field_151093_ce, 1, 0);
            }
            case 2: {
                return new ItemStack(Items.field_151094_cf, 1, 0);
            }
            case 3: {
                return new ItemStack(Items.field_151091_cg, 1, 0);
            }
            case 4: {
                return new ItemStack(Items.field_151092_ch, 1, 0);
            }
            case 5: {
                return new ItemStack(Items.field_151089_ci, 1, 0);
            }
            case 6: {
                return new ItemStack(Items.field_151090_cj, 1, 0);
            }
            case 7: {
                return new ItemStack(Items.field_151087_ck, 1, 0);
            }
            case 8: {
                return new ItemStack(Items.field_151088_cl, 1, 0);
            }
            case 9: {
                return new ItemStack(Items.field_151085_cm, 1, 0);
            }
            case 10: {
                return new ItemStack(Items.field_151086_cn, 1, 0);
            }
            case 11: {
                return new ItemStack(Items.field_151084_co, 1, 0);
            }
            case 12: {
                return new ItemStack(Items.field_151096_cd, 1, 0);
            }
        }
        return new ItemStack(Items.field_151093_ce, 1, 0);
    }

    private ItemStack getRandomEgg(Random random) {
        switch (random.nextInt(11)) {
            case 1: {
                return new ItemStack(Items.field_151063_bx, 1, 90);
            }
            case 2: {
                return new ItemStack(Items.field_151063_bx, 1, 91);
            }
            case 3: {
                return new ItemStack(Items.field_151063_bx, 1, 92);
            }
            case 4: {
                return new ItemStack(Items.field_151063_bx, 1, 93);
            }
            case 5: {
                return new ItemStack(Items.field_151063_bx, 1, 94);
            }
            case 6: {
                return new ItemStack(Items.field_151063_bx, 1, 95);
            }
            case 7: {
                return new ItemStack(Items.field_151063_bx, 1, 96);
            }
            case 8: {
                return new ItemStack(Items.field_151063_bx, 1, 98);
            }
            case 9: {
                return new ItemStack(Items.field_151063_bx, 1, 100);
            }
            case 10: {
                return new ItemStack(Items.field_151063_bx, 1, 120);
            }
        }
        return new ItemStack(Items.field_151063_bx, 1, 120);
    }
}

