/*
 * Decompiled with CFR 0.152.
 */
package gravestone.core;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gravestone.ModGraveStone;
import gravestone.config.GraveStoneConfig;
import gravestone.core.logger.GSLogger;
import gravestone.structures.GraveStoneWorldGenerator;
import gravestone.structures.village.ComponentGSVillageCemetery;
import gravestone.structures.village.ComponentGSVillageMemorial;
import gravestone.structures.village.ComponentGSVillageUndertaker;
import gravestone.structures.village.VillageHandlerGSCemetery;
import gravestone.structures.village.VillageHandlerGSMemorial;
import gravestone.structures.village.VillageHandlerGSUndertaker;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.structure.MapGenStructureIO;

public class GSStructures {
    public static final Block[] VALUEBLE_BLOCKS = new Block[]{Blocks.field_150340_R, Blocks.field_150368_y, Blocks.field_150451_bX, Blocks.field_150340_R, Blocks.field_150368_y, Blocks.field_150451_bX, Blocks.field_150484_ah, Blocks.field_150475_bE};
    private static GSStructures instance;

    private GSStructures() {
        this.generateStructures();
    }

    public static GSStructures getInstance() {
        if (instance == null) {
            return new GSStructures();
        }
        return instance;
    }

    public static void preInit() {
        if (GraveStoneConfig.generateCemeteries) {
            try {
                MapGenStructureIO.func_143031_a(ComponentGSVillageCemetery.class, (String)"GSVillageCemetery");
            }
            catch (Throwable e) {
                GSLogger.logError("Can not register ComponentGSVillageCemetery");
                e.printStackTrace();
            }
        }
        if (GraveStoneConfig.generateVillageMemorials) {
            try {
                MapGenStructureIO.func_143031_a(ComponentGSVillageMemorial.class, (String)"GSVillageMemorial");
            }
            catch (Throwable e) {
                GSLogger.logError("Can not register ComponentGSVillageMemorial");
                e.printStackTrace();
            }
        }
        if (GraveStoneConfig.generateUndertaker) {
            try {
                MapGenStructureIO.func_143031_a(ComponentGSVillageUndertaker.class, (String)"GSUndertakerHouse");
            }
            catch (Throwable e) {
                GSLogger.logError("Can not register ComponentGSVillageUndertaker");
                e.printStackTrace();
            }
        }
    }

    private void generateStructures() {
        if (GraveStoneConfig.generateCemeteries) {
            VillageHandlerGSCemetery villageCemeteryHandler = new VillageHandlerGSCemetery();
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageCemeteryHandler);
        }
        if (GraveStoneConfig.generateVillageMemorials) {
            VillageHandlerGSMemorial villageMemorialHandler = new VillageHandlerGSMemorial();
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageMemorialHandler);
        }
        if (GraveStoneConfig.generateUndertaker) {
            VillageHandlerGSUndertaker villageUndertakerHandler = new VillageHandlerGSUndertaker();
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageUndertakerHandler);
            VillagerRegistry.instance().registerVillagerId(385);
            ModGraveStone.proxy.registerVillagers();
            VillagerRegistry.instance().registerVillageTradeHandler(385, (VillagerRegistry.IVillageTradeHandler)villageUndertakerHandler);
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GraveStoneWorldGenerator(), (int)50);
    }
}

