/*
 * Decompiled with CFR 0.152.
 */
package gravestone.config;

import cpw.mods.fml.client.registry.RenderingRegistry;
import gravestone.block.GraveStoneHelper;
import gravestone.config.GravesDefaultText;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GraveStoneConfig {
    private static Configuration config;
    private static GraveStoneConfig instance;
    private static String path;
    public static final String CATEGORY_COMPATIBILITY = "compatibility";
    public static final String CATEGORY_POTIONS = "potions";
    public static final String CATEGORY_STRUCTURES_CATACOMBS = "structures_catacombs";
    public static final String CATEGORY_RECIPES = "recipes";
    public static int graveRenderID;
    public static int memorialRenderID;
    public static int spawnerRenderID;
    public static int skullCandleRenderID;
    public static int candleRenderID;
    public static int pileOfBonesRenderID;
    public static int structuresDimensionId;
    public static boolean generateCatacombs;
    public static boolean generateSingleGraves;
    public static boolean generateMemorials;
    public static int maxCatacombsHeight;
    public static double catacombsGenerationChance;
    public static boolean generateCemeteries;
    public static boolean generateVillageMemorials;
    public static boolean generateUndertaker;
    public static boolean generatePlayerGraves;
    public static boolean generateVillagerGraves;
    public static boolean generatePetGraves;
    public static boolean generateGravesInLava;
    public static int graveItemsCount;
    public static int graveSpawnRate;
    public static boolean canPlaceGravesEveryWhere;
    public static boolean spawnMobAtGraveDestruction;
    public static boolean isFogEnabled;
    public static boolean enableNightStone;
    public static boolean enableThunderStone;
    public static boolean showNightStoneMessage;
    public static boolean enableCreeperStatuesRecipes;
    public static boolean enableBossSpawnerCraftingRecipe;
    public static boolean enableSpawnerCraftingRecipe;
    public static boolean craftableNightStone;
    public static boolean craftableThunderStone;
    public static boolean hardAltarRecipe;
    public static boolean replaceHauntedChest;
    public static ArrayList<String> graveNames;
    public static ArrayList<String> graveDogsNames;
    public static ArrayList<String> graveCatsNames;
    public static ArrayList<String> graveDeathMessages;
    public static ArrayList<String> memorialText;
    public static ArrayList<String> dogsMemorialText;
    public static ArrayList<String> catsMemorialText;
    public static boolean spawnZombieDogs;
    public static boolean spawnZombieCats;
    public static boolean spawnSkeletonDogs;
    public static boolean spawnSkeletonCats;
    public static boolean spawnSkullCrawlersAtMobsDeath;
    public static boolean spawnSkullCrawlersAtBoneBlockDestruction;
    public static boolean generateSwordGraves;
    public static int spawnChance;
    public static boolean removeEmptyGraves;
    public static boolean showGravesRemovingMessages;
    public static boolean generateCatacombsGraveyard;
    public static int catacombsMinRoomsCountAt1Level;
    public static int catacombsMaxRoomsCountAt1Level;
    public static int catacombsMinRoomsCountAt2Level;
    public static int catacombsMaxRoomsCountAt2Level;
    public static int catacombsMinRoomsCountAt3Level;
    public static int catacombsMaxRoomsCountAt3Level;
    public static int catacombsMinRoomsCountAt4Level;
    public static int catacombsMaxRoomsCountAt4Level;
    public static boolean generatePilesOfBones;
    public static boolean generateGravesInMushroomBiomes;
    public static int undertakerId;
    public static int cursePotionEffectId;
    public static boolean spawnMoCreaturesMobs;
    public static boolean enableForestryBackpacks;
    public static boolean storeBattlegearItems;
    public static boolean storeTheCampingModItems;
    public static boolean storeBaublesItems;
    public static boolean storeMaricultureItems;
    public static boolean storeTinkerConstructItems;
    public static boolean storeRpgInventoryItems;
    public static boolean storeGalacticraftItems;
    public static boolean storeBackpacksItems;
    public static boolean enableArsMagicaSoulbound;
    public static boolean enableEnderIOSoulbound;
    public static boolean enableTwilightForestKeeping;
    public static boolean enableAntiqueAtlasDeathMarkers;
    public static List<GraveStoneHelper.RestrictedArea> restrictGraveGenerationInArea;

    private GraveStoneConfig(String path, File configFile) {
        config = new Configuration(configFile);
        GraveStoneConfig.path = path;
        this.getConfigs();
    }

    public static GraveStoneConfig getInstance(String path, String configFile) {
        if (instance == null) {
            return new GraveStoneConfig(path, new File(path + configFile));
        }
        return instance;
    }

    public final void getConfigs() {
        config.load();
        GraveStoneConfig.structures();
        GraveStoneConfig.gravesConfig();
        GraveStoneConfig.entityConfig();
        GraveStoneConfig.compatibilityConfigs();
        config.save();
        this.getGravesText();
    }

    private static void structures() {
        structuresDimensionId = config.get("general", "StructuresDimensionId", 0).getInt();
        generateCatacombs = config.get("general", "GenerateCatacombs", true).getBoolean(true);
        maxCatacombsHeight = config.get("general", "MaximumCatacombsGenerationHeight", 75).getInt();
        catacombsGenerationChance = config.get("general", "CatacombsGenerationChance", 2.5E-4).getDouble();
        generateCatacombsGraveyard = config.get("general", "GenerateCatacombsGraveyard", true).getBoolean(true);
        generateGravesInMushroomBiomes = config.get("general", "GenerateGravesInMushroomBiomes", true).getBoolean(true);
        generateMemorials = config.get("general", "GenerateMemorials", true).getBoolean(true);
        generateSingleGraves = config.get("general", "GenerateSingleGraves", true).getBoolean(true);
        generateCemeteries = config.get("general", "GenerateCemeteries", true).getBoolean(true);
        generateVillageMemorials = config.get("general", "GenerateVillageMemorials", true).getBoolean(true);
        generateUndertaker = config.get("general", "GenerateUndertaker", true).getBoolean(true);
        undertakerId = config.get("general", "undertakerId", 385).getInt();
        generatePilesOfBones = config.get(CATEGORY_STRUCTURES_CATACOMBS, "GeneratePilesOfBones", true).getBoolean(true);
        catacombsMinRoomsCountAt1Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMinRoomsCountAt1Level", 30).getInt();
        catacombsMaxRoomsCountAt1Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMaxRoomsCountAt1Level", 60).getInt();
        catacombsMinRoomsCountAt2Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMinRoomsCountAt2Level", 60).getInt();
        catacombsMaxRoomsCountAt2Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMaxRoomsCountAt2Level", 120).getInt();
        catacombsMinRoomsCountAt3Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMinRoomsCountAt3Level", 90).getInt();
        catacombsMaxRoomsCountAt3Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMaxRoomsCountAt3Level", 180).getInt();
        catacombsMinRoomsCountAt4Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMinRoomsCountAt4Level", 160).getInt();
        catacombsMaxRoomsCountAt4Level = config.get(CATEGORY_STRUCTURES_CATACOMBS, "CatacombsMaxRoomsCountAt4Level", 320).getInt();
    }

    private static void gravesConfig() {
        canPlaceGravesEveryWhere = config.get("general", "CanPlaceGravesEveryWhere", false).getBoolean(false);
        generatePlayerGraves = config.get("general", "GeneratePlayerGraves", true).getBoolean(true);
        generateVillagerGraves = config.get("general", "GenerateVillagerGraves", true).getBoolean(true);
        generatePetGraves = config.get("general", "GeneratePetGraves", true).getBoolean(true);
        generateGravesInLava = config.get("general", "GenerateGravesInLava", true).getBoolean(true);
        generateSwordGraves = config.get("general", "GenerateSwordGraves", true).getBoolean(true);
        Property graveItemsCountProperty = config.get("general", "SavedItemsCount", 40);
        graveItemsCountProperty.comment = "This value must be between 0 an 40(in this case all items will be stored)!";
        graveItemsCount = graveItemsCountProperty.getInt();
        if (graveItemsCount > 40 || graveItemsCount < 0) {
            graveItemsCount = 40;
        }
        Property graveSpawnRateProperty = config.get("general", "SpawnRate", 1000);
        graveSpawnRateProperty.comment = "This value must be bigger than 600!";
        graveSpawnRate = graveSpawnRateProperty.getInt();
        if (graveSpawnRate < 600) {
            graveSpawnRate = 600;
        }
        spawnMobAtGraveDestruction = config.get("general", "SpawnMobAtGraveDestruction", true).getBoolean(true);
        spawnChance = config.get("general", "SpawnChance", 80).getInt();
        isFogEnabled = config.get("general", "IsFogEnabled", true).getBoolean(true);
        enableNightStone = config.get("general", "EnableNightStone", true).getBoolean(true);
        enableThunderStone = config.get("general", "EnableThunderStone", true).getBoolean(true);
        showNightStoneMessage = config.get("general", "ShowNightStoneMessage", true).getBoolean(true);
        cursePotionEffectId = config.get(CATEGORY_POTIONS, "CursePotionEffectId", 31).getInt();
        enableCreeperStatuesRecipes = config.get("general", "EnableCreeperStatuesRecipes", false).getBoolean(false);
        enableBossSpawnerCraftingRecipe = config.get("general", "EnableBossSpawnerCraftingRecipe", true).getBoolean(true);
        enableSpawnerCraftingRecipe = config.get("general", "EnableMonsterSpawnerCraftingRecipe", true).getBoolean(true);
        replaceHauntedChest = config.get("general", "ReplaceHauntedChest", false).getBoolean(false);
        removeEmptyGraves = config.get("general", "RemoveEmptyGraves", false).getBoolean(false);
        showGravesRemovingMessages = config.get("general", "ShowGravesRemovingMessages", true).getBoolean(true);
        Property restrictGraveGenerationInAreaProperty = config.get("general", "RestrictGraveGenerationInArea", "");
        restrictGraveGenerationInAreaProperty.comment = "List of coordinates in which graves generation must be disabled. \"start_x,start_y,start_z,end_x,end_y,end_z;\"";
        String ar = restrictGraveGenerationInAreaProperty.getString();
        String[] areas = ar.split(";");
        restrictGraveGenerationInArea = new ArrayList<GraveStoneHelper.RestrictedArea>(areas.length);
        for (String area : areas) {
            GraveStoneHelper.RestrictedArea restrictedArea = GraveStoneHelper.RestrictedArea.getFromString(area);
            if (restrictedArea == null) continue;
            restrictGraveGenerationInArea.add(restrictedArea);
        }
        craftableNightStone = config.get(CATEGORY_RECIPES, "CraftableNightStone", true).getBoolean(true);
        craftableThunderStone = config.get(CATEGORY_RECIPES, "CraftableThunderStone", true).getBoolean(true);
        hardAltarRecipe = config.get(CATEGORY_RECIPES, "HardAltarRecipe", false).getBoolean(false);
    }

    private static void entityConfig() {
        spawnZombieDogs = config.get("general", "SpawnZombieDogs", true).getBoolean(true);
        spawnZombieCats = config.get("general", "SpawnZombieCats", true).getBoolean(true);
        spawnSkeletonDogs = config.get("general", "SpawnSkeletonDogs", true).getBoolean(true);
        spawnSkeletonCats = config.get("general", "SpawnSkeletonCats", true).getBoolean(true);
        spawnSkullCrawlersAtMobsDeath = config.get("general", "SpawnSkullCrawlersAtMobsDeath", true).getBoolean(true);
        spawnSkullCrawlersAtBoneBlockDestruction = config.get("general", "SpawnSkullCrawlersOnBoneBlockDestruction", true).getBoolean(true);
    }

    private static void compatibilityConfigs() {
        spawnMoCreaturesMobs = config.get(CATEGORY_COMPATIBILITY, "SpawnMoCreaturesMobs", true).getBoolean(true);
        enableForestryBackpacks = config.get(CATEGORY_COMPATIBILITY, "EnableForestryBackpacks", true).getBoolean(true);
        storeBattlegearItems = config.get(CATEGORY_COMPATIBILITY, "StoreBattlegearItems", true).getBoolean(true);
        storeTheCampingModItems = config.get(CATEGORY_COMPATIBILITY, "StoreTheCampingModItems", true).getBoolean(true);
        storeBaublesItems = config.get(CATEGORY_COMPATIBILITY, "StoreBaublesItems", true).getBoolean(true);
        storeMaricultureItems = config.get(CATEGORY_COMPATIBILITY, "StoreMaricultureItems", true).getBoolean(true);
        storeTinkerConstructItems = config.get(CATEGORY_COMPATIBILITY, "StoreTinkerConstructItems", true).getBoolean(true);
        storeRpgInventoryItems = config.get(CATEGORY_COMPATIBILITY, "StoreRpgInventoryItems", true).getBoolean(true);
        storeGalacticraftItems = config.get(CATEGORY_COMPATIBILITY, "StoreGalacticraftItems", true).getBoolean(true);
        storeBackpacksItems = config.get(CATEGORY_COMPATIBILITY, "StoreBackpacksItems", true).getBoolean(true);
        enableArsMagicaSoulbound = config.get(CATEGORY_COMPATIBILITY, "EnableArsMagicaSoulbound", true).getBoolean(true);
        enableEnderIOSoulbound = config.get(CATEGORY_COMPATIBILITY, "EnableEnderIOSoulbound", true).getBoolean(true);
        enableTwilightForestKeeping = config.get(CATEGORY_COMPATIBILITY, "EnableTwilightForestCharmsOfKeeping", true).getBoolean(true);
        enableAntiqueAtlasDeathMarkers = config.get(CATEGORY_COMPATIBILITY, "EnableAntiqueAtlasDeathMarkers", true).getBoolean(true);
    }

    private void getGravesText() {
        graveNames = GraveStoneConfig.readStringsFromFile(path + "graveNames.txt", GravesDefaultText.NAMES);
        graveDogsNames = GraveStoneConfig.readStringsFromFile(path + "graveDogsNames.txt", GravesDefaultText.DOG_NAMES);
        graveCatsNames = GraveStoneConfig.readStringsFromFile(path + "graveCatsNames.txt", GravesDefaultText.CAT_NAMES);
        graveDeathMessages = GraveStoneConfig.readStringsFromFile(path + "graveDeathMessages.txt", GravesDefaultText.DEATH_TEXT);
        memorialText = GraveStoneConfig.readStringsFromFile(path + "memorialText.txt", GravesDefaultText.MEMORIAL_TEXT);
        dogsMemorialText = GraveStoneConfig.readStringsFromFile(path + "dogsMemorialText.txt", GravesDefaultText.DOGS_MEMORIAL_TEXT);
        catsMemorialText = GraveStoneConfig.readStringsFromFile(path + "catsMemorialText.txt", GravesDefaultText.CATS_MEMORIAL_TEXT);
    }

    private static ArrayList<String> readStringsFromFile(String fileName, String[] defaultValues) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(defaultValues));
        return list;
    }

    static {
        graveRenderID = RenderingRegistry.getNextAvailableRenderId();
        memorialRenderID = RenderingRegistry.getNextAvailableRenderId();
        spawnerRenderID = RenderingRegistry.getNextAvailableRenderId();
        skullCandleRenderID = RenderingRegistry.getNextAvailableRenderId();
        candleRenderID = RenderingRegistry.getNextAvailableRenderId();
        pileOfBonesRenderID = RenderingRegistry.getNextAvailableRenderId();
    }
}

