/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.CommonProxyCrackedZombie;
import com.crackedzombie.common.CrackedSpawnEgg;
import com.crackedzombie.common.EntityCrackedPigZombie;
import com.crackedzombie.common.EntityCrackedZombie;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="crackedzombiemod", name="Cracked Zombie Mod", version="1.7.10")
public class CrackedZombie {
    public static final String version = "1.7.10";
    public static final String modid = "crackedzombiemod";
    public static final String name = "Cracked Zombie Mod";
    public static final String zombieName = "CrackedZombie";
    public static final String pigzombieName = "CrackedPigZombie";
    private int entityID = 0;
    @Mod.Instance(value="crackedzombiemod")
    public static CrackedZombie instance;
    private int zombieSpawnProb;
    private int pigzombieSpawnProb;
    private boolean zombieSpawns;
    private boolean pigzombieSpawns;
    private boolean spawnCreepers;
    private boolean spawnSkeletons;
    private boolean spawnEnderman;
    private boolean spawnSpiders;
    private boolean spawnSlime;
    private boolean spawnWitches;
    private boolean doorBusting;
    private boolean allowChildSpawns;
    private boolean sickness;
    private int minSpawn;
    private int maxSpawn;
    private boolean pzSickness;
    private int minPZSpawn;
    private int maxPZSpawn;
    private double followRange;
    private double movementSpeed;
    private double attackDamage;
    private double pzMovementSpeed;
    private double pzAttackDamage;
    @SidedProxy(clientSide="com.crackedzombie.client.ClientProxyCrackedZombie", serverSide="com.crackedzombie.common.CommonProxyCrackedZombie")
    public static CommonProxyCrackedZombie proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String generalComments = "Cracked Zombie Mod Config\nMichael Sheppard (crackedEgg)\n For Minecraft Version 1.7.10\n";
        String spawnProbComment = "zombieSpawnProb adjust to probability of zombies spawning\nThe higher the number the more likely zombies will spawn.";
        String pzSpawnProbComment = "pigzombieSpawnProb adjust to probability of pigzombies spawning\nThe higher the number the more likely pigzombies will spawn.";
        String zombieComment = "zombieSpawns allows/disallows default zombies spawns, default is false,\nno default minecraft zombies will spawn. Only the CrackedZombies will spawn.\nIf set to true, fewer CrackedZombies will spawn.";
        String pigzombieComment = "pigzombieSpawns allows/disallows default pigzombies spawns, default is false,\nno default minecraft pigzombies will spawn. Only the CrackedPigZombies will spawn.\nIf set to true, fewer CrackedPigZombies will spawn.";
        String creeperComment = "creeperSpawns, set to false to disable creeper spawning, set to true\nif you want to spawn creepers";
        String skeletonComment = "skeletonSpawns, set to false to disable skeleton spawning, set to true\nif you want to spawn skeletons";
        String endermanComment = "endermanSpawns, set to false to disable enderman spawning, set to true\nif you want to spawn enderman";
        String spiderComment = "spiderSpawns, set to false to disable spider spawning, set to true\nif you want to spawn spiders";
        String slimeComment = "slimeSpawns, set to false to disable slime spawning, set to true\nif you want to spawn slimes";
        String witchComment = "witchSpawns, set to false to disable witch spawning, set to true\nif you want to spawn witches";
        String doorBustingComment = "doorBusting, set to true to have zombies try to break down doors,\notherwise set to false. It's quieter.";
        String sicknessComment = "Sickness, set to true to have contact with zombies poison the player.";
        String pzSicknessComment = "pzSickness, set to true to have contact with pigzombies poison the player.";
        String childComment = "allowChildSpawns, set to true to have child zombies, otherwise set to false.";
        String minSpawnComment = "minSpawn, minimum number of crackedzombies per spawn event";
        String maxSpawnComment = "maxSpawn, maximum number of crackedzombies per spawn event";
        String minPZSpawnComment = "minPZSpawn, minimum number of crackedpigzombies per spawn event";
        String maxPZSpawnComment = "maxPZSpawn, maximum number of crackedpigzombies per spawn event";
        String movementSpeedComment = "how fast zombies walk";
        String followRangeComment = "how far away zombies will follow you";
        String attackDamageComment = "how much damage a zombie will cause";
        String pzMoveSpeedComment = "how fast pigzombies walk";
        String pzAttackDamageComment = "how much damage a pigzombie will cause";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.zombieSpawnProb = config.get("general", "zombieSpawnProb", 15, spawnProbComment).getInt();
        this.pigzombieSpawnProb = config.get("general", "pigzombieSpawnProb", 15, pzSpawnProbComment).getInt();
        this.zombieSpawns = config.get("general", "zombieSpawns", false, zombieComment).getBoolean(false);
        this.pigzombieSpawns = config.get("general", "pigzombieSpawns", false, pigzombieComment).getBoolean(false);
        this.spawnCreepers = config.get("general", "spawnCreepers", false, creeperComment).getBoolean(false);
        this.spawnSkeletons = config.get("general", "spawnSkeletons", false, skeletonComment).getBoolean(false);
        this.spawnEnderman = config.get("general", "spawnEnderman", false, endermanComment).getBoolean(false);
        this.spawnSpiders = config.get("general", "spawnSpiders", true, spiderComment).getBoolean(true);
        this.spawnSlime = config.get("general", "spawnSlime", false, slimeComment).getBoolean(false);
        this.spawnWitches = config.get("general", "spawnWitches", true, witchComment).getBoolean(true);
        this.doorBusting = config.get("general", "doorBusting", false, doorBustingComment).getBoolean(false);
        this.sickness = config.get("general", "sickness", false, sicknessComment).getBoolean(false);
        this.minSpawn = config.get("general", "minSpawn", 2, minSpawnComment).getInt();
        this.maxSpawn = config.get("general", "maxSpawn", 10, maxSpawnComment).getInt();
        this.pzSickness = config.get("general", "pzSickness", false, pzSicknessComment).getBoolean(false);
        this.minPZSpawn = config.get("general", "minPZSpawn", 2, minPZSpawnComment).getInt();
        this.maxPZSpawn = config.get("general", "maxPZSpawn", 10, maxPZSpawnComment).getInt();
        this.allowChildSpawns = config.get("general", "allowChildSpawns", true, childComment).getBoolean(true);
        this.followRange = config.get("general", "followRange", 40.0, followRangeComment).getDouble();
        this.movementSpeed = config.get("general", "movementSpeed", 0.23, movementSpeedComment).getDouble();
        this.attackDamage = config.get("general", "attackDamage", 3.0, attackDamageComment).getDouble();
        this.pzMovementSpeed = config.get("general", "pzMovementSpeed", 0.23, pzMoveSpeedComment).getDouble();
        this.pzAttackDamage = config.get("general", "pzAttackDamage", 5.0, pzAttackDamageComment).getDouble();
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        this.registerEntity(EntityCrackedZombie.class, zombieName, 44975, 7969861);
        this.registerEntity(EntityCrackedPigZombie.class, pigzombieName, 44975, 13468991);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        DungeonHooks.addDungeonMob((String)zombieName, (int)200);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151040_l), 1, 1, 4));
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        proxy.print("*** Scanning for available biomes");
        BiomeGenBase[] allBiomes = (BiomeGenBase[])Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])BiomeGenBase.func_150565_n()), (Predicate)Predicates.notNull()), BiomeGenBase.class);
        this.printBiomeList(allBiomes);
        EntityRegistry.addSpawn(EntityCrackedZombie.class, (int)this.zombieSpawnProb, (int)this.minSpawn, (int)this.maxSpawn, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
        EntityRegistry.addSpawn(EntityCrackedPigZombie.class, (int)this.pigzombieSpawnProb, (int)this.minPZSpawn, (int)this.maxPZSpawn, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
        if (!this.zombieSpawns) {
            proxy.print("*** Disabling default zombie spawns for all biomes");
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Zombie");
        } else {
            proxy.print("NOT disabling default zombie spawns, there will be fewer crackedZombies!");
        }
        if (!this.pigzombieSpawns) {
            proxy.print("*** Disabling default pigzombie spawns for all biomes");
            EntityRegistry.removeSpawn(EntityPigZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
        } else {
            proxy.print("NOT disabling default pigzombie spawns, there will be fewer crackedPigZombies!");
        }
        if (!this.spawnCreepers) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing creeper spawns");
        }
        if (!this.spawnSkeletons) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Skeleton");
            proxy.print("*** Removing skeleton spawns and dungeon spawners");
        }
        if (!this.spawnEnderman) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing enderman spawns");
        }
        if (!this.spawnSpiders) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Spider");
            proxy.print("*** Removing spider spawns and dungeon spawners");
        }
        if (!this.spawnSlime) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing slime spawns");
        }
        if (!this.spawnWitches) {
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing witch spawns");
        }
    }

    public void registerEntity(Class<? extends Entity> entityClass, String entityName, int bkEggColor, int fgEggColor) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)this.entityID++, (Object)this, (int)80, (int)3, (boolean)true);
        CrackedSpawnEgg spawnEgg = new CrackedSpawnEgg(entityName, bkEggColor, fgEggColor);
        spawnEgg.func_77655_b("spawn_egg_" + entityName.toLowerCase());
        spawnEgg.func_111206_d("crackedzombiemod:spawn_egg");
        GameRegistry.registerItem((Item)spawnEgg, (String)("spawnEgg" + entityName));
    }

    public void printBiomeList(BiomeGenBase[] biomes) {
        for (BiomeGenBase bgb : biomes) {
            proxy.print("  >>> Including biome " + bgb.field_76791_y + " for spawning");
        }
    }

    public boolean getDoorBusting() {
        return this.doorBusting;
    }

    public boolean getSickness() {
        return this.sickness;
    }

    public boolean getPZSickness() {
        return this.pzSickness;
    }

    public boolean getAllowChildSpawns() {
        return this.allowChildSpawns;
    }

    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public double getPZMoveSpeed() {
        return this.pzMovementSpeed;
    }

    public double getPZAttackDamage() {
        return this.pzAttackDamage;
    }
}

