/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.api.lists.ListRegistry;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class ListHandlerNew {
    public static final int WIDTH = 9;
    public static final int HEIGHT = 2;

    private ListHandlerNew() {
    }

    public static Line[] getLines(ItemStack item) {
        NBTTagCompound data = NBTUtils.getItemData(item);
        if (data.func_74764_b("written") && data.func_74764_b("lines")) {
            NBTTagList list = data.func_150295_c("lines", 10);
            Line[] lines = new Line[list.func_74745_c()];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = Line.fromNBT(list.func_150305_b(i));
            }
            return lines;
        }
        Line[] lines = new Line[2];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = new Line();
        }
        return lines;
    }

    public static void saveLines(ItemStack stackList, Line[] lines) {
        NBTTagCompound data = NBTUtils.getItemData(stackList);
        data.func_74757_a("written", true);
        NBTTagList lineList = new NBTTagList();
        for (Line l : lines) {
            lineList.func_74742_a((NBTBase)l.toNBT());
        }
        data.func_74782_a("lines", (NBTBase)lineList);
    }

    public static boolean matches(ItemStack stackList, ItemStack item) {
        NBTTagCompound data = NBTUtils.getItemData(stackList);
        if (data.func_74764_b("written") && data.func_74764_b("lines")) {
            NBTTagList list = data.func_150295_c("lines", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Line line = Line.fromNBT(list.func_150305_b(i));
                if (!line.matches(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Line {
        public final ItemStack[] stacks = new ItemStack[9];
        public boolean precise;
        public boolean byType;
        public boolean byMaterial;

        public boolean isOneStackMode() {
            return this.byType || this.byMaterial;
        }

        public boolean getOption(int id) {
            return id == 0 ? this.precise : (id == 1 ? this.byType : this.byMaterial);
        }

        public void toggleOption(int id) {
            if (!(this.byType || this.byMaterial || id != 1 && id != 2)) {
                for (int i = 1; i < this.stacks.length; ++i) {
                    this.stacks[i] = null;
                }
            }
            switch (id) {
                case 0: {
                    this.precise = !this.precise;
                    break;
                }
                case 1: {
                    this.byType = !this.byType;
                    break;
                }
                case 2: {
                    this.byMaterial = !this.byMaterial;
                }
            }
        }

        public boolean matches(ItemStack target) {
            if (this.byType || this.byMaterial) {
                if (this.stacks[0] == null) {
                    return false;
                }
                List handlers = ListRegistry.getHandlers();
                ListMatchHandler.Type type = this.getSortingType();
                for (ListMatchHandler h : handlers) {
                    if (!h.matches(type, this.stacks[0], target, this.precise)) continue;
                    return true;
                }
            } else {
                for (ItemStack s : this.stacks) {
                    if (s == null || !StackHelper.isMatchingItem(s, target, true, this.precise) || this.precise && s.func_77960_j() != target.func_77960_j()) continue;
                    return true;
                }
            }
            return false;
        }

        public ListMatchHandler.Type getSortingType() {
            return this.byType ? (this.byMaterial ? ListMatchHandler.Type.CLASS : ListMatchHandler.Type.TYPE) : ListMatchHandler.Type.MATERIAL;
        }

        public static Line fromNBT(NBTTagCompound data) {
            Line line = new Line();
            if (data != null && data.func_74764_b("st")) {
                NBTTagList l = data.func_150295_c("st", 10);
                for (int i = 0; i < l.func_74745_c(); ++i) {
                    line.stacks[i] = ItemStack.func_77949_a((NBTTagCompound)l.func_150305_b(i));
                }
                line.precise = data.func_74767_n("Fp");
                line.byType = data.func_74767_n("Ft");
                line.byMaterial = data.func_74767_n("Fm");
            }
            return line;
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound data = new NBTTagCompound();
            NBTTagList stackList = new NBTTagList();
            for (ItemStack stack1 : this.stacks) {
                NBTTagCompound stack = new NBTTagCompound();
                if (stack1 != null) {
                    stack1.func_77955_b(stack);
                }
                stackList.func_74742_a((NBTBase)stack);
            }
            data.func_74782_a("st", (NBTBase)stackList);
            data.func_74757_a("Fp", this.precise);
            data.func_74757_a("Ft", this.byType);
            data.func_74757_a("Fm", this.byMaterial);
            return data;
        }

        public void setStack(int slotIndex, ItemStack stack) {
            if (slotIndex == 0 || !this.byType && !this.byMaterial) {
                if (stack != null && stack.func_77973_b() != null) {
                    this.stacks[slotIndex] = stack.func_77946_l();
                    this.stacks[slotIndex].field_77994_a = 1;
                } else {
                    this.stacks[slotIndex] = null;
                }
            }
        }

        public ItemStack getStack(int i) {
            return i >= 0 && i < this.stacks.length ? this.stacks[i] : null;
        }

        public List<ItemStack> getExamples() {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            if (this.stacks[0] != null) {
                List handlers = ListRegistry.getHandlers();
                ArrayList<ListMatchHandler> handlersCustom = new ArrayList<ListMatchHandler>();
                ListMatchHandler.Type type = this.getSortingType();
                for (ListMatchHandler h : handlers) {
                    if (!h.isValidSource(type, this.stacks[0])) continue;
                    List<ItemStack> examples = h.getClientExamples(type, this.stacks[0]);
                    if (examples != null) {
                        stackList.addAll(examples);
                        continue;
                    }
                    handlersCustom.add(h);
                }
                if (handlersCustom.size() > 0) {
                    for (Object o : Item.field_150901_e) {
                        if (o == null || !(o instanceof Item)) continue;
                        Item i = (Item)o;
                        ArrayList examples = new ArrayList();
                        i.func_150895_a(i, CreativeTabs.field_78026_f, examples);
                        block2: for (ItemStack s : examples) {
                            for (ListMatchHandler mh : handlersCustom) {
                                if (!mh.matches(type, this.stacks[0], s, false)) continue;
                                stackList.add(s);
                                continue block2;
                            }
                        }
                    }
                }
                Collections.shuffle(stackList);
            }
            return stackList;
        }
    }
}

