/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.BCRegistry;
import buildcraft.core.lib.engines.BlockEngineBase;
import buildcraft.core.lib.engines.TileEngineBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockEngine
extends BlockEngineBase {
    private final Class[] engineTiles;
    private final String[] names;
    private final String[] texturePaths;

    public BlockEngine() {
        this.func_149663_c("engineBlock");
        this.engineTiles = new Class[16];
        this.names = new String[16];
        this.texturePaths = new String[16];
    }

    @Override
    public String getTexturePrefix(int meta, boolean addPrefix) {
        if (this.texturePaths[meta] != null) {
            if (addPrefix) {
                return this.texturePaths[meta].replaceAll(":", ":textures/blocks/");
            }
            return this.texturePaths[meta];
        }
        return null;
    }

    @Override
    public String getUnlocalizedName(int metadata) {
        return this.names[metadata] != null ? this.names[metadata] : "unknown";
    }

    public void registerTile(Class<? extends TileEngineBase> engineTile, int meta, String name, String texturePath) {
        if (BCRegistry.INSTANCE.isEnabled("engines", name)) {
            this.engineTiles[meta] = engineTile;
            this.names[meta] = name;
            this.texturePaths[meta] = texturePath;
        }
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        try {
            return (TileEntity)this.engineTiles[metadata].newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < 16; ++i) {
            if (this.engineTiles[i] == null) continue;
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public boolean hasEngine(int meta) {
        return this.engineTiles[meta] != null;
    }
}

