/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.network;

import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VectorOffset;
import com.cout970.magneticraft.util.network.NetworkNode;
import com.cout970.magneticraft.util.network.NetworkPathFinder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BasicNetwork {
    protected List<NetworkNode> nodes = new LinkedList<NetworkNode>();
    protected NetworkNode start;

    public BasicNetwork(NetworkNode startPoint) {
        this.nodes.add(startPoint);
        this.start = startPoint;
    }

    public NetworkNode getStart() {
        return this.start;
    }

    public boolean canAddToNetwork(NetworkNode node) {
        return this.start.canAddToNetwork(node);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public NetworkNode[] getNodes() {
        return this.nodes.toArray(new NetworkNode[this.nodes.size()]);
    }

    public void addNode(NetworkNode node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
            node.setNetwork(this);
            this.onNetworkChange();
        }
        node.setNetwork(this);
    }

    public void removeNode(NetworkNode node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
            this.refresh();
        }
    }

    public void refresh() {
        NetworkNode startingPoint = null;
        for (NetworkNode node : this.nodes) {
            if (!node.isValid()) continue;
            startingPoint = node;
            break;
        }
        if (startingPoint == null) {
            this.destroyNetwork();
            return;
        }
        NetworkPathFinder pathfinder = new NetworkPathFinder(startingPoint);
        pathfinder.init();
        pathfinder.addBlock(new VectorOffset(new VecInt(startingPoint.getParent()), VecInt.NULL_VECTOR));
        pathfinder.addNeigBlocks(new VecInt(startingPoint.getParent()));
        while (pathfinder.iterate()) {
        }
        this.nodes.stream().filter(nd -> !pathfinder.nodes.contains(nd)).forEach(nd -> nd.setNetwork(null));
        this.nodes.clear();
        pathfinder.nodes.forEach(this::addNode);
        this.onNetworkChange();
    }

    protected void onNetworkChange() {
    }

    public void mergeWith(BasicNetwork net) {
        this.nodes.forEach(net::addNode);
        this.nodes.clear();
        net.onNetworkChange();
    }

    public void destroyNetwork() {
        Iterator<NetworkNode> it = this.nodes.iterator();
        while (it.hasNext()) {
            it.next().setNetwork(null);
            it.remove();
        }
    }
}

