/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.fluid;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TankMg
extends FluidTank {
    private boolean allowInput = true;
    private boolean allowOutput = true;

    public TankMg(TileEntity t, int capacity) {
        super(null, capacity);
        this.tile = t;
    }

    public void readFromNBT(NBTTagCompound main, String string) {
        NBTTagCompound nbt = (NBTTagCompound)main.func_74781_a(string);
        this.readFromNBT(nbt);
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("inputAllowed")) {
            this.allowInput = nbt.func_74767_n("inputAllowed");
        }
        if (nbt.func_74764_b("outputAllowed")) {
            this.allowOutput = nbt.func_74767_n("outputAllowed");
        }
        return super.readFromNBT(nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("inputAllowed", this.allowInput);
        nbt.func_74757_a("outputAllowed", this.allowOutput);
        return super.writeToNBT(nbt);
    }

    public void writeToNBT(NBTTagCompound main, String string) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        main.func_74782_a(string, (NBTBase)nbt);
    }

    public int getSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public TileEntity getParent() {
        return this.tile;
    }

    public boolean isInputAllowed() {
        return this.allowInput;
    }

    public void setAllowInput(boolean allowInput) {
        this.allowInput = allowInput;
    }

    public boolean isOutputAllowed() {
        return this.allowOutput;
    }

    public void setAllowOutput(boolean allowOutput) {
        this.allowOutput = allowOutput;
    }

    public int fill(FluidStack resource, boolean doFill, boolean respectMode) {
        if (respectMode && !this.isInputAllowed()) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill, true);
    }

    public FluidStack drain(int maxDrain, boolean doDrain, boolean respectMode) {
        if (respectMode && !this.isOutputAllowed()) {
            return null;
        }
        return super.drain(maxDrain, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain, true);
    }

    public void setAllowInOut(boolean allowInOut) {
        this.setAllowInput(allowInOut);
        this.setAllowOutput(allowInOut);
    }
}

