/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util;

import codechicken.lib.vec.Vector3;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.multiblock.MB_Tile;
import com.cout970.magneticraft.util.multiblock.Mg_Component;
import com.cout970.magneticraft.util.multiblock.Multiblock;
import com.cout970.magneticraft.util.multiblock.ReplaceComponent;
import com.cout970.magneticraft.util.multiblock.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static double zLevel;
    public static ResourceLocation MISC_ICONS;

    public static void drawTexturedModalRectScaled(int x, int y, int u, int v, int w, int h, int mx, int my) {
        float f = 1.0f / (float)mx;
        float f1 = 1.0f / (float)my;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + h), zLevel, (double)((float)u * f), (double)((float)(v + h) * f1));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), zLevel, (double)((float)(u + w) * f), (double)((float)(v + h) * f1));
        tessellator.func_78374_a((double)(x + w), (double)y, zLevel, (double)((float)(u + w) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }

    public static void bindTexture(ResourceLocation r) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(r);
    }

    public static int getTexture(boolean[] b) {
        int count = 0;
        for (boolean c : b) {
            if (!c) continue;
            ++count;
        }
        if (count != 1) {
            return -1;
        }
        if (b.length == 6) {
            return b[0] ? 0 : (b[1] ? 1 : (b[2] ? 5 : (b[3] ? 3 : (b[4] ? 4 : (b[5] ? 2 : -1)))));
        }
        return b[0] ? 4 : (b[1] ? 2 : (b[2] ? 1 : (b[3] ? 3 : -1)));
    }

    public static int fromRGB(int r, int g, int b) {
        int color = 0;
        color += r * 65536;
        color += g * 256;
        return color += b;
    }

    public static void drawString(String string, int x, int y, int par4, boolean centered) {
        FontRenderer f = Minecraft.func_71410_x().field_71466_p;
        if (centered) {
            f.func_78276_b(string, x - f.func_78256_a(string) / 2, y - f.func_78256_a("1") / 2, par4);
        } else {
            f.func_78276_b(string, x, y, par4);
        }
    }

    public static int getTexture(byte b) {
        int count = 0;
        for (int c = 0; c < 6; c = (int)((byte)(c + 1))) {
            if ((b & 1 << c) <= 0) continue;
            count = (byte)(count + 1);
        }
        if (count != 1) {
            return -1;
        }
        if ((b & 1) > 0) {
            return 0;
        }
        if ((b & 2) > 0) {
            return 1;
        }
        if ((b & 4) > 0) {
            return 5;
        }
        if ((b & 8) > 0) {
            return 3;
        }
        if ((b & 0x10) > 0) {
            return 4;
        }
        if ((b & 0x20) > 0) {
            return 2;
        }
        return -1;
    }

    public static Vector3 getHeatColor(double t) {
        double r = Math.min(0.95, t / 1000.0);
        return new Vector3(1.0, 1.0 - r, 1.0 - r);
    }

    public static void renderBlock(Block b, int meta, int x, int y, int z, World w) {
        RenderUtil.renderFaceDown(b.func_149691_a(0, meta), x, y, z);
        RenderUtil.renderFaceUp(b.func_149691_a(1, meta), x, y, z);
        RenderUtil.renderFaceNorth(b.func_149691_a(2, meta), x, y, z);
        RenderUtil.renderFaceSouth(b.func_149691_a(3, meta), x, y, z);
        RenderUtil.renderFaceWest(b.func_149691_a(4, meta), x, y, z);
        RenderUtil.renderFaceEast(b.func_149691_a(5, meta), x, y, z);
    }

    public static void renderFaceUp(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)(y + 1), (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)i.func_94214_a(16.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceDown(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)(x + 1), (double)y, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)x, (double)y, (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)x, (double)y, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceNorth(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)y, (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)x, (double)(y + 1), (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)x, (double)y, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceSouth(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)i.func_94214_a(16.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)z, (double)i.func_94214_a(16.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceWest(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)y, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)x, (double)(y + 1), (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)(y + 1), (double)z, (double)i.func_94214_a(16.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)z, (double)i.func_94214_a(16.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceEast(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)y, (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)x, (double)(y + 1), (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(16.0));
    }

    public static void renderMultiblock(double x, double y, double z, MB_Tile tile, TileEntity t, Multiblock mb) {
        Tessellator tess = Tessellator.field_78398_a;
        RenderUtil.bindTexture(TextureMap.field_110575_b);
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)65536.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float s = 0.5f;
        float p = 1.0f;
        GL11.glScalef((float)s, (float)s, (float)s);
        int[] q = mb.getDimensions(tile.getDirection());
        int meta = t.func_145831_w().func_72805_g(t.field_145851_c, t.field_145848_d, t.field_145849_e);
        for (int j = 0; j < q[1]; ++j) {
            for (int k = 0; k < q[2]; ++k) {
                for (int i = 0; i < q[0]; ++i) {
                    Mg_Component comp;
                    Mg_Component mut = mb.matrix[i][j][k];
                    VecInt rot = mb.translate(t.func_145831_w(), new VecInt(t.field_145851_c, t.field_145848_d, t.field_145849_e), i, j, k, mb, tile.getDirection(), meta);
                    if (mut instanceof SimpleComponent) {
                        comp = (SimpleComponent)mut;
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)(0.5f + p * (float)rot.getX()), (float)(0.5f + p * (float)rot.getY()), (float)(0.5f + p * (float)rot.getZ()));
                        if (comp.blocks.get(0) != Blocks.field_150350_a) {
                            tess.func_78382_b();
                            RenderUtil.renderBlock(comp.blocks.get(0), 0, rot.getX(), rot.getY(), rot.getZ(), t.func_145831_w());
                            tess.func_78381_a();
                        }
                        GL11.glPopMatrix();
                        continue;
                    }
                    if (!(mut instanceof ReplaceComponent)) continue;
                    comp = (ReplaceComponent)mut;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(0.5f + p * (float)rot.getX()), (float)(0.5f + p * (float)rot.getY()), (float)(0.5f + p * (float)rot.getZ()));
                    if (((ReplaceComponent)comp).origin != Blocks.field_150350_a) {
                        tess.func_78382_b();
                        if (((ReplaceComponent)comp).origin instanceof BlockSlab) {
                            RenderUtil.renderSlab(((ReplaceComponent)comp).origin, 0, rot.getX(), rot.getY(), rot.getZ(), t.func_145831_w());
                        } else {
                            RenderUtil.renderBlock(((ReplaceComponent)comp).origin, 0, rot.getX(), rot.getY(), rot.getZ(), t.func_145831_w());
                        }
                        tess.func_78381_a();
                    }
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private static void renderSlab(Block b, int meta, int x, int y, int z, World worldObj) {
        RenderUtil.renderFaceDown(b.func_149691_a(0, meta), x, y, z);
        RenderUtil.renderFaceUp_Slab(b.func_149691_a(0, meta), x, y, z);
        RenderUtil.renderFaceNorth_Slab(b.func_149691_a(2, meta), x, y, z);
        RenderUtil.renderFaceSouth_Slab(b.func_149691_a(3, meta), x, y, z);
        RenderUtil.renderFaceWest_Slab(b.func_149691_a(4, meta), x, y, z);
        RenderUtil.renderFaceEast_Slab(b.func_149691_a(5, meta), x, y, z);
    }

    private static void renderFaceUp_Slab(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)y + 0.5, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)x, (double)y + 0.5, (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)y + 0.5, (double)(z + 1), (double)i.func_94214_a(16.0), (double)i.func_94207_b(16.0));
        t.func_78374_a((double)(x + 1), (double)y + 0.5, (double)z, (double)i.func_94214_a(16.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceNorth_Slab(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)y, (double)(z + 1), (double)i.func_94214_a(8.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)x, (double)y + 0.5, (double)(z + 1), (double)i.func_94214_a(8.0), (double)i.func_94207_b(8.0));
        t.func_78374_a((double)x, (double)y + 0.5, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(8.0));
        t.func_78374_a((double)x, (double)y, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceSouth_Slab(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)(x + 1), (double)y + 0.5, (double)z, (double)i.func_94214_a(8.0), (double)i.func_94207_b(8.0));
        t.func_78374_a((double)(x + 1), (double)y + 0.5, (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(8.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)z, (double)i.func_94214_a(8.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceWest_Slab(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)y, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)x, (double)y + 0.5, (double)z, (double)i.func_94214_a(0.0), (double)i.func_94207_b(8.0));
        t.func_78374_a((double)(x + 1), (double)y + 0.5, (double)z, (double)i.func_94214_a(8.0), (double)i.func_94207_b(8.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)z, (double)i.func_94214_a(8.0), (double)i.func_94207_b(0.0));
    }

    public static void renderFaceEast_Slab(IIcon i, int x, int y, int z) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78374_a((double)x, (double)y, (double)(z + 1), (double)i.func_94214_a(8.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(0.0));
        t.func_78374_a((double)(x + 1), (double)y + 0.5, (double)(z + 1), (double)i.func_94214_a(0.0), (double)i.func_94207_b(8.0));
        t.func_78374_a((double)x, (double)y + 0.5, (double)(z + 1), (double)i.func_94214_a(8.0), (double)i.func_94207_b(8.0));
    }

    public static double interpolate(double fa, double fb, double fc, double x) {
        double a = 0.0;
        double b = 0.5;
        double c = 1.0;
        double L0 = (x - b) / (a - b) * ((x - c) / (a - c));
        double L1 = (x - a) / (b - a) * ((x - c) / (b - c));
        double L2 = (x - a) / (c - a) * ((x - b) / (c - b));
        return fa * L0 + fb * L1 + fc * L2;
    }

    public static void drawLine(VecDouble a, VecDouble b, float f) {
        Tessellator t = Tessellator.field_78398_a;
        float w = f / 2.0f;
        t.func_78377_a(a.getX(), a.getY() - (double)w, a.getZ());
        t.func_78377_a(a.getX(), a.getY() + (double)w, a.getZ());
        t.func_78377_a(b.getX(), b.getY() + (double)w, b.getZ());
        t.func_78377_a(b.getX(), b.getY() - (double)w, b.getZ());
        t.func_78377_a(a.getX(), a.getY(), a.getZ() - (double)w);
        t.func_78377_a(a.getX(), a.getY(), a.getZ() + (double)w);
        t.func_78377_a(b.getX(), b.getY(), b.getZ() + (double)w);
        t.func_78377_a(b.getX(), b.getY(), b.getZ() - (double)w);
        t.func_78377_a(a.getX() - (double)w, a.getY(), a.getZ());
        t.func_78377_a(a.getX() + (double)w, a.getY(), a.getZ());
        t.func_78377_a(b.getX() + (double)w, b.getY(), b.getZ());
        t.func_78377_a(b.getX() - (double)w, b.getY(), b.getZ());
        t.func_78377_a(a.getX(), a.getY() + (double)w, a.getZ());
        t.func_78377_a(a.getX(), a.getY() - (double)w, a.getZ());
        t.func_78377_a(b.getX(), b.getY() - (double)w, b.getZ());
        t.func_78377_a(b.getX(), b.getY() + (double)w, b.getZ());
        t.func_78377_a(a.getX(), a.getY(), a.getZ() + (double)w);
        t.func_78377_a(a.getX(), a.getY(), a.getZ() - (double)w);
        t.func_78377_a(b.getX(), b.getY(), b.getZ() - (double)w);
        t.func_78377_a(b.getX(), b.getY(), b.getZ() + (double)w);
        t.func_78377_a(a.getX() + (double)w, a.getY(), a.getZ());
        t.func_78377_a(a.getX() - (double)w, a.getY(), a.getZ());
        t.func_78377_a(b.getX() - (double)w, b.getY(), b.getZ());
        t.func_78377_a(b.getX() + (double)w, b.getY(), b.getZ());
    }

    static {
        MISC_ICONS = new ResourceLocation("Magneticraft".toLowerCase(), "textures/gui/misc.png");
    }
}

