/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.conveyor.IConveyorBelt;
import com.cout970.magneticraft.api.conveyor.IConveyorBeltLane;
import com.cout970.magneticraft.api.conveyor.IItemBox;
import com.cout970.magneticraft.api.conveyor.prefab.ItemBox;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.MgBeltUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;

public class TileInserter
extends TileBase
implements IGuiListener {
    public InventoryComponent inv = new InventoryComponent(this, 1, "Inserter");
    public InventoryComponent filter = new InventoryComponent(this, 9, "Filter");
    public InventoryComponent upgrades = new InventoryComponent(this, 4, "Upgrades"){

        @Override
        public int func_70297_j_() {
            return 1;
        }
    };
    public boolean whiteList;
    public boolean ignoreNBT;
    public boolean ignoreMeta;
    public boolean ignoreDict;
    public int counter = 0;
    public InserterAnimation anim = null;
    private int cooldown;

    public MgDirection getDir() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    @Override
    public void onBlockBreaks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockMg.dropItem(this.getInv().func_70301_a(0), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            BlockMg.dropItem(this.upgrades.func_70301_a(i), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.counter >= 180) {
                if (this.anim != InserterAnimation.SUCK_ITEM && this.anim != InserterAnimation.SUCK_ITEM_LARGE && this.anim != InserterAnimation.DROP_ITEM && this.anim != InserterAnimation.DROP_ITEM_LARGE) {
                    this.anim = this.getNextAnimation();
                    this.counter = 0;
                }
            } else {
                this.counter += this.getSpeed();
            }
            return;
        }
        if (this.anim == null) {
            this.anim = InserterAnimation.EXTENDING_SHORT;
            this.counter = 0;
            return;
        }
        if (this.getInv().func_70301_a(0) != null && this.getInv().func_70301_a((int)0).field_77994_a == 0) {
            this.getInv().func_70299_a(0, null);
            this.anim = InserterAnimation.EXTENDING_SHORT;
            this.counter = 0;
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.anim == InserterAnimation.DROP_ITEM || this.anim == InserterAnimation.DROP_ITEM_LARGE) {
            if (this.getInv().func_70301_a(0) != null) {
                TileEntity o = MgUtils.getTileEntity((TileEntity)this, this.getDir().opposite());
                if (o instanceof IInventory) {
                    this.dropToInv((IInventory)o);
                } else if (o instanceof IConveyorBelt && ((IConveyorBelt)o).getOrientation().getLevel() == 0) {
                    this.dropToBelt((IConveyorBelt)o);
                } else if (this.canDropItems() && this.cooldown == 0) {
                    this.dropItem();
                    this.cooldown = 10;
                }
            }
            if (this.getInv().func_70301_a(0) == null) {
                this.anim = this.anim == InserterAnimation.DROP_ITEM ? InserterAnimation.RETRACTING_INV_SHORT : InserterAnimation.RETRACTING_INV_LARGE;
                this.counter = 0;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.anim == InserterAnimation.SUCK_ITEM || this.anim == InserterAnimation.SUCK_ITEM_LARGE) {
            if (this.isControlled()) {
                if (this.getInv().func_70301_a(0) == null) {
                    TileEntity t = MgUtils.getTileEntity((TileEntity)this, this.getDir());
                    TileEntity o = MgUtils.getTileEntity((TileEntity)this, this.getDir().opposite());
                    if (t instanceof IInventory) {
                        this.suckFromInv((IInventory)t, o);
                    }
                    if (this.getInv().func_70301_a(0) == null && t instanceof IConveyorBelt && ((IConveyorBelt)t).getOrientation().getLevel() == 0) {
                        this.suckFromBelt((IConveyorBelt)t, o);
                    }
                    if (this.getInv().func_70301_a(0) == null && this.canSuckDroppedItems() && this.cooldown == 0) {
                        this.suckFromGround();
                        this.cooldown = 10;
                    }
                }
                if (this.getInv().func_70301_a(0) != null) {
                    this.anim = this.anim == InserterAnimation.SUCK_ITEM ? InserterAnimation.RETRACTING_SHORT : InserterAnimation.RETRACTING_LARGE;
                    this.counter = 0;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        } else if (this.counter >= 180) {
            this.anim = this.getNextAnimation();
            this.counter = 0;
        } else {
            this.counter += this.getSpeed();
        }
    }

    private InserterAnimation getNextAnimation() {
        if (this.anim == InserterAnimation.RETRACTING_SHORT || this.anim == InserterAnimation.RETRACTING_LARGE) {
            return InserterAnimation.ROTATING;
        }
        if (this.anim == InserterAnimation.RETRACTING_INV_SHORT || this.anim == InserterAnimation.RETRACTING_INV_LARGE) {
            return InserterAnimation.ROTATING_INV;
        }
        if (this.anim == InserterAnimation.ROTATING) {
            TileEntity o = MgUtils.getTileEntity((TileEntity)this, this.getDir().opposite());
            if (o instanceof IConveyorBelt && ((IConveyorBelt)o).getOrientation().getLevel() == 0 && ((IConveyorBelt)o).getDir().isPerpendicular(this.getDir())) {
                return InserterAnimation.EXTENDING_INV_LARGE;
            }
            return InserterAnimation.EXTENDING_INV_SHORT;
        }
        if (this.anim == InserterAnimation.ROTATING_INV) {
            return InserterAnimation.EXTENDING_SHORT;
        }
        if (this.anim == InserterAnimation.EXTENDING_INV_SHORT) {
            return InserterAnimation.DROP_ITEM;
        }
        if (this.anim == InserterAnimation.EXTENDING_INV_LARGE) {
            return InserterAnimation.DROP_ITEM_LARGE;
        }
        if (this.anim == InserterAnimation.EXTENDING_SHORT) {
            return InserterAnimation.SUCK_ITEM;
        }
        if (this.anim == InserterAnimation.EXTENDING_LARGE) {
            return InserterAnimation.SUCK_ITEM_LARGE;
        }
        return this.anim;
    }

    private void suckFromGround() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        VecInt vec1 = new VecInt(this).add(this.getDir().toVecInt());
        List l = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)vec1.getX(), (double)vec1.getY(), (double)vec1.getZ(), (double)(vec1.getX() + 1), (double)(vec1.getY() + 1), (double)(vec1.getZ() + 1)));
        for (Object aL : l) {
            EntityItem entity;
            if (!(aL instanceof EntityItem) || (entity = (EntityItem)aL).func_92059_d() == null) continue;
            this.getInv().func_70299_a(0, entity.func_92059_d());
            entity.func_70106_y();
            break;
        }
    }

    private void dropItem() {
        List l;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        VecInt vec1 = new VecInt(this).add(this.getDir().opposite().toVecInt());
        Block b = this.field_145850_b.func_147439_a(vec1.getX(), vec1.getY(), vec1.getZ());
        if (b.isAir((IBlockAccess)this.field_145850_b, vec1.getX(), vec1.getY(), vec1.getZ()) && (l = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)vec1.getX(), (double)vec1.getY(), (double)vec1.getZ(), (double)(vec1.getX() + 1), (double)(vec1.getY() + 1), (double)(vec1.getZ() + 1)))).isEmpty()) {
            ItemStack item = this.getInv().func_70301_a(0);
            if (item == null) {
                return;
            }
            VecDouble vec2 = new VecDouble(vec1);
            vec2.add(0.5, 0.5, 0.5);
            EntityItem entityItem = new EntityItem(this.field_145850_b, vec2.getX(), vec2.getY(), vec2.getZ(), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)entityItem);
            this.getInv().func_70299_a(0, null);
        }
    }

    private boolean canDropItems() {
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            ItemStack item = this.upgrades.func_70301_a(i);
            if (item == null || item.func_77973_b() != ManagerItems.upgrade_drop) continue;
            return true;
        }
        return false;
    }

    public int getSpeed() {
        int speed = 20;
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            ItemStack item = this.upgrades.func_70301_a(i);
            if (item == null) continue;
            if (item.func_77973_b() == ManagerItems.upgrade_speed) {
                speed += 10;
                continue;
            }
            if (item.func_77973_b() != ManagerItems.upgrade_slow) continue;
            speed -= 10;
        }
        return Math.min(40, Math.max(10, speed));
    }

    private boolean canSuckDroppedItems() {
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            ItemStack item = this.upgrades.func_70301_a(i);
            if (item == null || item.func_77973_b() != ManagerItems.upgrade_suck) continue;
            return true;
        }
        return false;
    }

    private void dropToBelt(IConveyorBelt t) {
        ItemStack s = this.getInv().func_70301_a(0);
        if (t.addItem(this.getDir(), 2, new ItemBox(s), true)) {
            this.getInv().func_70299_a(0, null);
            t.addItem(this.getDir(), 2, new ItemBox(s), false);
            t.onChange();
        }
    }

    private void dropToInv(IInventory t) {
        ItemStack s = this.getInv().func_70301_a(0);
        s.field_77994_a = MgBeltUtils.dropItemStackIntoInventory(t, s, this.getDir(), false);
        if (s.field_77994_a == 0) {
            s = null;
        }
        this.getInv().func_70299_a(0, s);
    }

    private void suckFromBelt(IConveyorBelt t, Object obj) {
        IConveyorBeltLane side = t.getSideLane(true);
        if (this.extractFromBelt(side, t, true, obj)) {
            return;
        }
        side = t.getSideLane(false);
        this.extractFromBelt(side, t, false, obj);
    }

    public boolean extractFromBelt(IConveyorBeltLane side, IConveyorBelt t, boolean left, Object obj) {
        ItemStack x;
        if (side.getItemBoxes().isEmpty()) {
            return false;
        }
        IItemBox b = side.getItemBoxes().get(0);
        if (t.removeItem(b, left, true) && this.canInject(obj, x = b.getContent()) && this.canExtract(x)) {
            this.getInv().func_70299_a(0, b.getContent());
            t.removeItem(b, left, false);
            t.onChange();
            MgUtils.getNeig(t.getParent()).stream().filter(tile -> tile instanceof IConveyorBelt).forEach(tile -> ((IConveyorBelt)tile).onChange());
            return true;
        }
        return false;
    }

    private void suckFromInv(IInventory t, Object obj) {
        block3: {
            block2: {
                if (!(t instanceof ISidedInventory)) break block2;
                ISidedInventory ts = (ISidedInventory)t;
                MgDirection d = this.getDir().opposite();
                if (ts.func_94128_d(d.ordinal()) == null) break block3;
                for (int i : ts.func_94128_d(d.ordinal())) {
                    ItemStack s = t.func_70301_a(i);
                    if (s == null || s.field_77994_a <= 0 || !ts.func_102008_b(i, s, d.ordinal()) || !this.canInject(obj, s) || !this.canExtract(s)) continue;
                    this.getInv().func_70299_a(0, s);
                    t.func_70299_a(i, null);
                    return;
                }
                break block3;
            }
            for (int i = 0; i < t.func_70302_i_(); ++i) {
                ItemStack s;
                if (t.func_70301_a(i) == null || !this.canInject(obj, s = t.func_70301_a(i)) || !this.canExtract(s)) continue;
                this.getInv().func_70299_a(0, s);
                t.func_70299_a(i, null);
                return;
            }
        }
    }

    public boolean canExtract(ItemStack s) {
        if (s == null) {
            return false;
        }
        if (this.whiteList) {
            for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
                if (!this.checkFilter(i, s)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
            if (!this.checkFilter(i, s)) continue;
            return false;
        }
        return true;
    }

    public boolean checkFilter(int slot, ItemStack i) {
        ItemStack f = this.filter.func_70301_a(slot);
        if (f == null) {
            return false;
        }
        if (!this.ignoreDict && f.func_77973_b() != i.func_77973_b()) {
            int[] c = OreDictionary.getOreIDs((ItemStack)i);
            int[] d = OreDictionary.getOreIDs((ItemStack)f);
            if (c.length > 0 && d.length > 0) {
                for (int k : c) {
                    for (int j : d) {
                        if (k != j) continue;
                        return true;
                    }
                }
            }
        }
        if (f.func_77973_b() != i.func_77973_b()) {
            return false;
        }
        if (!this.ignoreMeta && f.func_77960_j() != i.func_77960_j()) {
            return false;
        }
        return this.ignoreNBT || (f.func_77978_p() == null || f.func_77978_p().equals((Object)i.func_77978_p())) && (f.func_77978_p() != null || i.func_77978_p() != null);
    }

    public boolean canInject(Object obj, ItemStack s) {
        if (obj instanceof IInventory) {
            return MgBeltUtils.dropItemStackIntoInventory((IInventory)obj, s, this.getDir(), true) == 0;
        }
        if (obj instanceof IConveyorBelt) {
            return ((IConveyorBelt)obj).addItem(this.getDir(), 2, new ItemBox(s), true);
        }
        return this.canDropItems();
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInv().readFromNBT(nbt);
        this.counter = nbt.func_74762_e("Stage");
        this.anim = InserterAnimation.values()[nbt.func_74762_e("Animation") % InserterAnimation.values().length];
        this.whiteList = nbt.func_74767_n("WhiteList");
        this.ignoreMeta = nbt.func_74767_n("IgnoreMeta");
        this.ignoreNBT = nbt.func_74767_n("IgnoreNBT");
        this.ignoreDict = nbt.func_74767_n("IgnoreDict");
        this.filter.readFromNBT(nbt, "Filter");
        this.upgrades.readFromNBT(nbt, "Upgrades");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.getInv().writeToNBT(nbt);
        nbt.func_74768_a("Stage", this.counter);
        nbt.func_74768_a("Animation", this.anim == null ? InserterAnimation.EXTENDING_SHORT.ordinal() : this.anim.ordinal());
        nbt.func_74757_a("WhiteList", this.whiteList);
        nbt.func_74757_a("IgnoreMeta", this.ignoreMeta);
        nbt.func_74757_a("IgnoreNBT", this.ignoreNBT);
        nbt.func_74757_a("IgnoreDict", this.ignoreDict);
        this.filter.writeToNBT(nbt, "Filter");
        this.upgrades.writeToNBT(nbt, "Upgrades");
    }

    @Override
    public void onMessageReceive(int id, int data) {
        if (id == 0) {
            this.whiteList = data == 1;
        } else if (id == 1) {
            this.ignoreMeta = data == 1;
        } else if (id == 2) {
            this.ignoreNBT = data == 1;
        } else if (id == 3) {
            this.ignoreDict = data == 1;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static enum InserterAnimation {
        ROTATING,
        ROTATING_INV,
        RETRACTING_SHORT,
        EXTENDING_SHORT,
        RETRACTING_INV_SHORT,
        EXTENDING_INV_SHORT,
        RETRACTING_LARGE,
        EXTENDING_LARGE,
        RETRACTING_INV_LARGE,
        EXTENDING_INV_LARGE,
        DROP_ITEM,
        SUCK_ITEM,
        DROP_ITEM_LARGE,
        SUCK_ITEM_LARGE;

    }
}

