/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.conveyor.IConveyorBelt;
import com.cout970.magneticraft.api.conveyor.IConveyorBeltLane;
import com.cout970.magneticraft.api.conveyor.IItemBox;
import com.cout970.magneticraft.api.conveyor.prefab.ConveyorBeltLane;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.Orientation;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.tileentity.TileBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileConveyorBelt
extends TileBase
implements IConveyorBelt {
    public ConveyorBeltLane left = new ConveyorBeltLane(this, true);
    public ConveyorBeltLane right = new ConveyorBeltLane(this, false);
    public long time;

    @Override
    public MgDirection getDir() {
        return this.getOrientation().getDirection();
    }

    @Override
    public void onBlockBreaks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (IItemBox b : this.left.getItemBoxes()) {
            BlockMg.dropItem(b.getContent(), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
        for (IItemBox b : this.right.getItemBoxes()) {
            BlockMg.dropItem(b.getContent(), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.moveCole(this.left);
        this.moveCole(this.right);
        this.time = System.currentTimeMillis();
        if (this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.sendUpdateToClient();
        }
    }

    private void moveCole(ConveyorBeltLane side) {
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            side.getHitBoxes().clear();
        }
        for (int i = 0; i < side.getItemBoxes().size(); ++i) {
            int new_pos;
            IItemBox b = side.getItemBoxes().get(i);
            if (b.getLastUpdateTick() == this.field_145850_b.func_82737_E()) continue;
            b.setLastUpdateTick(this.field_145850_b.func_82737_E());
            if (b.getPosition() < 15) {
                side.avance(b);
                continue;
            }
            TileEntity t = ConveyorBeltLane.getFrontConveyor(this);
            if (!(t instanceof IConveyorBelt)) continue;
            IConveyorBelt con = (IConveyorBelt)t;
            IConveyorBelt.BeltInteraction iter = IConveyorBelt.BeltInteraction.InterBelt(this.getDir(), con.getDir());
            if (iter == IConveyorBelt.BeltInteraction.DIRECT) {
                if (b.getPosition() < 16) {
                    side.avance(b);
                }
                if (b.getPosition() != 16) continue;
                con.getSideLane(side.isOnLeft()).setHitBoxSpace(0, false);
                if (!con.inject(0, b, side.isOnLeft(), false)) continue;
                this.extract(b, side.isOnLeft(), false);
                continue;
            }
            if (con.getOrientation().getLevel() != 0) continue;
            if (iter == IConveyorBelt.BeltInteraction.LEFT_T) {
                if (b.getPosition() < 18) {
                    side.avance(b);
                }
                if (b.getPosition() != 18) continue;
                new_pos = side.isOnLeft() ? 2 : 10;
                con.getSideLane(false).setHitBoxSpace(new_pos, false);
                if (!con.inject(new_pos, b, false, false)) continue;
                this.extract(b, side.isOnLeft(), false);
                continue;
            }
            if (iter != IConveyorBelt.BeltInteraction.RIGHT_T) continue;
            if (b.getPosition() < 18) {
                side.avance(b);
            }
            if (b.getPosition() != 18) continue;
            new_pos = side.isOnLeft() ? 10 : 2;
            con.getSideLane(true).setHitBoxSpace(new_pos, false);
            if (!con.inject(new_pos, b, true, false)) continue;
            this.extract(b, side.isOnLeft(), false);
        }
    }

    @Override
    public boolean extract(IItemBox box, boolean isOnLeft, boolean simulated) {
        ConveyorBeltLane side;
        ConveyorBeltLane conveyorBeltLane = side = isOnLeft ? this.left : this.right;
        if (side.getItemBoxes().contains(box)) {
            if (!simulated) {
                side.getItemBoxes().remove(box);
                side.setHitBoxSpace(box.getPosition(), false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean inject(int pos, IItemBox box, boolean isOnLeft, boolean simulated) {
        ConveyorBeltLane side;
        ConveyorBeltLane conveyorBeltLane = side = isOnLeft ? this.left : this.right;
        if (side.hasHitBoxSpace(pos)) {
            if (!simulated) {
                box.setPosition(pos);
                box.setOnLeft(isOnLeft);
                side.setHitBoxSpace(pos, true);
                side.getItemBoxes().add(box);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addItem(MgDirection dir, int pos, IItemBox b, boolean sim) {
        if (b == null) {
            return false;
        }
        boolean onLeft = dir.isPerpendicular(this.getDir()) ? dir == this.getDir().step(MgDirection.UP) : b.isOnLeft();
        return this.inject(pos, b, onLeft, sim);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.left.save(nbt);
        this.right.save(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.left.load(nbt);
        this.right.load(nbt);
    }

    @Override
    public TileEntity getParent() {
        return this;
    }

    @Override
    public IConveyorBeltLane getSideLane(boolean left) {
        return left ? this.left : this.right;
    }

    @Override
    public Orientation getOrientation() {
        return Orientation.fromMeta(this.func_145832_p());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)((float)(this.field_145851_c + 1) + 0.3125f), (double)((float)(this.field_145848_d + 1) + 0.3125f), (double)((float)(this.field_145849_e + 1) + 0.3125f));
    }

    @Override
    public boolean removeItem(IItemBox it, boolean isLeft, boolean simulated) {
        return this.extract(it, isLeft, simulated);
    }

    @Override
    public void onChange() {
        this.sendUpdateToClient();
    }
}

