/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.prefab.HeatConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.tile.TileHeatConductor;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileBoiler
extends TileHeatConductor
implements IFluidHandler1_8,
IGuiSync {
    public static final int MAX_STEAM = 80;
    public TankMg water = new TankMg(this, 2000);
    public TankMg steam = new TankMg(this, 8000);
    public int produce;

    @Override
    public IHeatConductor initHeatCond() {
        return new HeatConductor(this, 1400.0, 1000.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.heat.getTemperature() > 100.0) {
            int cs = Math.min(this.water.getFluidAmount(), EnergyConverter.STEAMtoWATER(this.steam.getSpace()));
            int boil = Math.min(Math.min(cs, EnergyConverter.STEAMtoWATER(80)), (int)this.heat.getTemperature() - 100);
            this.produce = EnergyConverter.WATERtoSTEAM(boil);
            if (boil > 0) {
                this.water.drain(boil, true);
                this.steam.fill(FluidRegistry.getFluidStack((String)"steam", (int)EnergyConverter.WATERtoSTEAM(boil)), true);
                this.heat.drainCalories(EnergyConverter.WATERtoSTEAM_HEAT(boil));
            }
        }
        MgUtils.getNeig(this).stream().filter(t -> t instanceof TileBoiler).forEach(t -> {
            int pass;
            int dif2;
            int pass2;
            TileBoiler b = (TileBoiler)t;
            int dif = this.water.getFluidAmount() - b.water.getFluidAmount();
            if (dif > 0 && (pass2 = dif / 2) > 0) {
                FluidStack d = this.water.drain(pass2, false);
                int a = b.water.fill(d, true);
                this.water.drain(a, true);
            }
            if ((dif2 = this.steam.getFluidAmount() - b.steam.getFluidAmount()) > 0 && (pass = dif2 / 2) > 0) {
                FluidStack d = this.steam.drain(pass, false);
                int a = b.steam.fill(d, true);
                this.steam.drain(a, true);
            }
        });
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.getFluid((String)"water")) {
            return this.water.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == FluidRegistry.getFluid((String)"steam")) {
            return this.steam.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        return this.steam.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        return fluid == FluidRegistry.getFluid((String)"steam");
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.steam.getInfo()};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.readFromNBT((NBTTagCompound)nbt.func_74781_a("water"));
        this.steam.readFromNBT((NBTTagCompound)nbt.func_74781_a("steam"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound nbt2 = new NBTTagCompound();
        this.water.writeToNBT(nbt2);
        nbt.func_74782_a("water", (NBTBase)nbt2);
        NBTTagCompound nbt3 = new NBTTagCompound();
        this.steam.writeToNBT(nbt3);
        nbt.func_74782_a("steam", (NBTBase)nbt3);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting c) {
        c.func_71112_a(cont, 0, (int)Math.ceil(this.heat.getTemperature()));
        c.func_71112_a(cont, 1, this.steam.getFluidAmount());
        c.func_71112_a(cont, 2, this.water.getFluidAmount());
        c.func_71112_a(cont, 3, this.produce);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.heat.setTemperature(value);
        }
        if (id == 1) {
            this.steam.setFluid(FluidRegistry.getFluidStack((String)"steam", (int)value));
        }
        if (id == 2) {
            this.water.setFluid(FluidRegistry.getFluidStack((String)"water", (int)value));
        }
        if (id == 3) {
            this.produce = value;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
    }

    public IBarProvider getProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return "Steam produced: " + TileBoiler.this.produce + "mB/t";
            }

            @Override
            public float getMaxLevel() {
                return 80.0f;
            }

            @Override
            public float getLevel() {
                return TileBoiler.this.produce;
            }
        };
    }
}

