/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.heat;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.heat.HeatUtils;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.prefab.HeatConductor;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.tilerender.TileRenderHeatCable;
import com.cout970.magneticraft.parts.heat.PartHeat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class PartHeatCable
extends PartHeat
implements ISidedHollowConnect {
    public byte conMask = (byte)-1;
    public static List<Cuboid6> boxes = new ArrayList<Cuboid6>();
    private TileRenderHeatCable render;

    public PartHeatCable() {
        super(ManagerItems.partheatcable);
    }

    @Override
    public void create() {
        this.heat = new HeatConductor(this.getTile(), 1400.0, 1000.0){

            @Override
            public boolean isAbleToConnect(IConnectable cond, VecInt d) {
                return d.equals(VecInt.NULL_VECTOR) || d.toMgDirection() != null && ((TileMultipart)PartHeatCable.this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.toMgDirection().ordinal())));
            }
        };
    }

    @Override
    public void updateConnections() {
        this.conMask = 0;
        block0: for (MgDirection d : MgDirection.values()) {
            TileEntity t = MgUtils.getTileEntity((TileEntity)this.tile(), d);
            IHeatConductor[] c = HeatUtils.getHeatCond(t, d.toVecInt().getOpposite());
            if (c == null) continue;
            for (IHeatConductor cond : c) {
                if (cond == null || !cond.isAbleToConnect(this.heat, d.opposite().toVecInt()) || !this.heat.isAbleToConnect(cond, d.toVecInt())) continue;
                this.conMask = (byte)(this.conMask | 1 << d.ordinal());
                continue block0;
            }
        }
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.conMask = (byte)-1;
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Collections.singletonList(boxes.get(6));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        t2.add(boxes.get(6));
        for (int i = 0; i < 6; ++i) {
            if ((this.conMask & 1 << i) <= 0) continue;
            t2.add(boxes.get(i));
        }
        return t2;
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (this.render == null) {
            this.render = new TileRenderHeatCable();
        }
        this.render.render(this, pos);
    }

    public int getHollowSize(int side) {
        return 12;
    }

    static {
        double w = 0.375;
        boxes.clear();
        boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w, 1.0, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, 0.5 - w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w, 1.0));
        boxes.add(new Cuboid6(0.0, 0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 + w, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w));
    }
}

