/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.computer.IOpticFiber;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.client.tilerender.TileRenderOpticFiber;
import com.cout970.magneticraft.parts.MgPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class PartOpticFiber
extends MgPart
implements IOpticFiber {
    public TileRenderOpticFiber renderer;
    public static List<Cuboid6> boxes = new ArrayList<Cuboid6>();
    public int connections;

    public PartOpticFiber() {
        super(ManagerItems.part_optic_fiber);
    }

    public void update() {
        super.update();
        this.connections = 0;
        for (MgDirection dir : MgDirection.values()) {
            IOpticFiber f = MgUtils.getOpticFiber(MgUtils.getTileEntity((TileEntity)this.tile(), dir), dir.opposite());
            if (f == null) continue;
            this.connections |= 1 << dir.ordinal();
        }
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Collections.singletonList(boxes.get(6));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> list = new ArrayList<Cuboid6>();
        list.add(boxes.get(6));
        if ((this.connections & 1) > 0) {
            list.add(boxes.get(0));
        }
        if ((this.connections & 2) > 0) {
            list.add(boxes.get(1));
        }
        if ((this.connections & 4) > 0) {
            list.add(boxes.get(2));
        }
        if ((this.connections & 8) > 0) {
            list.add(boxes.get(3));
        }
        if ((this.connections & 0x10) > 0) {
            list.add(boxes.get(4));
        }
        if ((this.connections & 0x20) > 0) {
            list.add(boxes.get(5));
        }
        return list;
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (this.renderer == null) {
            this.renderer = new TileRenderOpticFiber();
        }
        this.renderer.render(this, pos);
    }

    static {
        double p = 0.0625;
        boxes.clear();
        boxes.add(new Cuboid6(1.0 - 5.0 * p, 0.0, 1.0 - 5.0 * p, 1.0 - 3.0 * p, 3.0 * p, 1.0 - 3.0 * p));
        boxes.add(new Cuboid6(1.0 - 5.0 * p, 5.0 * p, 1.0 - 5.0 * p, 1.0 - 3.0 * p, 1.0, 1.0 - 3.0 * p));
        boxes.add(new Cuboid6(11.0 * p, 3.0 * p, 0.0, 1.0 - 3.0 * p, 5.0 * p, 1.0 - 5.0 * p));
        boxes.add(new Cuboid6(11.0 * p, 3.0 * p, 1.0 - 3.0 * p, 1.0 - 3.0 * p, 5.0 * p, 1.0));
        boxes.add(new Cuboid6(0.0, 3.0 * p, 11.0 * p, 1.0 - 5.0 * p, 5.0 * p, 1.0 - 3.0 * p));
        boxes.add(new Cuboid6(1.0 - 3.0 * p, 3.0 * p, 11.0 * p, 1.0, 5.0 * p, 1.0 - 3.0 * p));
        boxes.add(new Cuboid6(11.0 * p, 3.0 * p, 11.0 * p, 1.0 - 3.0 * p, 5.0 * p, 1.0 - 3.0 * p));
    }
}

