/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.items;

import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemMeta
extends Item {
    public static final String name_base = "magneticraft:";
    private String[] unloc_names;
    private String[] texture_names;
    private String[] oreDict_names;
    private String[] en_US_names;
    private int meta_amount;
    public IIcon[] icons;

    public ItemMeta(String masterUnlocName, int nlength) {
        this.meta_amount = nlength;
        this.func_77627_a(true);
        this.func_77655_b(masterUnlocName);
        this.unloc_names = new String[nlength];
        this.texture_names = new String[nlength];
        this.oreDict_names = new String[nlength];
        this.en_US_names = new String[nlength];
        this.icons = new IIcon[nlength];
    }

    public ItemMeta setUnlocByPattern(String pattern, String[] names) {
        assert (names.length == this.meta_amount);
        for (int i = 0; i < names.length; ++i) {
            this.unloc_names[i] = pattern.replaceAll("!id!", Integer.toString(i)).replaceAll("!name!", names[i]).replaceAll("!lower_name!", names[i].toLowerCase(Locale.US));
        }
        return this;
    }

    public ItemMeta setTextureByPattern(String pattern, String[] names) {
        assert (names.length == this.meta_amount);
        for (int i = 0; i < names.length; ++i) {
            this.texture_names[i] = pattern.replaceAll("!id!", Integer.toString(i)).replaceAll("!name!", names[i]).replaceAll("!lower_name!", names[i].toLowerCase(Locale.US));
        }
        return this;
    }

    public ItemMeta setOreDictByPattern(String pattern, String[] names) {
        assert (names.length == this.meta_amount);
        for (int i = 0; i < names.length; ++i) {
            this.oreDict_names[i] = pattern.replaceAll("!id!", Integer.toString(i)).replaceAll("!name!", names[i]).replaceAll("!lower_name!", names[i].toLowerCase(Locale.US));
        }
        return this;
    }

    public ItemMeta setNameByPattern(String pattern, String[] names) {
        assert (names.length == this.meta_amount);
        for (int i = 0; i < names.length; ++i) {
            this.en_US_names[i] = pattern.replaceAll("!id!", Integer.toString(i)).replaceAll("!name!", names[i]).replaceAll("!lower_name!", names[i].toLowerCase(Locale.US));
        }
        return this;
    }

    public String func_77667_c(ItemStack is) {
        return this.unloc_names[is.func_77960_j()];
    }

    public String getName(ItemStack is, Locale locale) {
        if (locale == Locale.US) {
            return this.en_US_names[is.func_77960_j()];
        }
        return this.unloc_names[is.func_77960_j()];
    }

    public String getName(int meta, Locale locale) {
        assert (meta >= 0);
        assert (meta < this.meta_amount);
        if (locale == Locale.US) {
            return this.en_US_names[meta];
        }
        return this.unloc_names[meta];
    }

    public void func_94581_a(IIconRegister ir) {
        for (int i = 0; i < this.meta_amount; ++i) {
            this.icons[i] = ir.func_94245_a(name_base + this.texture_names[i]);
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta >= this.meta_amount) {
            meta = 0;
        }
        return this.icons[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.meta_amount; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String getOreDictName(int meta) {
        return this.oreDict_names[meta];
    }

    public int getMetaAmount() {
        return this.meta_amount;
    }
}

