/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.handlers;

import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.IFuelManager;
import cpw.mods.fml.common.Optional;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;

@Optional.Interface(iface="buildcraft.api.fuels.IFuelManager", modid="BuildCraft|Core")
public class FluidFuelHandler
implements IFuelManager {
    public Map<Fluid, IFuel> fluids = new HashMap<Fluid, IFuel>();

    public IFuel addFuel(IFuel fuel) {
        if (this.fluids.containsKey(fuel.getFluid())) {
            return this.fluids.get(fuel.getFluid());
        }
        this.fluids.put(fuel.getFluid(), fuel);
        return fuel;
    }

    public IFuel addFuel(Fluid fluid, int powerPerCycle, int totalBurningTime) {
        Fuel fuel = new Fuel(fluid, powerPerCycle, totalBurningTime);
        if (this.fluids.containsKey(fuel.getFluid())) {
            return this.fluids.get(fuel.getFluid());
        }
        this.fluids.put(fuel.getFluid(), fuel);
        return fuel;
    }

    public Collection<IFuel> getFuels() {
        return this.fluids.values();
    }

    public IFuel getFuel(Fluid fluid) {
        return this.fluids.get(fluid);
    }

    public class Fuel
    implements IFuel {
        private Fluid fluid;
        private int burnTime;
        private int energy;

        public Fuel(Fluid f, int e, int b) {
            this.fluid = f;
            this.energy = e;
            this.burnTime = b;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public int getTotalBurningTime() {
            return this.burnTime;
        }

        public int getPowerPerCycle() {
            return this.energy;
        }
    }
}

