/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.container;

import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.container.ContainerBasic;
import com.cout970.magneticraft.container.SlotShelvingUnit;
import com.cout970.magneticraft.tileentity.shelf.TileShelvingUnit;
import com.cout970.magneticraft.util.InventoryResizable;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

@ChestContainer
public class ContainerShelvingUnit
extends ContainerBasic {
    public TileShelvingUnit shelf;
    public int curInv = 0;
    public List<SlotShelvingUnit> currentSlots = new ArrayList<SlotShelvingUnit>();
    private boolean isFiltered = false;

    public ContainerShelvingUnit(InventoryPlayer inv, TileEntity t) {
        super(t);
        this.shelf = (TileShelvingUnit)t;
        for (int i = 0; i < 3; ++i) {
            InventoryResizable tabInv = this.shelf.getInv(i);
            tabInv.func_70295_k_();
            for (int s = 0; s < tabInv.func_70302_i_(); ++s) {
                int y = s / 9;
                int x = s % 9;
                SlotShelvingUnit slot = new SlotShelvingUnit(tabInv, s, 8 + x * 18, 18 + y * 18, i);
                if (this.field_75151_b.size() >= this.shelf.getCrateCount() * 27) {
                    slot.lock();
                }
                this.func_75146_a(slot);
            }
        }
        this.bindPlayerInventory(inv);
    }

    @Override
    public void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 122 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 180));
        }
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getSections() {
        EnumMap<ContainerSection, List<Slot>> retMap = new EnumMap<ContainerSection, List<Slot>>(ContainerSection.class);
        List inventory = this.field_75151_b.stream().filter(s -> !(s instanceof SlotShelvingUnit)).sorted((s1, s2) -> Integer.compare(((Slot)s1).field_75222_d, ((Slot)s2).field_75222_d)).collect(Collectors.toList());
        List<SlotShelvingUnit> curSlots = this.isFiltered ? this.currentSlots : this.field_75151_b.stream().filter(s -> s instanceof SlotShelvingUnit).filter(s -> ((SlotShelvingUnit)s).invNum == this.curInv).collect(Collectors.toList());
        retMap.put(ContainerSection.INVENTORY_HOTBAR, inventory.subList(0, 9));
        retMap.put(ContainerSection.INVENTORY_NOT_HOTBAR, this.field_75151_b.subList(10, 36));
        retMap.put(ContainerSection.CHEST, curSlots);
        return retMap;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        int[] slots = new int[648];
        Arrays.fill(slots, 0);
        Arrays.fill(slots, 216 * this.curInv, Math.min(this.shelf.getCrateCount() * 27, 216 * (this.curInv + 1)), 3);
        return this.transfer(player, slot, slots);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        for (int i = 0; i < 3; ++i) {
            this.shelf.getInv(i).func_70305_f();
        }
    }

    public boolean func_75140_a(EntityPlayer player, int data) {
        this.curInv = data;
        return true;
    }

    public void adjustSlots(int scroll, String filter, int level) {
        this.adjustSlots(this.curInv, scroll, filter, level);
    }

    public void adjustSlots(int curInv, int scroll, String filter) {
        this.adjustSlots(curInv, scroll, filter, 2);
    }

    public void adjustSlots(int curInv, int scroll, String filter, int level) {
        if (this.shelf.getCrateCount() == 0) {
            this.field_75151_b.stream().filter(s -> s instanceof SlotShelvingUnit).forEach(s -> {
                ((SlotShelvingUnit)s).lock();
                ((SlotShelvingUnit)s).hide();
            });
            return;
        }
        if (curInv != this.curInv) {
            this.curInv = curInv;
            level = 2;
        }
        this.renewSlots(level, filter);
        this.isFiltered = filter.isEmpty();
        if (this.isFiltered) {
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                Object s2 = this.field_75151_b.get(i);
                if (!(s2 instanceof SlotShelvingUnit)) continue;
                SlotShelvingUnit st = (SlotShelvingUnit)s2;
                st.reset();
                st.field_75221_f = st.baseY - 18 * scroll;
                if (st.field_75221_f < 17 || st.field_75221_f > 106 || st.invNum != curInv) {
                    st.hide();
                }
                if (i < this.shelf.getCrateCount() * 27 && st.invNum == curInv) continue;
                st.lock();
            }
        } else {
            this.field_75151_b.stream().filter(s -> s instanceof SlotShelvingUnit).forEach(s -> {
                ((SlotShelvingUnit)s).reset();
                ((SlotShelvingUnit)s).hide();
                ((SlotShelvingUnit)s).lock();
            });
            for (int i = 0; i < this.currentSlots.size(); ++i) {
                SlotShelvingUnit st = this.currentSlots.get(i);
                st.unlock();
                st.field_75223_e = 8 + 18 * (i % 9);
                st.field_75221_f = 18 + 18 * (i / 9 - scroll);
                if (st.field_75221_f >= 17 && st.field_75221_f <= 106) continue;
                st.hide();
            }
        }
    }

    public void renewSlots(int mode, String filter) {
        if (mode == 0) {
            return;
        }
        if (mode == 1) {
            this.currentSlots = this.currentSlots.stream().filter(s -> MgUtils.matchesPattern(s.func_75211_c(), filter)).collect(Collectors.toList());
        }
        if (mode == 2) {
            this.currentSlots = this.field_75151_b.stream().filter(s -> s instanceof SlotShelvingUnit).filter(s -> ((SlotShelvingUnit)s).invNum == this.curInv && MgUtils.matchesPattern(((SlotShelvingUnit)s).func_75211_c(), filter)).collect(Collectors.toList());
        }
    }
}

