/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipeBiomassBurner;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.util.RenderUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CraftingBiomassBurner
extends TemplateRecipeHandler {
    List<RecipeBiomassBurner> recipes = new ArrayList<RecipeBiomassBurner>();

    public String getRecipeName() {
        return "Biomass Burner";
    }

    public String getGuiTexture() {
        return "magneticraft:textures/gui/nei/biomass_burner.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 18, 16, 16), this.getRecipesID(), new Object[0]));
    }

    private String getRecipesID() {
        return "mg_biomas_burner";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipesID())) {
            this.recipes.addAll(MgRecipeRegister.biomassBurner.stream().collect(Collectors.toList()));
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.recipes.addAll(MgRecipeRegister.biomassBurner.stream().filter(recipe -> recipe.matches(ingredient)).collect(Collectors.toList()));
    }

    public PositionedStack getResultStack(int recipe) {
        return null;
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        ArrayList<PositionedStack> need = new ArrayList<PositionedStack>();
        need.add(new PositionedStack((Object)this.recipes.get(recipe).getFuel(), 75, 36));
        return need;
    }

    public int numRecipes() {
        return this.recipes.size();
    }

    public void drawExtras(int recipe) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/heatbar.png"));
        int heat = (int)EnergyConverter.FUELtoCALORIES(this.recipes.get(recipe).getBurnTime());
        int scale = (int)(44.0f * ((float)heat / 750.0f) / 1400.0f);
        RenderUtil.drawTexturedModalRectScaled(102, 9 + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
        RenderUtil.drawString(String.format("%.1fkcal", Float.valueOf((float)heat / 1000.0f)), 115, 30, RenderUtil.fromRGB(255, 255, 255), false);
    }
}

