/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.minetweaker;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.ThermopileFuel;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.block.IBlock;
import net.minecraft.block.Block;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.Thermopile")
public class Thermopile {
    @ZenMethod
    public static void addHotSource(IBlock block, int metadata, int temp) {
        Block b = MgMinetweaker.getBlock(block);
        MineTweakerAPI.apply((IUndoableAction)new HotSource(new BlockInfo(b, metadata), temp));
    }

    @ZenMethod
    public static void addColdSource(IBlock block, int metadata, int temp) {
        Block b = MgMinetweaker.getBlock(block);
        MineTweakerAPI.apply((IUndoableAction)new ColdSource(new BlockInfo(b, metadata), temp));
    }

    @ZenMethod
    public static void removeHeatSource(IBlock block, int metadata) {
        Block b = MgMinetweaker.getBlock(block);
        ThermopileFuel r = ThermopileFuel.getRecipe(new BlockInfo(b, metadata));
        if (r == null) {
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveSource(r));
    }

    public static class RemoveSource
    implements IUndoableAction {
        private final ThermopileFuel r;

        public RemoveSource(ThermopileFuel b) {
            this.r = b;
        }

        public void apply() {
            MgRecipeRegister.thermopileSources.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.thermopileSources.add(this.r);
        }
    }

    public static class ColdSource
    implements IUndoableAction {
        private final ThermopileFuel r;

        public ColdSource(BlockInfo b, int temp) {
            this.r = new ThermopileFuel(b, temp, false);
        }

        public void apply() {
            MgRecipeRegister.thermopileSources.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.thermopileSources.remove(this.r);
        }
    }

    public static class HotSource
    implements IUndoableAction {
        private final ThermopileFuel r;

        public HotSource(BlockInfo b, int temp) {
            this.r = new ThermopileFuel(b, temp, true);
        }

        public void apply() {
            MgRecipeRegister.thermopileSources.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.thermopileSources.remove(this.r);
        }
    }
}

