/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.minetweaker;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipeSifter;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.Sifter")
public class Sifter {
    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out0, IItemStack out1, float prob1) {
        ItemStack a = MgMinetweaker.toStack(in);
        ItemStack b = MgMinetweaker.toStack(out0);
        ItemStack c = MgMinetweaker.toStack(out1);
        if (a == null || b == null) {
            return;
        }
        RecipeSifter r = new RecipeSifter(a, b, c, prob1);
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        RecipeSifter r = RecipeSifter.getRecipe(MgMinetweaker.toStack(input));
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(r));
    }

    public static class RemoveRecipe
    implements IUndoableAction {
        private final RecipeSifter r;

        public RemoveRecipe(RecipeSifter r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.sifter.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.sifter.add(this.r);
        }
    }

    public static class AddRecipe
    implements IUndoableAction {
        private final RecipeSifter r;

        public AddRecipe(RecipeSifter r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.sifter.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.sifter.remove(this.r);
        }
    }
}

