/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.minetweaker;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipePolymerizer;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.Polymerizer")
public class Polymerizer {
    @ZenMethod
    public static void addRecipe(ILiquidStack f, IItemStack in, IItemStack out0, double temp) {
        ItemStack a = MgMinetweaker.toStack(in);
        ItemStack b = MgMinetweaker.toStack(out0);
        FluidStack fluid = MgMinetweaker.toFluid(f);
        if (a == null || b == null) {
            return;
        }
        RecipePolymerizer r = new RecipePolymerizer(fluid, a, b, temp);
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        RecipePolymerizer r = RecipePolymerizer.getRecipe(MgMinetweaker.toStack(input));
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(r));
    }

    public static class RemoveRecipe
    implements IUndoableAction {
        private final RecipePolymerizer r;

        public RemoveRecipe(RecipePolymerizer r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.polymerizer.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.polymerizer.add(this.r);
        }
    }

    public static class AddRecipe
    implements IUndoableAction {
        private final RecipePolymerizer r;

        public AddRecipe(RecipePolymerizer r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.polymerizer.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.polymerizer.remove(this.r);
        }
    }
}

