/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.minetweaker;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipeBiomassBurner;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.BiomassBurner")
public class BiomassBurner {
    @ZenMethod
    public static void addFuel(IItemStack fuel, int burningTime) {
        ItemStack a = MgMinetweaker.toStack(fuel);
        if (a == null && burningTime <= 0) {
            return;
        }
        RecipeBiomassBurner r = new RecipeBiomassBurner(a, burningTime, true);
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(r));
    }

    @ZenMethod
    public static void removeFuel(IItemStack fuel) {
        ItemStack a = MgMinetweaker.toStack(fuel);
        RecipeBiomassBurner r = RecipeBiomassBurner.getRecipe(a);
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(r));
    }

    public static class RemoveRecipe
    implements IUndoableAction {
        private final RecipeBiomassBurner r;

        public RemoveRecipe(RecipeBiomassBurner r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.biomassBurner.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.biomassBurner.add(this.r);
        }
    }

    public static class AddRecipe
    implements IUndoableAction {
        private final RecipeBiomassBurner r;

        public AddRecipe(RecipeBiomassBurner r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.biomassBurner.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.biomassBurner.remove(this.r);
        }
    }
}

