/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui.component;

import com.cout970.magneticraft.api.electricity.ElectricConstants;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class CompEnergyBarMediumVoltage
implements IGuiComp {
    public ResourceLocation texture;
    public GuiPoint pos;
    public IElectricConductor cond;

    public CompEnergyBarMediumVoltage(ResourceLocation tex, GuiPoint p, IElectricConductor cond) {
        this.texture = tex;
        this.pos = p;
        this.cond = cond;
    }

    @Override
    public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
        if (this.cond == null) {
            return;
        }
        int scale = (int)(this.cond.getVoltage() >= ElectricConstants.MAX_VOLTAGE * 100.0 ? 50.0 : 50.0 * (this.cond.getVoltage() / (ElectricConstants.MAX_VOLTAGE * 100.0)));
        gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
        RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (50 - scale), 25, 50 - scale, 5, scale, 70, 50);
    }

    @Override
    public void onClick(int mx, int my, int button, GuiBasic gui) {
    }

    @Override
    public boolean onKey(int n, char key, GuiBasic gui) {
        return false;
    }

    @Override
    public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
        if (this.cond == null) {
            return;
        }
        if (GuiBasic.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 6, 50)) {
            ArrayList<String> data = new ArrayList<String>();
            data.add((int)this.cond.getVoltage() + "V");
            gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
            RenderHelper.func_74520_c();
        }
    }
}

