/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.ManagerNetwork;
import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompButton;
import com.cout970.magneticraft.client.gui.component.CompScrollBar;
import com.cout970.magneticraft.client.gui.component.CompTextField;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.container.ContainerShelvingUnit;
import com.cout970.magneticraft.container.SlotShelvingUnit;
import com.cout970.magneticraft.messages.MessageShelfSlotUpdate;
import com.cout970.magneticraft.tileentity.shelf.TileShelvingUnit;
import com.cout970.magneticraft.util.MultilineString;
import com.google.common.base.Function;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiShelvingUnit
extends GuiBasic {
    private static final ResourceLocation BG_DISABLED = new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/shelving_unit_disabled.png");
    private static final MultilineString CRATE_MESSAGE = new MultilineString("{{0:-20}}This shelving unit{{0:-10}}has no crates!{{0:0}}Right-click it with a chest{{0:10}}to add one.");
    private CompScrollBar scrollBar;
    private ContainerShelvingUnit shelfContainer;
    private int lastCrateCount;
    private int slotRenewal;
    private TileShelvingUnit shelf;
    public List<CompButton> tabButtons;
    private CompTextField textField;

    public GuiShelvingUnit(Container c, TileEntity tile) {
        super(c, tile);
        this.field_146999_f = 195;
        this.xTam = 195;
        this.field_147000_g = 204;
        this.yTam = 204;
    }

    @Override
    public void initComponents() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.shelfContainer = (ContainerShelvingUnit)this.field_147002_h;
        this.shelf = this.shelfContainer.shelf;
        this.comp.add(new CompBackground(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/shelving_unit.png")));
        this.textField = new CompTextField(Minecraft.func_71410_x().field_71466_p, 9, 6, 87, 7);
        this.scrollBar = new CompScrollBar(new GuiPoint(175, 18), new GuiPoint(187, 106), 19);
        this.tabButtons = new ArrayList<CompButton>();
        for (int i = 0; i < 3; ++i) {
            int tab = i;
            CompButton button = new CompButton(new GuiPoint(173, 158 - 18 * i), 16, 16, new GuiPoint(0, 32 - 16 * i), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(tab, (int)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 32 - 16 * i)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 32 - 16 * i)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 32 - 16 * i)).setClickable(CompButton.ButtonState.ACTIVE, false);
            this.tabButtons.add(button);
        }
        this.slotRenewal = 2;
        this.lastCrateCount = this.shelf.getCrateCount();
        this.comp.addAll(this.tabButtons);
        this.shelfContainer.curInv = 0;
    }

    public Slot func_146975_c(int x, int y) {
        int inv = -1;
        if (x >= this.field_147003_i + 8 && x <= this.field_147003_i + 187 && y >= this.field_147009_r + 17 && y <= this.field_147009_r + 106) {
            inv = this.shelfContainer.curInv;
        }
        if (inv != -1) {
            for (SlotShelvingUnit slot : this.shelfContainer.currentSlots) {
                if (!this.func_146981_a(slot, x, y)) continue;
                return slot;
            }
        } else {
            for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
                if (!this.func_146981_a(slot, x, y) || slot instanceof SlotShelvingUnit) continue;
                return slot;
            }
        }
        return null;
    }

    @Override
    protected void func_146976_a(float fps, int mx, int my) {
        int allowed = (int)Math.ceil((float)this.shelfContainer.shelf.getCrateCount() / 8.0f) - 1;
        this.assertTabStates(allowed);
        super.func_146976_a(fps, mx, my);
        this.textField.render(mx, my, this.tile, this);
        if (this.shelf.getCrateCount() != this.lastCrateCount) {
            this.slotRenewal = 2;
        }
        this.lastCrateCount = this.shelf.getCrateCount();
        this.shelfContainer.adjustSlots(this.scrollBar.getScroll(), this.textField.func_146179_b(), this.slotRenewal);
        if (this.slotRenewal != 0) {
            ManagerNetwork.INSTANCE.sendToServer((IMessage)new MessageShelfSlotUpdate(this.shelfContainer.curInv, this.scrollBar.getScroll(), this.textField.func_146179_b(), this.slotRenewal));
        }
        if (Mouse.isButtonDown((int)0)) {
            this.scrollBar.onClick(mx, my, 0, this);
        } else {
            this.scrollBar.setTracking(false);
        }
        this.scrollBar.render(mx, my, this.tile, this);
        if (allowed < 0) {
            this.field_146297_k.func_110434_K().func_110577_a(BG_DISABLED);
            this.func_73729_b(this.xStart + 7, this.yStart + 17, 0, 0, 162, 90);
            CRATE_MESSAGE.drawCentered((GuiScreen)this, this.field_146289_q, this.xStart + 88, this.yStart + 62, 0xFFFFFF);
        } else if (this.textField.func_146179_b().isEmpty()) {
            for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
                Object s = this.field_147002_h.field_75151_b.get(i);
                if (!(s instanceof SlotShelvingUnit)) continue;
                SlotShelvingUnit st = (SlotShelvingUnit)s;
                if (!st.locked || st.hidden) continue;
                this.field_146297_k.func_110434_K().func_110577_a(SlotShelvingUnit.BG_LOCKED);
                GL11.glEnable((int)3042);
                GL11.glDisable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(st.field_75223_e + this.field_147003_i, st.field_75221_f + this.field_147009_r, 0, 0, 16, 16);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
            }
        } else {
            for (int i = this.shelfContainer.currentSlots.size(); i < 45; ++i) {
                this.field_146297_k.func_110434_K().func_110577_a(SlotShelvingUnit.BG_LOCKED);
                GL11.glEnable((int)3042);
                GL11.glDisable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.xStart + 8 + 18 * (i % 9), this.yStart + 18 + 18 * (i / 9), 0, 0, 16, 16);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int dw = Mouse.getEventDWheel();
        if (dw != 0) {
            this.scrollBar.onWheel(dw / Math.abs(dw));
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        this.textField.onClick(x, y, b, this);
        super.func_73864_a(x, y, b);
    }

    public boolean apply(int tab, int mouseButton) {
        if (mouseButton == 0) {
            this.shelfContainer.curInv = tab;
            this.field_146297_k.field_71442_b.func_78756_a(this.shelfContainer.field_75152_c, this.shelfContainer.curInv);
        }
        this.slotRenewal = 2;
        return true;
    }

    public void assertTabStates(int allowed) {
        if (allowed >= 0) {
            this.tabButtons.forEach(n -> n.setCurrentState(CompButton.ButtonState.NORMAL));
            if (this.shelfContainer.curInv > allowed) {
                this.shelfContainer.curInv = allowed;
                this.field_146297_k.field_71442_b.func_78756_a(this.shelfContainer.field_75152_c, this.shelfContainer.curInv);
            }
            this.tabButtons.get(this.shelfContainer.curInv).setCurrentState(CompButton.ButtonState.ACTIVE);
        }
        for (int i = allowed + 1; i < this.tabButtons.size(); ++i) {
            this.tabButtons.get(i).setCurrentState(CompButton.ButtonState.DISABLED);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void func_73869_a(char letter, int num) {
        int oldLength = this.textField.func_146179_b().length();
        if (this.textField.func_146201_a(letter, num)) {
            this.slotRenewal = this.textField.func_146179_b().length() > oldLength ? Math.max(this.slotRenewal, 1) : 2;
        } else {
            super.func_73869_a(letter, num);
        }
    }
}

