/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompButtonRedstoneControl;
import com.cout970.magneticraft.client.gui.component.CompHeatBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.tileentity.TileGeothermalPump;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiGeothermalPump
extends GuiBasic {
    public GuiGeothermalPump(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponents() {
        this.comp.add(new CompBackground(new ResourceLocation("magneticraft:textures/gui/geothermal.png")));
        this.comp.add(new CompHeatBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/heatbar.png"), new GuiPoint(107, 20), ((TileGeothermalPump)this.tile).heat));
        this.comp.add(new CompLavaStorage(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/lavabar.png"), new GuiPoint(98, 20)));
        this.comp.add(new CompButtonRedstoneControl(new GuiPoint(150, 8)));
    }

    public class CompLavaStorage
    implements IGuiComp {
        public ResourceLocation texture;
        public GuiPoint pos;

        public CompLavaStorage(ResourceLocation tex, GuiPoint p) {
            this.texture = tex;
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileGeothermalPump) {
                TileGeothermalPump c = (TileGeothermalPump)tile;
                float prod = (float)c.buffer / 20000.0f;
                int scale = (int)(44.0f * prod);
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
            }
        }

        @Override
        public void onClick(int mx, int my, int button, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileGeothermalPump) {
                TileGeothermalPump c = (TileGeothermalPump)tile;
                if (GuiBasic.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 6, 44)) {
                    ArrayList<String> data = new ArrayList<String>();
                    float prod = (float)c.buffer / 20000.0f;
                    data.add("Buffer " + (int)(prod * 1000.0f) + " mB");
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }
}

