/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.util;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VectorOffset;
import java.util.HashSet;
import java.util.LinkedList;

public abstract class PathFinder {
    public LinkedList<VectorOffset> scanPosition;
    public HashSet<VecInt> scanMap;

    public void init() {
        this.scanPosition = new LinkedList();
        this.scanMap = new HashSet();
    }

    public void addBlock(VectorOffset v) {
        if (!this.scanMap.contains(v.getCoords())) {
            this.scanPosition.addLast(v);
            this.scanMap.add(v.getCoords());
        }
    }

    public void addNeigBlocks(VecInt pos) {
        for (MgDirection d : MgDirection.values()) {
            this.addBlock(new VectorOffset(d.toVecInt().add(pos), d.toVecInt()));
        }
    }

    public abstract boolean step(VectorOffset var1);

    public boolean iterate() {
        if (this.scanPosition.size() == 0) {
            return false;
        }
        VectorOffset vec = this.scanPosition.removeFirst();
        return this.step(vec);
    }
}

