/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.util;

import buildcraft.api.tools.IToolWrench;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cofh.api.item.IToolHammer;
import com.cout970.magneticraft.Magneticraft;
import com.cout970.magneticraft.api.computer.IOpticFiber;
import com.cout970.magneticraft.api.tool.IWrench;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MgUtils {
    private MgUtils() {
    }

    public static TileEntity getTileEntity(TileEntity tile, VecInt d) {
        if (!tile.func_145831_w().func_72899_e(tile.field_145851_c + d.getX(), tile.field_145848_d + d.getY(), tile.field_145849_e + d.getZ())) {
            return null;
        }
        return tile.func_145831_w().func_147438_o(tile.field_145851_c + d.getX(), tile.field_145848_d + d.getY(), tile.field_145849_e + d.getZ());
    }

    public static TileEntity getTileEntity(TileEntity tile, MgDirection d) {
        if (!tile.func_145831_w().func_72899_e(tile.field_145851_c + d.getOffsetX(), tile.field_145848_d + d.getOffsetY(), tile.field_145849_e + d.getOffsetZ())) {
            return null;
        }
        return tile.func_145831_w().func_147438_o(tile.field_145851_c + d.getOffsetX(), tile.field_145848_d + d.getOffsetY(), tile.field_145849_e + d.getOffsetZ());
    }

    public static List<TileEntity> getNeig(TileEntity t) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (MgDirection d : MgDirection.values()) {
            TileEntity f = MgUtils.getTileEntity(t, d);
            if (f == null) continue;
            list.add(f);
        }
        return list;
    }

    public static boolean isMineableBlock(World w, BlockInfo info) {
        return info.getBlock() != Blocks.field_150350_a && !(info.getBlock() instanceof BlockLiquid) && !(info.getBlock() instanceof BlockFluidBase) && !Block.func_149680_a((Block)info.getBlock(), (Block)Blocks.field_150474_ac) && info.getBlock() != Blocks.field_150427_aO && info.getBlock() != Blocks.field_150384_bq && info.getBlock() != Blocks.field_150378_br && info.getBlock().func_149712_f(w, info.getX(), info.getY(), info.getZ()) != -1.0f;
    }

    public static boolean areEqual(FluidStack a, FluidStack b) {
        return a == null && b == null || a != null && b != null && FluidRegistry.getFluidName((FluidStack)a).equalsIgnoreCase(FluidRegistry.getFluidName((FluidStack)b));
    }

    public static boolean areEqual(ItemStack a, ItemStack b, boolean meta) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null && a.func_77973_b() != null && b.func_77973_b() != null) {
            if (OreDictionary.itemMatches((ItemStack)a, (ItemStack)b, (boolean)meta)) {
                return true;
            }
            int[] c = OreDictionary.getOreIDs((ItemStack)a);
            int[] d = OreDictionary.getOreIDs((ItemStack)b);
            if (c.length > 0 && d.length > 0) {
                for (int i : c) {
                    for (int j : d) {
                        if (i != j) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static TileEntity getTileEntity(World w, VecInt v) {
        return w.func_147438_o(v.getX(), v.getY(), v.getZ());
    }

    public static boolean contains(MgDirection[] vec, MgDirection d) {
        for (MgDirection dir : vec) {
            if (dir != d) continue;
            return true;
        }
        return false;
    }

    public static IOpticFiber getOpticFiber(TileEntity tile, MgDirection dir) {
        if (tile instanceof TileMultipart) {
            for (TMultiPart p : ((TileMultipart)tile).jPartList()) {
                if (!(p instanceof IOpticFiber)) continue;
                return (IOpticFiber)p;
            }
        }
        return null;
    }

    public static boolean isWrench(ItemStack is) {
        return is != null && MgUtils.isWrench(is.func_77973_b());
    }

    public static boolean isWrench(Item item) {
        return item instanceof IWrench || Magneticraft.BUILDCRAFT && item instanceof IToolWrench || Magneticraft.COFH_TOOLS && item instanceof IToolHammer;
    }

    public static boolean matchesPattern(ItemStack stack, String pattern) {
        String realPattern = ".*(?i:" + pattern + ").*";
        try {
            Pattern.compile(realPattern);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        if (StringUtils.func_151246_b((String)pattern)) {
            return true;
        }
        if (stack != null && stack.func_82833_r().matches(realPattern)) {
            return true;
        }
        return IntStream.of(OreDictionary.getOreIDs((ItemStack)stack)).mapToObj(OreDictionary::getOreName).anyMatch(s -> s.matches(realPattern));
    }
}

