/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.util;

import com.cout970.magneticraft.api.util.VecInt;
import net.minecraftforge.common.util.ForgeDirection;

public enum MgDirection {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0);

    public static final MgDirection[] VALID_DIRECTIONS;
    public static final MgDirection[] AXIX_X;
    public static final MgDirection[] AXIX_Y;
    public static final MgDirection[] AXIX_Z;
    public static final MgDirection[] OPPOSITES;
    public static final MgDirection[] CARDINAL_DIRECTIONS;
    public static final int[][] rotation;
    private final VecInt offsets;

    private MgDirection(int x, int y, int z) {
        this.offsets = new VecInt(x, y, z);
    }

    public int getOffsetX() {
        return this.offsets.getX();
    }

    public int getOffsetY() {
        return this.offsets.getY();
    }

    public int getOffsetZ() {
        return this.offsets.getZ();
    }

    public MgDirection opposite() {
        return OPPOSITES[this.ordinal()];
    }

    public static MgDirection getDirection(int i) {
        return MgDirection.values()[i % VALID_DIRECTIONS.length];
    }

    public static MgDirection getDirectionFromCardinal(int c) {
        return CARDINAL_DIRECTIONS[c % 4];
    }

    public VecInt toVecInt() {
        return this.offsets.copy();
    }

    public ForgeDirection toForgeDir() {
        return ForgeDirection.getOrientation((int)this.ordinal());
    }

    public MgDirection step(MgDirection axix) {
        return MgDirection.getDirection(rotation[axix.ordinal()][this.ordinal()]);
    }

    public boolean isPerpendicular(MgDirection dir) {
        return Math.abs(dir.getOffsetX()) != Math.abs(this.getOffsetX()) || Math.abs(dir.getOffsetY()) != Math.abs(this.getOffsetY()) || Math.abs(dir.getOffsetZ()) != Math.abs(this.getOffsetZ());
    }

    public boolean isParallel(MgDirection dir) {
        return !this.isPerpendicular(dir);
    }

    public static MgDirection getDirectionFromRotaton(float cameraYaw) {
        float yaw = MgDirection.wrapTo180(cameraYaw);
        if (yaw > -135.0f && yaw <= -45.0f) {
            return EAST;
        }
        if (yaw > -45.0f && yaw <= 45.0f) {
            return SOUTH;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return WEST;
        }
        return NORTH;
    }

    private static float wrapTo180(float angle) {
        if ((angle %= 360.0f) >= 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    static {
        VALID_DIRECTIONS = new MgDirection[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        AXIX_X = new MgDirection[]{DOWN, UP, NORTH, SOUTH};
        AXIX_Y = new MgDirection[]{NORTH, SOUTH, WEST, EAST};
        AXIX_Z = new MgDirection[]{DOWN, UP, WEST, EAST};
        OPPOSITES = new MgDirection[]{UP, DOWN, SOUTH, NORTH, EAST, WEST};
        CARDINAL_DIRECTIONS = new MgDirection[]{SOUTH, WEST, NORTH, EAST};
        rotation = new int[][]{{0, 1, 5, 4, 2, 3}, {0, 1, 4, 5, 3, 2}, {5, 4, 2, 3, 0, 1}, {4, 5, 2, 3, 1, 0}, {2, 3, 1, 0, 4, 5}, {3, 2, 0, 1, 4, 5}, {0, 1, 2, 3, 4, 5}};
    }
}

