/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.prefab;

import com.cout970.magneticraft.api.electricity.ElectricConstants;
import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricPole;
import com.cout970.magneticraft.api.electricity.IInterPoleWire;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class InterPoleWire
implements IInterPoleWire {
    protected World w;
    protected VecInt start;
    protected VecInt end;
    protected IElectricPole cache_start;
    protected IElectricPole cache_end;
    protected double distance;
    protected double energyFlow;

    public InterPoleWire(VecInt s, VecInt e) {
        this.start = s;
        this.end = e;
        VecDouble vec = new VecDouble(s).add(new VecDouble(e).getOpposite());
        this.distance = vec.mag();
    }

    public InterPoleWire() {
    }

    @Override
    public void iterate() {
        InterPoleWire.valanceConductors(this);
    }

    @Override
    public double getEnergyFlow() {
        return this.energyFlow;
    }

    @Override
    public void setEnergyFlow(double energyFlow) {
        this.energyFlow = energyFlow;
    }

    @Override
    public IElectricPole getStart() {
        if (this.cache_start == null) {
            this.cache_start = ElectricUtils.getElectricPole(this.start.getTileEntity(this.w));
        }
        return this.cache_start;
    }

    @Override
    public IElectricPole getEnd() {
        if (this.cache_end == null) {
            this.cache_end = ElectricUtils.getElectricPole(this.end.getTileEntity(this.w));
        }
        return this.cache_end;
    }

    @Override
    public VecInt vecStart() {
        return this.start.copy();
    }

    @Override
    public VecInt vecEnd() {
        return this.end.copy();
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        this.start.save(nbt, "Start");
        this.end.save(nbt, "End");
        nbt.func_74780_a("EnergyFlow", this.energyFlow);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.start = new VecInt(nbt, "Start");
        this.end = new VecInt(nbt, "End");
        this.energyFlow = nbt.func_74769_h("EnergyFlow");
        VecDouble vec = new VecDouble(this.start).add(new VecDouble(this.end).getOpposite());
        this.distance = vec.mag();
    }

    public static void valanceConductors(IInterPoleWire con) {
        if (con.getStart() == null || con.getEnd() == null) {
            return;
        }
        double resistance = con.getDistance() * ElectricConstants.RESISTANCE_COPPER_WIRE;
        IElectricConductor cond_start = con.getStart().getConductor();
        IElectricConductor cond_end = con.getEnd().getConductor();
        double deltaV = cond_start.getVoltage() - cond_end.getVoltage();
        if (Double.isNaN(con.getEnergyFlow())) {
            con.setEnergyFlow(0.0);
        }
        double current = con.getEnergyFlow();
        double vDiff = deltaV - current * resistance;
        vDiff = Math.min(vDiff, Math.abs(deltaV));
        vDiff = Math.max(vDiff, -Math.abs(deltaV));
        con.setEnergyFlow(con.getEnergyFlow() + vDiff * cond_start.getIndScale() / cond_start.getVoltageMultiplier());
        cond_start.applyCurrent(-(current += deltaV * cond_start.getCondParallel() / cond_start.getVoltageMultiplier()));
        cond_end.applyCurrent(current);
    }

    @Override
    public void setWorld(World w) {
        this.w = w;
    }

    @Override
    public World getWorld() {
        return this.w;
    }
}

